/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.natamus.collective_common_neoforge.config.CollectiveConfigHandler;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class FABFunctions {
    private static final Map<Block, WeakHashMap<Level, List<BlockPos>>> getMapFromBlock = new HashMap<Block, WeakHashMap<Level, List<BlockPos>>>();
    private static final WeakHashMap<Level, Map<Date, BlockPos>> timeoutpositions = new WeakHashMap();

    public static List<BlockEntity> getBlockEntitiesAroundPosition(Level level, BlockPos pos, Integer radius) {
        ArrayList<BlockEntity> blockentities = new ArrayList<BlockEntity>();
        int chunkradius = (int)Math.ceil((double)radius.intValue() / 16.0);
        int chunkPosX = pos.getX() >> 4;
        int chunkPosZ = pos.getZ() >> 4;
        for (int x = chunkPosX - chunkradius; x < chunkPosX + chunkradius; ++x) {
            for (int z = chunkPosZ - chunkradius; z < chunkPosZ + chunkradius; ++z) {
                LevelChunk levelChunk = level.getChunk(x, z);
                if (!level.isLoaded(levelChunk.getPos().getWorldPosition())) continue;
                for (BlockEntity be : levelChunk.getBlockEntities().values()) {
                    if (blockentities.contains(be)) continue;
                    blockentities.add(be);
                }
            }
        }
        return blockentities;
    }

    public static List<BlockPos> getAllTaggedTileEntityPositionsNearbyEntity(TagKey<Block> tetag, Integer radius, Level level, Entity entity) {
        return FABFunctions.getAllTaggedTileEntityPositionsNearbyPosition(tetag, radius, level, entity.blockPosition());
    }

    public static List<BlockPos> getAllTaggedTileEntityPositionsNearbyPosition(TagKey<Block> tetag, Integer radius, Level level, BlockPos pos) {
        ArrayList<BlockPos> nearbypositions = new ArrayList<BlockPos>();
        List<BlockEntity> blockentities = FABFunctions.getBlockEntitiesAroundPosition(level, pos, radius);
        for (BlockEntity loadedtileentity : blockentities) {
            BlockPos ltepos;
            BlockState loadedtilestate = loadedtileentity.getBlockState();
            if (loadedtilestate == null || !loadedtilestate.is(tetag) || !(ltepos = loadedtileentity.getBlockPos()).closerThan(new Vec3i(pos.getX(), pos.getY(), pos.getZ()), (double)radius.intValue())) continue;
            nearbypositions.add(loadedtileentity.getBlockPos());
        }
        return nearbypositions;
    }

    public static List<BlockPos> getAllTileEntityPositionsNearbyEntity(BlockEntityType<?> tetype, Integer radius, Level level, Entity entity) {
        return FABFunctions.getAllTileEntityPositionsNearbyPosition(tetype, radius, level, entity.blockPosition());
    }

    public static List<BlockPos> getAllTileEntityPositionsNearbyPosition(BlockEntityType<?> tetype, Integer radius, Level level, BlockPos pos) {
        ArrayList<BlockPos> nearbypositions = new ArrayList<BlockPos>();
        List<BlockEntity> blockentities = FABFunctions.getBlockEntitiesAroundPosition(level, pos, radius);
        for (BlockEntity loadedtileentity : blockentities) {
            BlockPos ltepos;
            BlockEntityType loadedtiletype = loadedtileentity.getType();
            if (loadedtiletype == null || !loadedtiletype.equals(tetype) || !(ltepos = loadedtileentity.getBlockPos()).closerThan(new Vec3i(pos.getX(), pos.getY(), pos.getZ()), (double)radius.intValue())) continue;
            nearbypositions.add(loadedtileentity.getBlockPos());
        }
        return nearbypositions;
    }

    /*
     * WARNING - void declaration
     */
    public static BlockPos getRequestedBlockAroundEntitySpawn(Block rawqueryblock, Integer radius, Double radiusmodifier, Level level, Entity entity) {
        Map<Object, Object> timeouts;
        List<Object> currentblocks;
        Block requestedblock = FABFunctions.processCommonBlock(rawqueryblock);
        WeakHashMap<Level, List<BlockPos>> levelblocks = FABFunctions.getMap(requestedblock);
        BlockPos epos = entity.blockPosition();
        Vec3i removeblockpos = null;
        if (levelblocks.containsKey(level)) {
            currentblocks = levelblocks.get(level);
            ArrayList<BlockPos> cbtoremove = new ArrayList<BlockPos>();
            for (BlockPos blockPos : currentblocks) {
                if (!level.getChunkSource().hasChunk(blockPos.getX() >> 4, blockPos.getZ() >> 4)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!level.getBlockState(blockPos).getBlock().equals(requestedblock)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!blockPos.closerThan((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                return blockPos.immutable();
            }
            if (!cbtoremove.isEmpty()) {
                for (BlockPos blockPos : cbtoremove) {
                    currentblocks.remove(blockPos);
                }
            }
        } else {
            currentblocks = new ArrayList();
        }
        if (timeoutpositions.containsKey(level)) {
            timeouts = timeoutpositions.get(level);
            ArrayList<Date> totoremove = new ArrayList<Date>();
            if (!timeouts.isEmpty()) {
                Date date = new Date();
                for (Date date2 : timeouts.keySet()) {
                    long ms;
                    BlockPos toepos = (BlockPos)timeouts.get(date2);
                    if (removeblockpos != null && toepos.closerThan(removeblockpos, 64.0)) {
                        totoremove.add(date2);
                    }
                    if ((ms = date.getTime() - date2.getTime()) > (long)CollectiveConfigHandler.findABlockCheckAroundEntitiesDelayMs) {
                        totoremove.add(date2);
                        continue;
                    }
                    if (!toepos.closerThan((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                    return null;
                }
            }
            if (!totoremove.isEmpty()) {
                for (Date date : totoremove) {
                    timeouts.remove(date);
                }
            }
        } else {
            timeouts = new HashMap();
        }
        if (GlobalVariables.blocksWithTileEntity.containsKey(requestedblock)) {
            List<BlockEntity> blockentities = FABFunctions.getBlockEntitiesAroundPosition(level, epos, radius);
            BlockEntityType<?> blockEntityType = GlobalVariables.blocksWithTileEntity.get(requestedblock);
            for (BlockEntity blockEntity : blockentities) {
                BlockPos ltepos;
                BlockEntityType loadedtiletype = blockEntity.getType();
                if (loadedtiletype == null || !loadedtiletype.equals(blockEntityType) || !(ltepos = blockEntity.getBlockPos()).closerThan((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                currentblocks.add(ltepos.immutable());
                levelblocks.put(level, currentblocks);
                getMapFromBlock.put(requestedblock, levelblocks);
                return ltepos.immutable();
            }
        } else {
            void var12_22;
            int r = radius;
            int n = -r;
            while (var12_22 < r) {
                void var13_28;
                int n2 = -r;
                while (var13_28 < r) {
                    for (int i = -r; i < r; ++i) {
                        BlockPos cpos = epos.east((int)var12_22).north((int)var13_28).above(i);
                        BlockState state = level.getBlockState(cpos);
                        if (!state.getBlock().equals(requestedblock)) continue;
                        currentblocks.add(cpos.immutable());
                        levelblocks.put(level, currentblocks);
                        getMapFromBlock.put(requestedblock, levelblocks);
                        return cpos.immutable();
                    }
                    ++var13_28;
                }
                ++var12_22;
            }
        }
        timeouts.put(new Date(), epos.immutable());
        timeoutpositions.put(level, timeouts);
        return null;
    }

    public static BlockPos updatePlacedBlock(Block requestedblock, BlockPos bpos, Level level) {
        BlockState state = level.getBlockState(bpos);
        if (state.getBlock().equals(requestedblock)) {
            WeakHashMap<Level, List<BlockPos>> levelblocks = FABFunctions.getMap(requestedblock);
            List<Object> currentblocks = levelblocks.containsKey(level) ? levelblocks.get(level) : new ArrayList();
            if (!currentblocks.contains(bpos)) {
                currentblocks.add(bpos);
                levelblocks.put(level, currentblocks);
                getMapFromBlock.put(requestedblock, levelblocks);
            }
            return bpos;
        }
        return null;
    }

    private static WeakHashMap<Level, List<BlockPos>> getMap(Block requestedblock) {
        WeakHashMap<Object, Object> levelblocks = getMapFromBlock.containsKey(requestedblock) ? getMapFromBlock.get(requestedblock) : new WeakHashMap();
        return levelblocks;
    }

    private static Block processCommonBlock(Block requestedblock) {
        Block blocktoreturn = requestedblock;
        if (requestedblock instanceof StandingSignBlock || requestedblock instanceof WallSignBlock) {
            blocktoreturn = Blocks.OAK_SIGN;
        }
        return blocktoreturn;
    }
}

