/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Vec3f {
    public static final Codec<Vec3f> FLOAT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.FLOAT.fieldOf("x").forGetter(get -> Float.valueOf(get.x)), (App)PrimitiveCodec.FLOAT.fieldOf("y").forGetter(get -> Float.valueOf(get.y)), (App)PrimitiveCodec.FLOAT.fieldOf("z").forGetter(get -> Float.valueOf(get.z))).apply((Applicative)inst, Vec3f::new));
    public static final Codec<Vec3f> DOUBLE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.DOUBLE.fieldOf("x").forGetter(get -> get.x), (App)PrimitiveCodec.DOUBLE.fieldOf("y").forGetter(get -> get.y), (App)PrimitiveCodec.DOUBLE.fieldOf("z").forGetter(get -> get.z)).apply((Applicative)inst, Vec3f::new));
    public static final Codec<Vec3f> CODEC = FLOAT_CODEC;
    public static final class_9139<@NotNull ByteBuf, @NotNull Vec3f> PACKET_CODEC = new class_9139<ByteBuf, Vec3f>(){

        public void encode(@Nonnull ByteBuf buf, Vec3f value) {
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.x));
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.y));
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.z));
        }

        @Nonnull
        public Vec3f decode(@Nonnull ByteBuf buf) {
            return new Vec3f(((Float)class_9135.field_48552.decode((Object)buf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)buf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)buf)).floatValue());
        }
    };
    public static final Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;

    public Vec3f(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Vec3f normalize() {
        return Vec3f.normalized(this.x, this.y, this.z);
    }

    public static Vec3f normalized(float x, float y, float z) {
        double d = Math.sqrt(x * x + y * y + z * z);
        return d < 1.0E-4 ? ZERO : new Vec3f((double)x / d, (double)y / d, (double)z / d);
    }

    public Vector3f toVector() {
        return new Vector3f(this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return "Vec3f{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

