/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.converter;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.EmptyData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import javax.annotation.Nullable;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class DataConverterNbt {
    @Nullable
    public static BaseData fromVanillaNbt(class_2520 vanillaTag) {
        if (vanillaTag == null) {
            return EmptyData.INSTANCE;
        }
        return switch (vanillaTag.method_10711()) {
            case 1 -> new ByteData(((class_2481)vanillaTag).comp_3817());
            case 2 -> new ShortData(((class_2516)vanillaTag).comp_3822());
            case 3 -> new IntData(((class_2497)vanillaTag).comp_3820());
            case 4 -> new LongData(((class_2503)vanillaTag).comp_3821());
            case 5 -> new FloatData(((class_2494)vanillaTag).comp_3819());
            case 6 -> new DoubleData(((class_2489)vanillaTag).comp_3818());
            case 8 -> new StringData(((class_2519)vanillaTag).comp_3831());
            case 7 -> new ByteArrayData(((class_2479)vanillaTag).method_10521());
            case 11 -> new IntArrayData(((class_2495)vanillaTag).method_10588());
            case 12 -> new LongArrayData(((class_2501)vanillaTag).method_10615());
            case 10 -> DataConverterNbt.fromVanillaCompound(vanillaTag.method_68571().orElse(new class_2487()));
            case 9 -> DataConverterNbt.fromVanillaList(vanillaTag.method_68592().orElse(new class_2499()));
            default -> EmptyData.INSTANCE;
        };
    }

    public static ListData fromVanillaList(class_2499 vanillaList) {
        ListData list = new ListData();
        if (vanillaList == null || vanillaList.isEmpty()) {
            return list;
        }
        for (int index = 0; index < vanillaList.size(); ++index) {
            class_2520 entry = vanillaList.method_10534(index);
            if (entry == null) continue;
            if (entry.method_10711() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return list;
            }
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(entry);
            if (convertedTag == null) continue;
            list.add(convertedTag);
        }
        return list;
    }

    public static CompoundData fromVanillaCompound(class_2487 vanillaCompound) {
        CompoundData data = new CompoundData();
        if (vanillaCompound == null || vanillaCompound.method_33133()) {
            return data;
        }
        for (String key : vanillaCompound.method_10541()) {
            BaseData convertedTag;
            class_2520 ele = vanillaCompound.method_10580(key);
            if (ele == null || (convertedTag = DataConverterNbt.fromVanillaNbt(ele)) == null) continue;
            data = data.put(key, convertedTag);
        }
        return data;
    }

    @Nullable
    public static class_2520 toVanillaNbt(BaseData data) {
        if (data == null) {
            return class_2491.field_21033;
        }
        return switch (data.getType()) {
            case 1 -> class_2481.method_23233((byte)((ByteData)data).value);
            case 2 -> class_2516.method_23254((short)((ShortData)data).value);
            case 3 -> class_2497.method_23247((int)((IntData)data).value);
            case 4 -> class_2503.method_23251((long)((LongData)data).value);
            case 5 -> class_2494.method_23244((float)((FloatData)data).value);
            case 6 -> class_2489.method_23241((double)((DoubleData)data).value);
            case 8 -> class_2519.method_23256((String)((StringData)data).value);
            case 7 -> new class_2479(((ByteArrayData)data).value);
            case 11 -> new class_2495(((IntArrayData)data).value);
            case 12 -> new class_2501(((LongArrayData)data).value);
            case 10 -> DataConverterNbt.toVanillaCompound((CompoundData)data);
            case 9 -> DataConverterNbt.toVanillaList((ListData)data);
            default -> class_2491.field_21033;
        };
    }

    public static class_2499 toVanillaList(ListData listData) {
        class_2499 list = new class_2499();
        if (listData == null || listData.isEmpty()) {
            return list;
        }
        for (int index = 0; index < listData.size(); ++index) {
            BaseData entry = listData.get(index);
            if (entry == null) continue;
            if (entry.getType() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return list;
            }
            class_2520 convertedTag = DataConverterNbt.toVanillaNbt(entry);
            if (convertedTag == null) continue;
            list.add((Object)convertedTag);
        }
        return list;
    }

    public static class_2487 toVanillaCompound(CompoundData compoundData) {
        class_2487 tag = new class_2487();
        if (compoundData == null || compoundData.isEmpty()) {
            return tag;
        }
        for (String key : compoundData.getKeys()) {
            BaseData data = compoundData.getData(key).orElse(null);
            if (data == null) continue;
            class_2520 convertedTag = DataConverterNbt.toVanillaNbt(data);
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaCompound:B: Got a null tag in a compound with key {}", (Object)key);
                continue;
            }
            tag.method_10566(key, convertedTag);
        }
        return tag;
    }
}

