/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_10192;
import net.minecraft.class_10590;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1743;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8162;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9362;
import net.minecraft.class_9424;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentUtils {
    public static boolean isAnyWeapon(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isMeleeWeapon(stack) || EquipmentUtils.isRangedWeapon(stack) || EquipmentUtils.isTrident(stack) || EquipmentUtils.isMace(stack);
    }

    public static boolean isMeleeWeapon(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_9362 || item instanceof class_1743) {
            return true;
        }
        if (item instanceof class_1811 || item instanceof class_1835) {
            return false;
        }
        return (stack.method_31573(class_3489.field_48305) || EquipmentUtils.isSword(stack) || EquipmentUtils.isAxe(stack) || EquipmentUtils.isMace(stack) || EquipmentUtils.isSpear(stack)) && stack.method_57826(class_9334.field_55878);
    }

    public static boolean isSword(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_sword");
    }

    public static boolean isAxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_axe");
    }

    public static boolean isSpear(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_spear");
    }

    public static boolean isMace(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_9362;
    }

    public static boolean isRangedWeapon(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1811 || EquipmentUtils.isTrident(stack);
    }

    public static boolean isTrident(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1835;
    }

    public static boolean isAnyTool(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isRegularTool(stack) || EquipmentUtils.isMiscTool(stack);
    }

    public static boolean isRegularTool(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return (stack.method_31573(class_3489.field_48306) || EquipmentUtils.isPickAxe(stack) || EquipmentUtils.isAxe(stack) || EquipmentUtils.isHoe(stack) || EquipmentUtils.isShovel(stack)) && stack.method_57826(class_9334.field_50077);
    }

    public static boolean isPickAxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_pickaxe");
    }

    public static boolean isShovel(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_shovel");
    }

    public static boolean isHoe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("_hoe");
    }

    public static boolean isMiscTool(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isShears(stack) || EquipmentUtils.isFlintAndSteel(stack) || EquipmentUtils.isFishingRod(stack) || EquipmentUtils.isBrush(stack);
    }

    public static boolean isShears(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1820;
    }

    public static boolean isFlintAndSteel(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1786;
    }

    public static boolean isFishingRod(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1787;
    }

    public static boolean isBrush(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_8162;
    }

    public static Pair<Integer, Float> getWeaponData(class_1799 stack) {
        class_10590 weaponComponent;
        if (stack == null || stack.method_7960()) {
            return Pair.of((Object)-1, (Object)Float.valueOf(0.0f));
        }
        if (stack.method_57826(class_9334.field_55878) && (weaponComponent = (class_10590)stack.method_58694(class_9334.field_55878)) != null) {
            return Pair.of((Object)weaponComponent.comp_3481(), (Object)Float.valueOf(weaponComponent.comp_3602()));
        }
        return Pair.of((Object)-1, (Object)Float.valueOf(0.0f));
    }

    public static Pair<Double, Double> getDamageAndSpeedAttributes(class_1799 stack) {
        class_9285 attrib;
        double speed = -1.0;
        double damage = -1.0;
        if (stack == null || stack.method_7960()) {
            return Pair.of((Object)damage, (Object)speed);
        }
        if (stack.method_57826(class_9334.field_49636) && (attrib = (class_9285)stack.method_58694(class_9334.field_49636)) != null) {
            for (class_9285.class_9287 entry : attrib.comp_2393()) {
                if (entry.comp_2395().equals((Object)class_5134.field_23721)) {
                    damage = entry.comp_2396().comp_2449();
                    continue;
                }
                if (!entry.comp_2395().equals((Object)class_5134.field_23723)) continue;
                speed = entry.comp_2396().comp_2449();
            }
        }
        return Pair.of((Object)damage, (Object)speed);
    }

    public static boolean isCorrectTool(class_1799 stack, @Nonnull class_2680 state) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_50077)) {
            class_9424 toolComponent = (class_9424)stack.method_58694(class_9334.field_50077);
            return toolComponent != null && toolComponent.method_58426(state);
        }
        return false;
    }

    public static float getMiningSpeed(class_1799 stack, @Nullable class_2680 state) {
        class_9424 toolComponent;
        if (stack == null || stack.method_7960()) {
            return -1.0f;
        }
        if (stack.method_57826(class_9334.field_50077) && (toolComponent = (class_9424)stack.method_58694(class_9334.field_50077)) != null) {
            if (state != null) {
                return toolComponent.method_58425(state);
            }
            return toolComponent.comp_2499();
        }
        return -1.0f;
    }

    public static boolean isAnyArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isHumanoidArmor(stack) || EquipmentUtils.isShield(stack) || EquipmentUtils.isAnyAnimalArmor(stack);
    }

    public static boolean isShield(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909() instanceof class_1819;
    }

    public static boolean isHumanoidArmor(class_1799 stack) {
        class_9285 attrib;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636) && (attrib = (class_9285)stack.method_58694(class_9334.field_49636)) != null) {
            for (class_9285.class_9287 entry : attrib.comp_2393()) {
                if (!entry.comp_2395().equals((Object)class_5134.field_23724) || entry.comp_2397() == class_9274.field_49217 || entry.comp_2397() == class_9274.field_49218) continue;
                return true;
            }
        }
        return stack.method_31573(class_3489.field_48312);
    }

    public static boolean matchArmorSlot(class_1799 stack, @Nonnull class_1304 slot) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636)) {
            class_9285 attrib = (class_9285)stack.method_58694(class_9334.field_49636);
            class_9274 attributeSlot = class_9274.method_59524((class_1304)slot);
            if (attrib != null) {
                for (class_9285.class_9287 entry : attrib.comp_2393()) {
                    if (!entry.comp_2395().equals((Object)class_5134.field_23724) || entry.comp_2397() != attributeSlot) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAnyAnimalArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return Objects.equals(EquipmentUtils.getEquipmentSlot(stack), class_9274.field_50127);
    }

    public static boolean isHorseArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636)) {
            class_9285 attrib = (class_9285)stack.method_58694(class_9334.field_49636);
            class_10192 equip = (class_10192)stack.method_58694(class_9334.field_54196);
            if (attrib != null && equip != null) {
                boolean bodySlot = false;
                for (class_9285.class_9287 entry : attrib.comp_2393()) {
                    if (!entry.comp_2395().equals((Object)class_5134.field_23724) || !entry.comp_2397().equals((Object)class_9274.field_50127)) continue;
                    bodySlot = true;
                    break;
                }
                return bodySlot && (equip.method_64015(class_1299.field_6139) || equip.method_64015(class_1299.field_6048));
            }
        }
        return false;
    }

    public static boolean isNautilusArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636)) {
            class_9285 attrib = (class_9285)stack.method_58694(class_9334.field_49636);
            class_10192 equip = (class_10192)stack.method_58694(class_9334.field_54196);
            if (attrib != null && equip != null) {
                boolean bodySlot = false;
                for (class_9285.class_9287 entry : attrib.comp_2393()) {
                    if (!entry.comp_2395().equals((Object)class_5134.field_23724) || !entry.comp_2397().equals((Object)class_9274.field_50127)) continue;
                    bodySlot = true;
                    break;
                }
                return bodySlot && (equip.method_64015(class_1299.field_63289) || equip.method_64015(class_1299.field_63290));
            }
        }
        return false;
    }

    public static boolean isWolfArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636)) {
            class_9285 attrib = (class_9285)stack.method_58694(class_9334.field_49636);
            class_10192 equip = (class_10192)stack.method_58694(class_9334.field_54196);
            if (attrib != null && equip != null) {
                boolean bodySlot = false;
                for (class_9285.class_9287 entry : attrib.comp_2393()) {
                    if (!entry.comp_2395().equals((Object)class_5134.field_23724) || !entry.comp_2397().equals((Object)class_9274.field_50127)) continue;
                    bodySlot = true;
                    break;
                }
                return bodySlot && equip.method_64015(class_1299.field_6055);
            }
        }
        return false;
    }

    @Nullable
    public static class_9274 getEquipmentSlot(class_1799 stack) {
        class_9285 attrib;
        if (stack == null || stack.method_7960()) {
            return null;
        }
        if (stack.method_57826(class_9334.field_54196) && stack.method_57826(class_9334.field_49636) && (attrib = (class_9285)stack.method_58694(class_9334.field_49636)) != null) {
            for (class_9285.class_9287 entry : attrib.comp_2393()) {
                if (!entry.comp_2395().equals((Object)class_5134.field_23724)) continue;
                return entry.comp_2397();
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static int getEnchantmentLevel(class_1799 stack, @Nonnull class_5321<@NotNull class_1887> enchantment) {
        if (stack == null || stack.method_7960()) {
            return -1;
        }
        class_9304 enchants = stack.method_58657();
        if (!enchants.equals((Object)class_9304.field_49385)) {
            @NotNull Set enchantList = enchants.method_57534();
            for (class_6880 entry : enchantList) {
                if (!entry.method_40225(enchantment)) continue;
                return enchants.method_57536(entry);
            }
        }
        return -1;
    }

    public static int hasSameOrBetterEnchantment(class_1799 testedStack, class_1799 previous, class_5321<@NotNull class_1887> enchantment) {
        return EquipmentUtils.getEnchantmentLevel(testedStack, enchantment) - EquipmentUtils.getEnchantmentLevel(previous, enchantment);
    }

    public static boolean hasSilkTouch(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9099) > 0;
    }

    public static boolean hasFortune(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9130) > 0;
    }

    public static boolean hasMending(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9101) > 0;
    }

    public static boolean hasUnbreaking(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9119) > 0;
    }

    public static boolean hasLooting(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9110) > 0;
    }

    public static boolean hasSmite(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9123) > 0;
    }

    public static boolean hasSharpness(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9118) > 0;
    }

    public static boolean hasBane(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9112) > 0;
    }

    public static boolean hasImpaling(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9106) > 0;
    }

    public static boolean hasDensity(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_50157) > 0;
    }

    public static boolean hasLunge(class_1799 stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_63420) > 0;
    }

    public static boolean isSilkAxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isAxe(stack) && EquipmentUtils.hasSilkTouch(stack);
    }

    public static boolean isSilkHoe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isHoe(stack) && EquipmentUtils.hasSilkTouch(stack);
    }

    public static boolean isSilkPickaxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isPickAxe(stack) && EquipmentUtils.hasSilkTouch(stack);
    }

    public static boolean isFortuneAxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isAxe(stack) && EquipmentUtils.hasFortune(stack);
    }

    public static boolean isFortuneHoe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isHoe(stack) && EquipmentUtils.hasFortune(stack);
    }

    public static boolean isFortunePickaxe(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return EquipmentUtils.isPickAxe(stack) && EquipmentUtils.hasFortune(stack);
    }
}

