/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options.table.type;

import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;

public class IntegerEntry
extends Entry {
    private int value;

    public IntegerEntry(int value) {
        this.value = value;
    }

    public static IntegerEntry of(int val) {
        return new IntegerEntry(val);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public EntryTypes getType() {
        return EntryTypes.INTEGER;
    }

    @Override
    public JsonObject getAsJsonObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", "integer");
        obj.addProperty("value", String.valueOf(this.value));
        return obj;
    }

    @Override
    public Entry copy() {
        return new IntegerEntry(this.value);
    }

    @Override
    public boolean wasConfigModified(Entry entry) {
        if (!(entry instanceof IntegerEntry)) {
            return true;
        }
        IntegerEntry other = (IntegerEntry)entry;
        return this.value != other.value;
    }

    @Override
    public String asString() {
        return Integer.toString(this.getValue());
    }

    public static IntegerEntry getFromJsonObject(JsonObject obj) {
        try {
            int val = Integer.parseInt(obj.get("value").getAsString());
            return IntegerEntry.of(val);
        }
        catch (NumberFormatException e) {
            MaLiLib.LOGGER.error("Failed to parse integer from JSON object: [{}]; {}", (Object)obj, (Object)e.getLocalizedMessage());
            return IntegerEntry.of(0);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntegerEntry)) {
            return false;
        }
        IntegerEntry other = (IntegerEntry)o;
        return other.getValue() == this.getValue();
    }
}

