/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigLockedList;
import fi.dy.masa.malilib.config.IConfigLockedListEntry;
import fi.dy.masa.malilib.config.IConfigLockedListType;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class ConfigLockedList
extends ConfigBase<ConfigLockedList>
implements IConfigLockedList {
    IConfigLockedListType handler;
    ImmutableList<IConfigLockedListEntry> defaultList;
    List<IConfigLockedListEntry> values = new ArrayList<IConfigLockedListEntry>();

    public ConfigLockedList(String name, IConfigLockedListType handler) {
        this(name, handler, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigLockedList(String name, IConfigLockedListType handler, String comment) {
        this(name, handler, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigLockedList(String name, IConfigLockedListType handler, String comment, String prettyName) {
        this(name, handler, comment, prettyName, name);
    }

    public ConfigLockedList(String name, IConfigLockedListType handler, String comment, String prettyName, String translatedName) {
        super(ConfigType.LOCKED_LIST, name, comment, prettyName, translatedName);
        this.handler = handler;
        this.defaultList = handler.getDefaultEntries();
        this.values.addAll((Collection<IConfigLockedListEntry>)this.defaultList);
    }

    @Override
    public ImmutableList<IConfigLockedListEntry> getDefaultEntries() {
        return this.defaultList;
    }

    @Override
    public List<IConfigLockedListEntry> getEntries() {
        return this.values;
    }

    @Override
    public List<String> getConfigKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (IConfigLockedListEntry entry : this.values) {
            list.add(entry.getDisplayName());
        }
        return list;
    }

    @Override
    public void setEntries(List<IConfigLockedListEntry> entries) {
        if (!this.values.equals(entries)) {
            this.values.clear();
            entries.forEach(v -> {
                IConfigLockedListEntry entry = this.handler.fromString(v.getStringValue());
                if (entry != null) {
                    this.values.add(entry);
                }
            });
            this.onValueChanged();
        }
    }

    @Override
    @Nullable
    public IConfigLockedListEntry getEmpty() {
        return null;
    }

    @Override
    @Nullable
    public IConfigLockedListEntry getEntry(String key) {
        return this.handler.fromString(key);
    }

    @Override
    public int getEntryIndex(IConfigLockedListEntry entry) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).equals(entry)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setModified() {
        this.onValueChanged();
    }

    @Override
    public void resetToDefault() {
        this.setEntries((List<IConfigLockedListEntry>)this.defaultList);
    }

    @Override
    public boolean isModified() {
        return !this.values.equals(this.defaultList);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        this.values.clear();
        try {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ArrayList defList = new ArrayList(this.getDefaultEntries().stream().toList());
                ArrayList<IConfigLockedListEntry> list = new ArrayList<IConfigLockedListEntry>();
                for (int i = 0; i < array.size(); ++i) {
                    IConfigLockedListEntry entry = this.handler.fromString(array.get(i).getAsString());
                    if (entry == null || list.contains(entry)) continue;
                    list.add(entry);
                    defList.remove(entry);
                    this.markDirty();
                }
                if (!defList.isEmpty()) {
                    list.addAll(defList);
                    this.markDirty();
                }
                this.values.addAll(list);
                this.checkIfClean();
            } else {
                MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        ArrayList list = new ArrayList(this.getDefaultEntries().stream().toList());
        JsonArray array = new JsonArray();
        for (IConfigLockedListEntry val : this.values) {
            if (!list.contains(val)) continue;
            array.add((JsonElement)new JsonPrimitive(val.getStringValue()));
            list.remove(val);
        }
        if (!list.isEmpty()) {
            for (IConfigLockedListEntry entry : list) {
                array.add((JsonElement)new JsonPrimitive(entry.getStringValue()));
            }
        }
        return array;
    }
}

