/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.util;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class UUIDHelper {
    public static UUID getUUIDFromName(String username, @Nullable MinecraftServer server) {
        if (server != null) {
            class_3222 player = server.method_3760().method_74003(username);
            if (player != null) {
                return player.method_72498().comp_4422();
            }
        } else {
            class_640 playerInfo;
            class_634 handler = class_310.method_1551().method_1562();
            if (handler != null && (playerInfo = handler.method_2874(username)) != null) {
                return playerInfo.method_2966().id();
            }
        }
        return null;
    }

    public static String getNameFromUUID(UUID uuid, @Nullable MinecraftServer server) {
        if (server != null) {
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player != null) {
                return player.method_72498().comp_4423();
            }
        } else {
            class_640 playerInfo;
            class_634 handler = class_310.method_1551().method_1562();
            if (handler != null && (playerInfo = handler.method_2871(uuid)) != null) {
                return playerInfo.method_2966().name();
            }
        }
        return null;
    }

    public static UUID fromBytes(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void toBytes(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    private UUIDHelper() {
    }
}

