/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.PendingShareFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class CommandAccept {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode literalcommandnode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mapfrontiersaccept").requires(CommandAccept::checkPermission)).then(class_2170.method_9244((String)"invitation id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)999)).executes(commandSource -> CommandAccept.acceptInvitation((class_2168)commandSource.getSource(), IntegerArgumentType.getInteger((CommandContext)commandSource, (String)"invitation id")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mfaccept").requires(CommandAccept::checkPermission)).redirect((CommandNode)literalcommandnode));
    }

    public static int acceptInvitation(class_2168 source, int messageID) throws CommandSyntaxException {
        class_3218 world = source.method_9225();
        if (!world.method_8608()) {
            PendingShareFrontier pending = FrontiersManager.instance.getPendingShareFrontier(messageID);
            if (pending == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invitation expired"));
            } else {
                if (pending.targetUser.equals(new SettingsUser((class_1657)source.method_9207()))) {
                    FrontierData frontier = FrontiersManager.instance.getFrontierFromID(pending.frontierID);
                    if (frontier == null || !frontier.getPersonal()) {
                        FrontiersManager.instance.removePendingShareFrontier(messageID);
                        source.method_9213((class_2561)class_2561.method_43470((String)"The frontier no longer exists"));
                        return messageID;
                    }
                    SettingsUserShared userShared = frontier.getUserShared(pending.targetUser);
                    if (userShared == null) {
                        source.method_9213((class_2561)class_2561.method_43470((String)""));
                        return messageID;
                    }
                    if (FrontiersManager.instance.hasPersonalFrontier(pending.targetUser, frontier.getId())) {
                        FrontiersManager.instance.removePendingShareFrontier(messageID);
                        source.method_9213((class_2561)class_2561.method_43470((String)"You already have the frontier"));
                        return messageID;
                    }
                    FrontiersManager.instance.addPersonalFrontier(pending.targetUser, frontier);
                    userShared.setPending(false);
                    frontier.addChange(FrontierData.Change.Shared);
                    FrontiersManager.instance.removePendingShareFrontier(messageID);
                    PacketHandler.sendTo(new PacketFrontierCreated(frontier), source.method_9207());
                    PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(frontier), frontier, source.method_9211());
                    frontier.removeChange(FrontierData.Change.Shared);
                    source.method_9226(() -> class_2561.method_43470((String)("Accepting frontier " + frontier.getName1() + " " + frontier.getName2())), false);
                    return messageID;
                }
                source.method_9213((class_2561)class_2561.method_43470((String)"The invitation is for another player"));
                return messageID;
            }
        }
        return messageID;
    }

    public static boolean checkPermission(class_2168 source) {
        try {
            return FrontiersManager.instance.canSendCommandAcceptFrontier(source.method_9207());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }
}

