/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserSharedElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRemoveSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.util.Date;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ShareSettings
extends AutoScaledScreen {
    private static final class_2561 titleLabel = class_2561.method_43471((String)"mapfrontiers.title_share_settings");
    private static final class_2561 updateFrontierLabel = class_2561.method_43471((String)"mapfrontiers.update_frontier");
    private static final class_2561 updateSettingsLabel = class_2561.method_43471((String)"mapfrontiers.update_settings");
    private static final class_2561 errorUUIDSizeLabel = class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_size");
    private static final class_2561 errorUUIDFormatLabel = class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_format");
    private static final class_2561 errorUserNotFoundLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_not_found");
    private static final class_2561 errorSelfLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_self");
    private static final class_2561 errorOwnerLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_owner");
    private static final class_2561 errorRepeatedLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_repeated");
    private static final class_2561 doneLabel = class_2561.method_43471((String)"gui.done");
    private final FrontiersOverlayManager frontiersOverlayManager;
    private FrontierOverlay frontier;
    private class_7940 updateFrontier;
    private class_7940 updateSettings;
    private ScrollBox users;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private boolean canUpdate;
    private int ticksSinceLastUpdate = 0;

    public ShareSettings(FrontiersOverlayManager frontiersOverlayManager, FrontierOverlay frontier) {
        super(titleLabel, 470, 120);
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.frontier = frontier;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                this.method_25419();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
        });
    }

    @Override
    public void initScreen() {
        if (!MapFrontiersClient.isModOnServer()) {
            this.method_25419();
        }
        class_8667 mainLayout = class_8667.method_52741().method_52735(8);
        mainLayout.method_52740().method_46467();
        this.content.method_52736((class_8021)mainLayout);
        class_8667 header = class_8667.method_52742();
        mainLayout.method_52736((class_8021)header);
        this.updateFrontier = (class_7940)header.method_52736((class_8021)new class_7940((class_2561)updateFrontierLabel.method_27661().method_54663(-1), this.field_22793));
        this.updateFrontier.method_48981(true);
        this.updateSettings = (class_7940)header.method_52736((class_8021)new class_7940((class_2561)updateSettingsLabel.method_27661().method_54663(-1), this.field_22793));
        this.updateSettings.method_48981(true);
        this.users = new ScrollBox(this.actualHeight - 128, 430, 16);
        this.users.setElementDeletePressedCallback(element -> {
            if (Config.askConfirmationUserDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_user_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationUserDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteUserPressed((ScrollBox.ScrollElement)element);
                }).display();
            } else {
                this.deleteUserPressed((ScrollBox.ScrollElement)element);
            }
        });
        mainLayout.method_52736((class_8021)this.users);
        class_8667 newUserLayout = class_8667.method_52742().method_52735(4);
        mainLayout.method_52736((class_8021)newUserLayout);
        this.textNewUser = new TextBoxUser(this.minecraft, this.field_22793, 238);
        this.textNewUser.method_1880(38);
        this.textNewUser.setSubmitCallback(value -> this.buttonNewUserPressed());
        newUserLayout.method_52736((class_8021)this.textNewUser);
        this.buttonNewUser = new IconButton(IconButton.Type.Add, b -> this.buttonNewUserPressed());
        this.buttonNewUser.field_22764 = false;
        newUserLayout.method_52736((class_8021)this.buttonNewUser);
        this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 140, doneLabel, b -> this.method_25419()));
        this.updateCanUpdate();
        this.updateButtonsVisibility();
        this.updateUsers();
    }

    public void method_25393() {
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            class_634 handler = this.minecraft.method_1562();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserSharedElement userElement = (UserSharedElement)element;
                SettingsUser user = userElement.getUser();
                class_640 networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.method_2871(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.method_2874(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    @Override
    public void method_48640() {
        this.users.method_55445(430, this.actualHeight - 128);
        super.method_48640();
        this.updateFrontier.method_46421(this.users.method_46426() + 250 - this.updateFrontier.method_25368() / 2);
        this.updateSettings.method_46421(this.users.method_46426() + 310 - this.updateSettings.method_25368() / 2);
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.method_25368() + 20, this.content.method_25364() + 20);
    }

    @Override
    public boolean method_25406(class_11909 event) {
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.method_25406(event);
    }

    private void deleteUserPressed(ScrollBox.ScrollElement element) {
        this.users.removeElement(element);
        SettingsUser user = ((UserSharedElement)element).getUser();
        this.frontier.removeUserShared(user);
        PacketHandler.sendToServer(new PacketRemoveSharedUserPersonalFrontier(this.frontier.getId(), user));
        this.resetLabels();
    }

    private void buttonNewUserPressed() {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.method_1882();
        this.textNewUser.method_25365(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError(errorUUIDSizeLabel);
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError(errorUUIDFormatLabel);
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        class_634 handler = this.minecraft.method_1562();
        if (handler != null && handler.method_2871(user.uuid) == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (user.username.equals(this.minecraft.field_1724.method_7334().name())) {
            this.textNewUser.setError(errorSelfLabel);
            return;
        }
        if (this.frontier.getOwner().equals(user)) {
            this.textNewUser.setError(errorOwnerLabel);
            return;
        }
        if (this.frontier.hasUserShared(user)) {
            this.textNewUser.setError(errorRepeatedLabel);
            return;
        }
        SettingsUserShared userShared = new SettingsUserShared(user, true);
        this.frontier.addUserShared(userShared);
        this.frontiersOverlayManager.clientShareFrontier(this.frontier.getId(), user);
        UserSharedElement element = new UserSharedElement(this.field_22793, userShared, this.canUpdate, true, this::actionChanged);
        this.users.addElement(element);
        this.users.scrollBottom();
        this.textNewUser.method_1852("");
        this.resetLabels();
    }

    public void method_25419() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.method_25419();
    }

    private void resetLabels() {
        if (this.users.getElements().isEmpty()) {
            this.updateFrontier.field_22764 = false;
            this.updateSettings.field_22764 = false;
        } else {
            this.updateFrontier.field_22764 = true;
            this.updateSettings.field_22764 = true;
        }
    }

    private void updateButtonsVisibility() {
        this.buttonNewUser.field_22764 = this.canUpdate;
        this.textNewUser.field_22764 = this.canUpdate;
    }

    private void actionChanged(SettingsUserShared user, SettingsUserShared.Action action, boolean checked) {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        if (checked) {
            user.addAction(action);
        } else {
            user.removeAction(action);
        }
        if (user.getUser().equals(new SettingsUser((class_1657)this.minecraft.field_1724))) {
            if (action == SettingsUserShared.Action.UpdateSettings) {
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
            this.frontier.setModified(new Date());
            ClientEventHandler.postUpdatedFrontierEvent(this.frontier, -1);
        }
        PacketHandler.sendToServer(new PacketUpdateSharedUserPersonalFrontier(this.frontier.getId(), user));
    }

    private void updateUsers() {
        this.users.removeAll();
        if (this.minecraft.field_1724 == null) {
            return;
        }
        SettingsUser player = new SettingsUser((class_1657)this.minecraft.field_1724);
        if (this.frontier.getUsersShared() != null) {
            for (SettingsUserShared user : this.frontier.getUsersShared()) {
                this.users.addElement(new UserSharedElement(this.field_22793, user, this.canUpdate, !user.getUser().equals(player), this::actionChanged));
            }
        }
        this.resetLabels();
    }

    private void updateCanUpdate() {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        this.canUpdate = this.frontier.checkActionUserShared(new SettingsUser((class_1657)this.minecraft.field_1724), SettingsUserShared.Action.UpdateSettings);
    }
}

