/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.ChatFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_634;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class SendFrontier
extends AutoScaledScreen {
    private static final class_2561 titleLabel = class_2561.method_43471((String)"mapfrontiers.title_send");
    private static final class_2561 descriptionLabel = class_2561.method_43471((String)"mapfrontiers.send_description");
    private static final class_2561 errorUUIDSizeLabel = class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_size");
    private static final class_2561 errorUUIDFormatLabel = class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_format");
    private static final class_2561 errorUserNotFoundLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_not_found");
    private static final class_2561 errorSelfLabel = class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_self");
    private static final class_2561 doneLabel = class_2561.method_43471((String)"gui.done");
    private FrontierOverlay frontier;
    private class_7940 description;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;

    public SendFrontier(FrontierOverlay frontier) {
        super(titleLabel, 470, 120);
        this.frontier = frontier;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                this.method_25419();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
            }
        });
    }

    @Override
    public void initScreen() {
        if (MapFrontiersClient.isModOnServer()) {
            this.method_25419();
        }
        class_8667 mainLayout = class_8667.method_52741().method_52735(8);
        mainLayout.method_52740().method_46467();
        this.content.method_52736((class_8021)mainLayout);
        class_8667 header = class_8667.method_52742();
        mainLayout.method_52736((class_8021)header);
        this.description = (class_7940)header.method_52736((class_8021)new class_7940((class_2561)descriptionLabel.method_27661().method_54663(-1), this.field_22793));
        this.description.method_48981(true);
        class_8667 newUserLayout = class_8667.method_52742().method_52735(4);
        mainLayout.method_52736((class_8021)newUserLayout);
        this.textNewUser = new TextBoxUser(this.minecraft, this.field_22793, 238);
        this.textNewUser.method_1880(38);
        this.textNewUser.setSubmitCallback(value -> this.buttonNewUserPressed());
        newUserLayout.method_52736((class_8021)this.textNewUser);
        this.buttonNewUser = new IconButton(IconButton.Type.Send, b -> this.buttonNewUserPressed());
        newUserLayout.method_52736((class_8021)this.buttonNewUser);
        this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 140, doneLabel, b -> this.method_25419()));
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.method_25368() + 20, this.content.method_25364() + 20);
    }

    private void buttonNewUserPressed() {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.method_1882();
        this.textNewUser.method_25365(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError(errorUUIDSizeLabel);
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError(errorUUIDFormatLabel);
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        class_634 handler = this.minecraft.method_1562();
        if (handler != null && handler.method_2871(user.uuid) == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (class_3544.method_57181((String)user.username)) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (user.username.equals(this.minecraft.field_1724.method_7334().name())) {
            this.textNewUser.setError(errorSelfLabel);
            return;
        }
        ChatFrontiers.sendFrontier(this.frontier, user);
        this.textNewUser.method_1852("");
    }

    public void method_25419() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.method_25419();
    }
}

