/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUDWidget;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.platform.Services;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

@ParametersAreNonnullByDefault
public class HUDSettings
extends AutoScaledScreen {
    private static final class_2561 slot1Label = Config.getTranslatedName("hud.slot1");
    private static final class_7919 slot1Tooltip = Config.getTooltip("hud.slot1");
    private static final class_2561 slot2Label = Config.getTranslatedName("hud.slot2");
    private static final class_7919 slot2Tooltip = Config.getTooltip("hud.slot2");
    private static final class_2561 slot3Label = Config.getTranslatedName("hud.slot3");
    private static final class_7919 slot3Tooltip = Config.getTooltip("hud.slot3");
    private static final class_2561 textSizeLabel = Config.getTranslatedName("hud.textSize");
    private static final class_7919 textSizeTooltip = Config.getTooltip("hud.textSize");
    private static final class_2561 bannerSizeLabel = Config.getTranslatedName("hud.bannerSize");
    private static final class_7919 bannerSizeTooltip = Config.getTooltip("hud.bannerSize");
    private static final class_2561 anchorLabel = Config.getTranslatedName("hud.anchor");
    private static final class_7919 anchorTooltip = Config.getTooltip("hud.anchor");
    private static final class_2561 positionLabel = class_2561.method_43471((String)"mapfrontiers.config.hud.position");
    private static final class_7919 positionTooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)"HUD position relative to anchor."));
    private static final class_2561 positionSeparatorLabel = class_2561.method_43470((String)"x");
    private static final class_2561 autoAdjustAnchorLabel = Config.getTranslatedName("hud.autoAdjustAnchor");
    private static final class_7919 autoAdjustAnchorTooltip = Config.getTooltip("hud.autoAdjustAnchor");
    private static final class_2561 snapToBorderLabel = Config.getTranslatedName("hud.snapToBorder");
    private static final class_7919 snapToBorderTooltip = Config.getTooltip("hud.snapToBorder");
    private static final class_2561 doneLabel = class_2561.method_43471((String)"gui.done");
    private static final class_2561 onLabel = class_2561.method_43471((String)"options.on");
    private static final class_2561 offLabel = class_2561.method_43471((String)"options.off");
    private HUDWidget HUDWidget;
    private OptionButton buttonSlot1;
    private OptionButton buttonSlot2;
    private OptionButton buttonSlot3;
    private TextBoxInt textTextSize;
    private TextBoxInt textBannerSize;
    private OptionButton buttonAnchor;
    private TextBoxInt textPositionX;
    private TextBoxInt textPositionY;
    private OptionButton buttonAutoAdjustAnchor;
    private OptionButton buttonSnapToBorder;
    private SimpleButton buttonDone;
    private final HUD hud = HUD.asPreview();
    private int anchorLineColor = -2236963;
    private int anchorLineColorTick = 0;
    private class_437 previousScreen;

    public HUDSettings() {
        super((class_2561)class_2561.method_43473());
    }

    public void display() {
        super.display();
        this.previousScreen = this.backgroundScreen;
        this.backgroundScreen = null;
    }

    @Override
    public void method_25410(int width, int height) {
        super.method_25410(width, height);
        if (this.previousScreen != null) {
            this.previousScreen.method_25410(this.field_22789, this.field_22790);
        }
    }

    @Override
    public void initScreen() {
        ClientEventHandler.postUpdatedConfigEvent();
        this.HUDWidget = (HUDWidget)this.method_37063((class_364)new HUDWidget(this.hud, Services.JOURNEYMAP.isMinimapEnabled(), widget -> this.HUDUpdated()));
        class_7845 mainLayout = new class_7845().method_48637(4);
        this.content.method_52736((class_8021)mainLayout);
        StringWidget labelSlot1 = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(slot1Label, this.field_22793).setColor(-4144960), 0, 0);
        labelSlot1.method_47400(slot1Tooltip);
        this.buttonSlot1 = new OptionButton(this.field_22793, 64, b -> this.updateSlots());
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot1.setSelected(Config.hudSlot1.ordinal());
        mainLayout.method_46452((class_8021)this.buttonSlot1, 0, 1);
        StringWidget labelSlot2 = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(slot2Label, this.field_22793).setColor(-4144960), 1, 0);
        labelSlot2.method_47400(slot2Tooltip);
        this.buttonSlot2 = new OptionButton(this.field_22793, 64, b -> this.updateSlots());
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot2.setSelected(Config.hudSlot2.ordinal());
        mainLayout.method_46452((class_8021)this.buttonSlot2, 1, 1);
        StringWidget labelSlot3 = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(slot3Label, this.field_22793).setColor(-4144960), 2, 0);
        labelSlot3.method_47400(slot3Tooltip);
        this.buttonSlot3 = new OptionButton(this.field_22793, 64, b -> this.updateSlots());
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot3.setSelected(Config.hudSlot3.ordinal());
        mainLayout.method_46452((class_8021)this.buttonSlot3, 2, 1);
        StringWidget labelTextSize = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(textSizeLabel, this.field_22793).setColor(-4144960), 3, 0);
        labelTextSize.method_47400(textSizeTooltip);
        this.textTextSize = new TextBoxInt(1, 1, 8, this.field_22793, 64);
        this.textTextSize.method_1852(String.valueOf(Config.hudTextSize));
        this.textTextSize.method_1880(1);
        this.textTextSize.setValueChangedCallback(value -> {
            Config.hudTextSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        mainLayout.method_46452((class_8021)this.textTextSize, 3, 1);
        StringWidget labelBannerSize = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(bannerSizeLabel, this.field_22793).setColor(-4144960), 4, 0);
        labelBannerSize.method_47400(bannerSizeTooltip);
        this.textBannerSize = new TextBoxInt(3, 1, 8, this.field_22793, 64);
        this.textBannerSize.method_1852(String.valueOf(Config.hudBannerSize));
        this.textBannerSize.method_1880(1);
        this.textBannerSize.setValueChangedCallback(value -> {
            Config.hudBannerSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        mainLayout.method_46452((class_8021)this.textBannerSize, 4, 1);
        StringWidget labelAnchorLabel = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(anchorLabel, this.field_22793).setColor(-4144960), 0, 3);
        labelAnchorLabel.method_47400(anchorTooltip);
        this.buttonAnchor = new OptionButton(this.field_22793, 134, b -> {
            Config.hudAnchor = Config.HUDAnchor.values()[b.getSelected()];
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTop));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottom));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.Minimap));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapHorizontal));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapVertical));
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        mainLayout.method_46452((class_8021)this.buttonAnchor, 0, 4);
        StringWidget labelPosition = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(positionLabel, this.field_22793).setColor(-4144960), 1, 3);
        labelPosition.method_47400(positionTooltip);
        class_8667 positionLayout = class_8667.method_52742();
        mainLayout.method_46452((class_8021)positionLayout, 1, 4);
        this.textPositionX = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.field_22793, 61);
        this.textPositionX.method_1852(String.valueOf(Config.hudXPosition));
        this.textPositionX.method_1880(5);
        this.textPositionX.setValueChangedCallback(value -> {
            Config.hudXPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        positionLayout.method_52736((class_8021)this.textPositionX);
        positionLayout.method_52736((class_8021)class_7852.method_46512((int)3));
        positionLayout.method_52736((class_8021)new StringWidget(positionSeparatorLabel, this.field_22793).setColor(-8947849));
        positionLayout.method_52736((class_8021)class_7852.method_46512((int)2));
        this.textPositionY = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.field_22793, 62);
        this.textPositionY.method_1852(String.valueOf(Config.hudYPosition));
        this.textPositionY.method_1880(5);
        this.textPositionY.setValueChangedCallback(value -> {
            Config.hudYPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        positionLayout.method_52736((class_8021)this.textPositionY);
        StringWidget labelAutoAdjustAnchor = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(autoAdjustAnchorLabel, this.field_22793).setColor(-4144960), 2, 3);
        labelAutoAdjustAnchor.method_47400(autoAdjustAnchorTooltip);
        this.buttonAutoAdjustAnchor = new OptionButton(this.field_22793, 134, b -> {
            Config.hudAutoAdjustAnchor = b.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonAutoAdjustAnchor.addOption(onLabel);
        this.buttonAutoAdjustAnchor.addOption(offLabel);
        this.buttonAutoAdjustAnchor.setSelected(Config.hudAutoAdjustAnchor ? 0 : 1);
        mainLayout.method_46452((class_8021)this.buttonAutoAdjustAnchor, 2, 4);
        StringWidget labelSnapToBorder = (StringWidget)mainLayout.method_46452((class_8021)new StringWidget(snapToBorderLabel, this.field_22793).setColor(-4144960), 3, 3);
        labelSnapToBorder.method_47400(snapToBorderTooltip);
        this.buttonSnapToBorder = new OptionButton(this.field_22793, 134, b -> {
            Config.hudSnapToBorder = b.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonSnapToBorder.addOption(onLabel);
        this.buttonSnapToBorder.addOption(offLabel);
        this.buttonSnapToBorder.setSelected(Config.hudSnapToBorder ? 0 : 1);
        mainLayout.method_46452((class_8021)this.buttonSnapToBorder, 3, 4);
        this.buttonDone = new SimpleButton(this.field_22793, 100, doneLabel, b -> this.method_25419());
        mainLayout.method_46454((class_8021)this.buttonDone, 5, 0, 1, 5, class_7847.method_46481().method_46467());
        this.updatePosition();
    }

    public void method_25393() {
        ++this.anchorLineColorTick;
        if (this.anchorLineColorTick >= 3) {
            this.anchorLineColorTick = 0;
            this.anchorLineColor = this.anchorLineColor == -2236963 ? -14540254 : -2236963;
        }
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            Services.JOURNEYMAP.drawMinimapPreview(graphics);
        }
        this.drawAnchor(graphics, this.minecraft.method_22683());
        this.drawCenteredBoxBackground(graphics, this.content.method_25368() + 20, this.content.method_25364() + 20);
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.method_74228() == 69 && !(this.method_25399() instanceof class_342)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(event);
    }

    private void drawAnchor(class_332 graphics, class_1041 mainWindow) {
        float factor = mainWindow.method_4495();
        graphics.method_51448().pushMatrix();
        graphics.method_51448().scale(1.0f / factor, 1.0f / factor);
        int directionX = 0;
        int directionY = 0;
        int length = 25;
        Config.Point anchor = Config.getHUDAnchor(Config.hudAnchor);
        int displayWidth = mainWindow.method_4489();
        int displayHeight = mainWindow.method_4506();
        if (anchor.x < displayWidth / 2) {
            directionX = 1;
        } else if (anchor.x > displayWidth / 2) {
            directionX = -1;
            --anchor.x;
        }
        if (anchor.y < displayHeight / 2) {
            directionY = 1;
        } else if (anchor.y > displayHeight / 2) {
            directionY = -1;
            --anchor.y;
        }
        if (Config.hudAnchor == Config.HUDAnchor.Minimap) {
            directionX = -directionX;
            directionY = -directionY;
            if (directionX == 1) {
                ++anchor.x;
            }
            if (directionY == 1) {
                ++anchor.y;
            }
        }
        if (directionX == 0) {
            graphics.method_51738(anchor.x - length, anchor.x + length, anchor.y, this.anchorLineColor);
        } else {
            graphics.method_51738(anchor.x, anchor.x + length * directionX, anchor.y, this.anchorLineColor);
        }
        if (directionY == 0) {
            graphics.method_51742(anchor.x, anchor.y - length, anchor.y + length, this.anchorLineColor);
        } else {
            graphics.method_51742(anchor.x, anchor.y, anchor.y + length * directionY, this.anchorLineColor);
        }
        graphics.method_51448().popMatrix();
    }

    private void updateSlots() {
        this.updateSlotsValidity();
        boolean updated = false;
        if (this.buttonSlot1.getColor() == -4144960 || this.buttonSlot1.getColor() == -1) {
            Config.hudSlot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
            updated = true;
        }
        if (this.buttonSlot2.getColor() == -4144960 || this.buttonSlot2.getColor() == -1) {
            Config.hudSlot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
            updated = true;
        }
        if (this.buttonSlot3.getColor() == -4144960 || this.buttonSlot3.getColor() == -1) {
            Config.hudSlot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
            updated = true;
        }
        if (updated) {
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        }
    }

    private void updateSlotsValidity() {
        Config.HUDSlot slot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
        Config.HUDSlot slot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
        Config.HUDSlot slot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
        this.buttonSlot1.setColor(-4144960, -1);
        this.buttonSlot2.setColor(-4144960, -1);
        this.buttonSlot3.setColor(-4144960, -1);
        if (slot1 != Config.HUDSlot.None && slot1 == slot2) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot2.setColor(-2289391, -48060);
        }
        if (slot1 != Config.HUDSlot.None && slot1 == slot3) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
        if (slot2 != Config.HUDSlot.None && slot2 == slot3) {
            this.buttonSlot2.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
    }

    public void method_25419() {
        this.backgroundScreen = this.previousScreen;
        super.method_25419();
    }

    public void method_25432() {
        ClientEventHandler.postUpdatedConfigEvent();
    }

    private void updatePosition() {
        Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
        Config.Point positionPoint = new Config.Point();
        positionPoint.x = Config.hudXPosition + anchorPoint.x - originPoint.x;
        positionPoint.y = Config.hudYPosition + anchorPoint.y - originPoint.y;
        this.HUDWidget.setPositionHUD(positionPoint);
    }

    private void HUDUpdated() {
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX.method_1852(String.valueOf(Config.hudXPosition));
        this.textPositionY.method_1852(String.valueOf(Config.hudYPosition));
    }
}

