/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.ColorConstants;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPaletteWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPicker;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleSlider;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.VisibilityDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.client.gui.screen.SendFrontier;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ShareSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketChangeFrontierToGlobal;
import games.alejandrocoria.mapfrontiers.common.network.PacketChangeFrontierToPersonal;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

@ParametersAreNonnullByDefault
public class FrontierInfo
extends AutoScaledScreen {
    static final DateFormat dateFormat = new SimpleDateFormat();
    private static final class_2561 titleLabel = class_2561.method_43471((String)"mapfrontiers.title_info");
    private static final class_2561 assignBannerLabel = class_2561.method_43471((String)"mapfrontiers.assign_banner");
    private static final class_2561 assignBannerWarnLabel = assignBannerLabel.method_27661().method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + " !")));
    private static final class_2561 removeBannerLabel = class_2561.method_43471((String)"mapfrontiers.remove_banner");
    private static final String bannerRotationKey = "mapfrontiers.banner_rotation";
    private static final class_2561 nameLabel = class_2561.method_43471((String)"mapfrontiers.name");
    private static final class_2561 personalLabel = class_2561.method_43471((String)"mapfrontiers.config.Personal");
    private static final class_2561 globalLabel = class_2561.method_43471((String)"mapfrontiers.config.Global");
    private static final String verticesKey = "mapfrontiers.vertices";
    private static final String chunksKey = "mapfrontiers.chunks";
    private static final String ownerKey = "mapfrontiers.owner";
    private static final String originalOwnerKey = "mapfrontiers.original_owner";
    private static final String dimensionKey = "mapfrontiers.dimension";
    private static final String areaKey = "mapfrontiers.area";
    private static final String perimeterKey = "mapfrontiers.perimeter";
    private static final String createdKey = "mapfrontiers.created";
    private static final String modifiedKey = "mapfrontiers.modified";
    private static final class_2561 visibilityLabel = class_2561.method_43471((String)"mapfrontiers.visibility");
    private static final class_2561 visibilityOverrideLabel = class_2561.method_43471((String)"mapfrontiers.visibility_override");
    private static final class_2561 colorLabel = class_2561.method_43471((String)"mapfrontiers.color");
    private static final class_2561 rLabel = class_2561.method_43470((String)"R");
    private static final class_2561 gLabel = class_2561.method_43470((String)"G");
    private static final class_2561 bLabel = class_2561.method_43470((String)"B");
    private static final class_2561 randomColorLabel = class_2561.method_43471((String)"mapfrontiers.random_color");
    private static final class_2561 pasteNameLabel = class_2561.method_43471((String)"mapfrontiers.paste_name");
    private static final class_2561 pasteVisibilityLabel = class_2561.method_43471((String)"mapfrontiers.paste_visibility");
    private static final class_2561 pasteColorLabel = class_2561.method_43471((String)"mapfrontiers.paste_color");
    private static final class_2561 pasteBannerLabel = class_2561.method_43471((String)"mapfrontiers.paste_banner");
    private static final class_2561 selectInMapLabel = class_2561.method_43471((String)"mapfrontiers.select_in_map");
    private static final class_2561 shareSettingsLabel = class_2561.method_43471((String)"mapfrontiers.share_settings");
    private static final class_2561 sendLabel = class_2561.method_43471((String)"mapfrontiers.send");
    private static final class_2561 deleteLabel = class_2561.method_43471((String)"mapfrontiers.delete");
    private static final class_2561 doneLabel = class_2561.method_43471((String)"gui.done");
    private static final class_2561 onLabel = class_2561.method_43471((String)"options.on");
    private static final class_2561 offLabel = class_2561.method_43471((String)"options.off");
    private static final class_7919 visibilityTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.visibility.tooltip"));
    private static final class_7919 visibilityOverrideTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.visibility_override.tooltip"));
    private static final class_7919 copyTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.copy"));
    private static final class_7919 pasteTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.paste"));
    private static final class_7919 openPasteTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.open_paste_options"));
    private static final class_7919 closePasteTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.close_paste_options"));
    private static final class_7919 undoTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.undo"));
    private static final class_7919 redoTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.redo"));
    private static final class_7919 changeToPersonalTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.change_to_personal"));
    private static final class_7919 changeToGlobalTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"mapfrontiers.change_to_global"));
    private static final class_7919 assignBannerWarnTooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + "! " + String.valueOf(class_124.field_1070))).method_10852((class_2561)class_2561.method_43471((String)"mapfrontiers.assign_banner_warn")));
    private final IClientAPI jmAPI;
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontierOverlay frontier;
    private int frontierHash;
    private TextBox textName1;
    private TextBox textName2;
    private SimpleButton buttonVisibility;
    private SimpleButton buttonVisibilityOverride;
    private TextBoxInt textRed;
    private TextBoxInt textGreen;
    private TextBoxInt textBlue;
    private SimpleButton buttonRandomColor;
    private ColorPicker colorPicker;
    private ColorPaletteWidget colorPalette;
    private IconButton buttonCopy;
    private IconButton buttonPaste;
    private IconButton buttonPasteOptions;
    private OptionButton buttonPasteName;
    private OptionButton buttonPasteVisibility;
    private OptionButton buttonPasteColor;
    private OptionButton buttonPasteBanner;
    private StringWidget labelPasteName;
    private StringWidget labelPasteVisibility;
    private StringWidget labelPasteColor;
    private StringWidget labelPasteBanner;
    private IconButton buttonUndo;
    private IconButton buttonRedo;
    private IconButton buttonChangeToPersonalGlobal;
    private SimpleButton buttonSelect;
    private SimpleButton buttonShareSettings;
    private SimpleButton buttonDelete;
    private SimpleButton buttonDone;
    private SimpleButton buttonBanner;
    private SimpleSlider sliderBannerRotation;
    private StringWidget modifiedLabel;
    private final Stack<FrontierData> undoStack = new Stack();
    private final Stack<FrontierData> redoStack = new Stack();

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier) {
        super(titleLabel, 636, 350);
        this.jmAPI = jmAPI;
        this.frontiersOverlayManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        this.frontier = frontier;
        this.frontierHash = frontier.getHash();
        this.undoStack.push(new FrontierData(frontier));
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontier.getId().equals(frontierID)) {
                this.method_25419();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (this.minecraft.field_1724 != null && frontier.getId().equals(frontierOverlay.getId())) {
                this.addToUndo(new FrontierData((FrontierData)frontierOverlay));
                if (playerID.intValue() != this.minecraft.field_1724.method_5628()) {
                    this.method_41843();
                    this.method_48640();
                } else if (frontier.getModified() != null) {
                    class_5250 modified = class_2561.method_43469((String)modifiedKey, (Object[])new Object[]{dateFormat.format(frontier.getModified())});
                    this.modifiedLabel.method_25355((class_2561)modified);
                }
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.updateButtons();
            this.updateBannerButton();
        });
    }

    @Override
    public void initScreen() {
        class_7845 mainLayout = new class_7845().method_48637(10);
        this.content.method_52736((class_8021)mainLayout);
        class_8667 bannerColumn = class_8667.method_52741().method_52735(2);
        bannerColumn.method_52740().method_46467();
        mainLayout.method_46452((class_8021)bannerColumn, 0, 0);
        this.buttonBanner = new SimpleButton(this.field_22793, 144, assignBannerLabel, b -> {
            if (!this.frontier.hasBanner()) {
                class_1799 heldBanner = FrontierInfo.getHeldBanner(this.minecraft);
                if (heldBanner != null) {
                    this.frontier.setBanner(heldBanner);
                }
            } else {
                this.frontier.setBanner(null);
            }
            this.updateBannerButton();
            this.sendChangesToServer();
        });
        bannerColumn.method_52736((class_8021)this.buttonBanner);
        this.sliderBannerRotation = new SimpleSlider(this.field_22793, 144, bannerRotationKey, 0, 360, this.frontier.getBannerRotation(), (angle, dragging) -> {
            this.frontier.setBannerRotation(angle);
            if (!dragging) {
                this.sendChangesToServer();
            }
        });
        bannerColumn.method_52736((class_8021)this.sliderBannerRotation);
        class_8667 nameColumn = class_8667.method_52741().method_52735(2);
        nameColumn.method_52740().method_46461();
        mainLayout.method_46453((class_8021)nameColumn, 0, 1, 2, 1);
        nameColumn.method_52736((class_8021)new StringWidget(nameLabel, this.field_22793).setColor(-16711681));
        this.textName1 = new TextBox(this.field_22793, 144);
        this.textName1.method_1880(17);
        this.textName1.method_53533(20);
        this.textName1.method_1852(this.frontier.getName1());
        this.textName1.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName1.setValueChangedCallback(value -> {
            if (!this.frontier.getName1().equals(value)) {
                this.frontier.setName1((String)value);
            }
        });
        nameColumn.method_52736((class_8021)this.textName1);
        this.textName2 = new TextBox(this.field_22793, 144);
        this.textName2.method_1880(17);
        this.textName2.method_53533(20);
        this.textName2.method_1852(this.frontier.getName2());
        this.textName2.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName2.setValueChangedCallback(value -> {
            if (!this.frontier.getName2().equals(value)) {
                this.frontier.setName2((String)value);
            }
        });
        nameColumn.method_52736((class_8021)this.textName2);
        class_8667 dataRow1 = class_8667.method_52741();
        mainLayout.method_46454((class_8021)dataRow1, 0, 2, 1, 2, class_7847.method_46481().method_46461());
        class_8667 dataRow1sub = class_8667.method_52742().method_52735(12);
        dataRow1.method_52736((class_8021)dataRow1sub);
        class_8667 dataRow1subPersonalGlobal = class_8667.method_52742().method_52735(4);
        dataRow1sub.method_52736((class_8021)dataRow1subPersonalGlobal);
        dataRow1subPersonalGlobal.method_52736((class_8021)new StringWidget(this.frontier.getPersonal() ? personalLabel : globalLabel, this.field_22793).setColor(-1));
        this.buttonChangeToPersonalGlobal = (IconButton)dataRow1subPersonalGlobal.method_52736((class_8021)new IconButton(IconButton.Type.Swap, b -> {
            if (this.frontier.getPersonal()) {
                new ConfirmationDialog("mapfrontiers.change_to_global_frontier_dialog", "mapfrontiers.change_to_global_frontier_dialog_desc", "mapfrontiers.change_to_global", "gui.cancel", null, response -> this.changeToGlobal()).display();
            } else {
                new ConfirmationDialog("mapfrontiers.change_to_personal_frontier_dialog", "mapfrontiers.change_to_personal_frontier_dialog_desc", "mapfrontiers.change_to_personal", "gui.cancel", null, response -> this.changeToPersonal()).display();
            }
        }));
        this.buttonChangeToPersonalGlobal.method_47400(this.frontier.getPersonal() ? changeToGlobalTooltip : changeToPersonalTooltip);
        if (this.frontier.getMode() == FrontierData.Mode.Vertex) {
            class_5250 vertices = class_2561.method_43469((String)verticesKey, (Object[])new Object[]{this.frontier.getVertexCount()});
            dataRow1sub.method_52736((class_8021)new StringWidget((class_2561)vertices, this.field_22793).setColor(-1));
        } else {
            class_5250 chunks = class_2561.method_43469((String)chunksKey, (Object[])new Object[]{this.frontier.getChunkCount()});
            dataRow1sub.method_52736((class_8021)new StringWidget((class_2561)chunks, this.field_22793).setColor(-1));
        }
        class_5250 owner = class_2561.method_43469((String)ownerKey, (Object[])new Object[]{this.frontier.getOwner().toString()});
        if (this.frontier.wasCopied()) {
            owner.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + " !")));
        }
        StringWidget ownerWidget = (StringWidget)dataRow1sub.method_52736((class_8021)new StringWidget((class_2561)owner, this.field_22793).setColor(-1));
        if (this.frontier.wasCopied()) {
            class_7919 ownerTooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + "! " + String.valueOf(class_124.field_1070))).method_10852((class_2561)class_2561.method_43469((String)originalOwnerKey, (Object[])new Object[]{this.frontier.getCopiedFromUser().toString()})));
            ownerWidget.method_47400(ownerTooltip);
        }
        class_5250 dimension = class_2561.method_43469((String)dimensionKey, (Object[])new Object[]{this.frontier.getDimension().method_29177().toString()});
        dataRow1.method_52736((class_8021)new StringWidget((class_2561)dimension, this.field_22793).setColor(-6710887));
        class_8667 dataRow2Col1 = class_8667.method_52741();
        mainLayout.method_46455((class_8021)dataRow2Col1, 1, 2, class_7847.method_46481().method_46461());
        class_5250 area = class_2561.method_43469((String)areaKey, (Object[])new Object[]{Float.valueOf(this.frontier.area)});
        dataRow2Col1.method_52736((class_8021)new StringWidget((class_2561)area, this.field_22793).setColor(-1));
        class_5250 perimeter = class_2561.method_43469((String)perimeterKey, (Object[])new Object[]{Float.valueOf(this.frontier.perimeter)});
        dataRow2Col1.method_52736((class_8021)new StringWidget((class_2561)perimeter, this.field_22793).setColor(-1));
        class_8667 dataRow2Col2 = class_8667.method_52741();
        mainLayout.method_46455((class_8021)dataRow2Col2, 1, 3, class_7847.method_46481().method_46461());
        if (this.frontier.getCreated() != null) {
            class_5250 created = class_2561.method_43469((String)createdKey, (Object[])new Object[]{dateFormat.format(this.frontier.getCreated())});
            dataRow2Col2.method_52736((class_8021)new StringWidget((class_2561)created, this.field_22793).setColor(-1));
        }
        if (this.frontier.getModified() != null) {
            class_5250 modified = class_2561.method_43469((String)modifiedKey, (Object[])new Object[]{dateFormat.format(this.frontier.getModified())});
            this.modifiedLabel = (StringWidget)dataRow2Col2.method_52736((class_8021)new StringWidget((class_2561)modified, this.field_22793).setColor(-1));
        }
        this.buttonVisibility = new SimpleButton(this.field_22793, 144, visibilityLabel, b -> new VisibilityDialog(this.frontier.getVisibilityData(), (newVisibilityData, newVisibilityMask) -> {
            if (!newVisibilityData.equals(this.frontier.getVisibilityData())) {
                this.frontier.setVisibilityData((FrontierData.VisibilityData)newVisibilityData);
                this.sendChangesToServer();
            }
        }).display());
        this.buttonVisibility.method_47400(visibilityTooltip);
        mainLayout.method_46452((class_8021)this.buttonVisibility, 2, 1);
        this.buttonVisibilityOverride = new SimpleButton(this.field_22793, 144, visibilityOverrideLabel, b -> {
            Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> override = MapFrontiersClient.getLocalOverrides().getVisibility(this.frontier.getId());
            new VisibilityDialog((FrontierData.VisibilityData)override.first(), (FrontierData.VisibilityData)override.second(), (newVisibilityData, newVisibilityMask) -> {
                if (!newVisibilityData.equals(override.first()) || !newVisibilityMask.equals(override.second())) {
                    Pair newOverride = Pair.of((Object)newVisibilityData, (Object)newVisibilityMask);
                    MapFrontiersClient.getLocalOverrides().setVisibility(this.frontier.getId(), (Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)newOverride);
                    this.frontier.setVisibilityOverride((Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)newOverride);
                }
            }).display();
        });
        this.buttonVisibilityOverride.method_47400(visibilityOverrideTooltip);
        mainLayout.method_46452((class_8021)this.buttonVisibilityOverride, 2, 2);
        this.colorPicker = new ColorPicker(this.frontier.getColor(), (color, dragging) -> {
            this.colorPalette.setColor((int)color);
            this.colorPickerUpdated((int)color, (boolean)dragging);
        });
        mainLayout.method_46455((class_8021)this.colorPicker, 3, 1, class_7847.method_46481().method_46476());
        class_8667 colorCol = class_8667.method_52741().method_52735(4);
        colorCol.method_52740().method_46467();
        mainLayout.method_46452((class_8021)colorCol, 3, 2);
        colorCol.method_52737((class_8021)new StringWidget(colorLabel, this.field_22793).setColor(-16711681), class_7847.method_46481().method_46461());
        class_8667 rgbRow = class_8667.method_52742().method_52735(3);
        rgbRow.method_52740().method_46474();
        colorCol.method_52736((class_8021)rgbRow);
        rgbRow.method_52736((class_8021)new StringWidget(rLabel, this.field_22793, 8).setColor(-16711681));
        this.textRed = new TextBoxInt(0, 0, 255, this.field_22793, 29);
        this.textRed.method_53533(20);
        this.textRed.method_25358(34);
        this.textRed.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFF00FFFF | value << 16;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.method_52736((class_8021)this.textRed);
        rgbRow.method_52736((class_8021)class_7852.method_46512((int)1));
        rgbRow.method_52736((class_8021)new StringWidget(gLabel, this.field_22793, 8).setColor(-16711681));
        this.textGreen = new TextBoxInt(0, 0, 255, this.field_22793, 29);
        this.textGreen.method_53533(20);
        this.textGreen.method_25358(34);
        this.textGreen.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFF00FF | value << 8;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.method_52736((class_8021)this.textGreen);
        rgbRow.method_52736((class_8021)class_7852.method_46512((int)1));
        rgbRow.method_52736((class_8021)new StringWidget(bLabel, this.field_22793, 8).setColor(-16711681));
        this.textBlue = new TextBoxInt(0, 0, 255, this.field_22793, 29);
        this.textBlue.method_53533(20);
        this.textBlue.method_25358(34);
        this.textBlue.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFFFF00 | value;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.method_52736((class_8021)this.textBlue);
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        this.buttonRandomColor = new SimpleButton(this.field_22793, 144, randomColorLabel, b -> {
            int newColor = ColorHelper.getRandomColor();
            this.frontier.setColor(newColor);
            this.colorPicker.setColor(newColor);
            this.textRed.setValue((newColor & 0xFF0000) >> 16);
            this.textGreen.setValue((newColor & 0xFF00) >> 8);
            this.textBlue.setValue(newColor & 0xFF);
            this.sendChangesToServer();
        });
        colorCol.method_52736((class_8021)this.buttonRandomColor);
        this.colorPalette = new ColorPaletteWidget(this.frontier.getColor(), color -> {
            this.colorPicker.setColor((int)color);
            this.colorPickerUpdated((int)color, false);
        });
        colorCol.method_52736((class_8021)this.colorPalette);
        class_7845 editCol = new class_7845().method_48636(4);
        editCol.method_46458().method_46461();
        editCol.method_46452((class_8021)class_7852.method_46512((int)116), 0, 0);
        mainLayout.method_46455((class_8021)editCol, 3, 3, class_7847.method_46481().method_46476());
        this.labelPasteName = (StringWidget)editCol.method_46452((class_8021)new StringWidget(pasteNameLabel, this.field_22793).setColor(-4144960), 0, 0);
        this.buttonPasteName = (OptionButton)editCol.method_46452((class_8021)this.createVisibilityOptionButton(Config.pasteName, value -> {
            Config.pasteName = value;
        }), 0, 1);
        this.labelPasteVisibility = (StringWidget)editCol.method_46452((class_8021)new StringWidget(pasteVisibilityLabel, this.field_22793).setColor(-4144960), 1, 0);
        this.buttonPasteVisibility = (OptionButton)editCol.method_46452((class_8021)this.createVisibilityOptionButton(Config.pasteVisibility, value -> {
            Config.pasteVisibility = value;
        }), 1, 1);
        this.labelPasteColor = (StringWidget)editCol.method_46452((class_8021)new StringWidget(pasteColorLabel, this.field_22793).setColor(-4144960), 2, 0);
        this.buttonPasteColor = (OptionButton)editCol.method_46452((class_8021)this.createVisibilityOptionButton(Config.pasteColor, value -> {
            Config.pasteColor = value;
        }), 2, 1);
        this.labelPasteBanner = (StringWidget)editCol.method_46452((class_8021)new StringWidget(pasteBannerLabel, this.field_22793).setColor(-4144960), 3, 0);
        this.buttonPasteBanner = (OptionButton)editCol.method_46452((class_8021)this.createVisibilityOptionButton(Config.pasteBanner, value -> {
            Config.pasteBanner = value;
        }), 3, 1);
        class_8667 editButtons = class_8667.method_52742().method_52735(3);
        editCol.method_46452((class_8021)editButtons, 4, 0);
        this.buttonCopy = (IconButton)editButtons.method_52736((class_8021)new IconButton(IconButton.Type.Copy, b -> {
            MapFrontiersClient.setClipboard(this.frontier);
            this.updatePasteOptionsVisibility();
        }));
        this.buttonCopy.method_47400(copyTooltip);
        class_8667 pasteButtons = class_8667.method_52742();
        editButtons.method_52736((class_8021)pasteButtons);
        this.buttonPaste = (IconButton)pasteButtons.method_52736((class_8021)new IconButton(IconButton.Type.Paste, b -> {
            FrontierData clipboard = MapFrontiersClient.getClipboard();
            if (clipboard != null && (Config.pasteName || Config.pasteVisibility || Config.pasteColor || Config.pasteBanner)) {
                this.setFrontier(clipboard, Config.pasteName, Config.pasteVisibility, Config.pasteColor, Config.pasteBanner);
                this.sendChangesToServer();
                this.method_41843();
                this.method_48640();
                if (this.minecraft.method_48186().method_48183()) {
                    this.method_48265((class_364)this.buttonPaste);
                }
            }
        }));
        this.buttonPaste.method_47400(pasteTooltip);
        this.buttonPasteOptions = (IconButton)pasteButtons.method_52736((class_8021)new IconButton(IconButton.Type.ArrowUp, b -> {
            Config.pasteOptionsVisible = !Config.pasteOptionsVisible;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        }));
        this.buttonPasteOptions.method_47400(openPasteTooltip);
        this.buttonUndo = (IconButton)editButtons.method_52736((class_8021)new IconButton(IconButton.Type.Undo, b -> this.undo()));
        this.buttonUndo.method_47400(undoTooltip);
        this.buttonRedo = (IconButton)editButtons.method_52736((class_8021)new IconButton(IconButton.Type.Redo, b -> this.redo()));
        this.buttonRedo.method_47400(redoTooltip);
        this.buttonSelect = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 144, selectInMapLabel, b -> {
            class_2338 center = this.frontier.getCenter();
            this.closeAndReturnToFullscreenMap();
            Services.JOURNEYMAP.fullscreenMapCenterOn(center.method_10263(), center.method_10260());
        }));
        this.buttonShareSettings = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 144, shareSettingsLabel, b -> {
            if (MapFrontiersClient.isModOnServer()) {
                new ShareSettings(this.frontiersOverlayManager, this.frontier).display();
            } else {
                new SendFrontier(this.frontier).display();
            }
        }));
        this.buttonDelete = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 144, deleteLabel, b -> {
            if (Config.askConfirmationFrontierDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_frontier_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationFrontierDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteFrontier();
                }).display();
            } else {
                this.deleteFrontier();
            }
        }));
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonDone = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 144, doneLabel, b -> this.method_25419()));
        this.updateBannerButton();
        this.updateButtons();
        this.updatePasteOptionsVisibility();
        this.updateUndoRedoVisibility();
        this.method_48265((class_364)this.buttonDone);
    }

    private OptionButton createVisibilityOptionButton(boolean defaultValue, Consumer<Boolean> consumer) {
        OptionButton button = new OptionButton(this.field_22793, 28, b -> {
            consumer.accept(b.getSelected() == 0);
            this.sendChangesToServer();
        });
        button.addOption(onLabel);
        button.addOption(offLabel);
        button.setSelected(defaultValue ? 0 : 1);
        return button;
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.method_25368() + 20, this.content.method_25364() + 20);
    }

    @Override
    public void renderScaledScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.frontier.getBannerRenderer().hasBanner()) {
            this.frontier.getBannerRenderer().renderBanner(graphics, this.buttonBanner.method_46426() + this.buttonBanner.method_25368() / 2, this.sliderBannerRotation.method_46427() + 25, 3);
        }
    }

    @Override
    public boolean method_25406(class_11909 event) {
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ColorPicker)) continue;
            w.method_25406(event);
        }
        this.sliderBannerRotation.mouseReleased();
        return super.method_25406(event);
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.method_74228() == 90 && event.method_74240() && !event.method_74239() && !event.method_74238()) {
            this.undo();
            return true;
        }
        if (event.method_74228() == 90 && event.method_74240() && event.method_74239() && !event.method_74238()) {
            this.redo();
            return true;
        }
        return super.method_25404(event);
    }

    public void method_25419() {
        this.sendChangesToServer();
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.method_25419();
    }

    private void deleteFrontier() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        this.frontiersOverlayManager.clientDeleteFrontier(this.frontier);
        this.method_25419();
    }

    private void colorPickerUpdated(int color, boolean dragging) {
        this.frontier.setColor(color);
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        if (!dragging) {
            this.sendChangesToServer();
        }
    }

    private void undo() {
        if (this.undoStack.size() == 1) {
            return;
        }
        this.redoStack.push(this.undoStack.pop());
        this.setFrontier(this.undoStack.peek(), true, true, true, true);
        this.sendChangesToServer();
        this.method_41843();
        this.method_48640();
        if (this.minecraft.method_48186().method_48183()) {
            if (this.undoStack.size() == 1) {
                this.method_48265((class_364)this.buttonRedo);
            } else {
                this.method_48265((class_364)this.buttonUndo);
            }
        }
    }

    private void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        this.setFrontier(this.redoStack.peek(), true, true, true, true);
        this.undoStack.push(this.redoStack.pop());
        this.sendChangesToServer();
        this.method_41843();
        this.method_48640();
        if (this.minecraft.method_48186().method_48183()) {
            if (this.redoStack.empty()) {
                this.method_48265((class_364)this.buttonUndo);
            } else {
                this.method_48265((class_364)this.buttonRedo);
            }
        }
    }

    private void setFrontier(FrontierData other, boolean name, boolean visibility, boolean color, boolean banner) {
        if (name) {
            this.frontier.setName1(other.getName1());
            this.frontier.setName2(other.getName2());
        }
        if (visibility) {
            this.frontier.setVisibilityData(other.getVisibilityData());
        }
        if (color) {
            this.frontier.setColor(other.getColor());
        }
        if (banner) {
            this.frontier.setBannerData(other.getbannerData());
        }
    }

    private void updateBannerButton() {
        if (!this.frontier.hasBanner()) {
            if (FrontierInfo.getHeldBanner(this.minecraft) != null) {
                this.buttonBanner.method_25355(assignBannerLabel);
                this.buttonBanner.method_47400(null);
            } else {
                this.buttonBanner.method_25355(assignBannerWarnLabel);
                this.buttonBanner.method_47400(assignBannerWarnTooltip);
            }
            this.sliderBannerRotation.field_22764 = false;
        } else {
            this.buttonBanner.method_25355(removeBannerLabel);
            this.buttonBanner.method_47400(null);
            this.sliderBannerRotation.field_22764 = true;
        }
    }

    private static class_1799 getHeldBanner(@Nullable class_310 minecraft) {
        if (minecraft == null || minecraft.field_1724 == null) {
            return null;
        }
        class_1799 mainhand = minecraft.field_1724.method_6118(class_1304.field_6173);
        class_1799 offhand = minecraft.field_1724.method_6118(class_1304.field_6171);
        class_1799 heldBanner = null;
        if (mainhand.method_7909() instanceof class_1746) {
            heldBanner = mainhand;
        } else if (offhand.method_7909() instanceof class_1746) {
            heldBanner = offhand;
        }
        return heldBanner;
    }

    private void changeToGlobal() {
        this.undoStack.clear();
        this.redoStack.clear();
        PacketHandler.sendToServer(new PacketChangeFrontierToGlobal(this.frontier.getId(), null));
    }

    private void changeToPersonal() {
        this.undoStack.clear();
        this.redoStack.clear();
        PacketHandler.sendToServer(new PacketChangeFrontierToPersonal(this.frontier.getId(), null));
    }

    private void updateButtons() {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)this.minecraft.field_1724);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        this.textName1.method_1888(actions.canUpdate);
        this.textName2.method_1888(actions.canUpdate);
        this.buttonVisibility.field_22763 = actions.canUpdate;
        this.textRed.method_1888(actions.canUpdate);
        this.textGreen.method_1888(actions.canUpdate);
        this.textBlue.method_1888(actions.canUpdate);
        this.buttonRandomColor.field_22763 = actions.canUpdate;
        this.colorPicker.field_22763 = actions.canUpdate;
        this.colorPalette.field_22763 = actions.canUpdate;
        this.buttonPaste.field_22763 = actions.canUpdate;
        this.buttonPasteOptions.field_22763 = actions.canUpdate;
        this.buttonChangeToPersonalGlobal.field_22764 = this.frontier.getPersonal() ? MapFrontiersClient.isModOnServer() && this.frontier.getOwner().equals(playerUser) && profile.createFrontier == SettingsProfile.State.Enabled : actions.canDelete;
        this.buttonDelete.field_22763 = actions.canDelete;
        this.buttonBanner.field_22764 = actions.canUpdate;
        this.sliderBannerRotation.field_22764 = actions.canUpdate && this.frontier.hasBanner();
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        boolean bl = this.buttonSelect.field_22763 = uiState != null && this.frontier.getDimension().equals((Object)uiState.dimension);
        if (MapFrontiersClient.isModOnServer()) {
            this.buttonShareSettings.method_25355(shareSettingsLabel);
            this.buttonShareSettings.field_22763 = actions.canShare;
        } else {
            this.buttonShareSettings.method_25355(sendLabel);
        }
    }

    private void updatePasteOptionsVisibility() {
        this.buttonPasteOptions.field_22764 = this.buttonPaste.field_22764 = this.buttonPaste.field_22763 && MapFrontiersClient.getClipboard() != null;
        this.buttonPasteOptions.setType(Config.pasteOptionsVisible ? IconButton.Type.ArrowDown : IconButton.Type.ArrowUp);
        this.buttonPasteOptions.method_47400(Config.pasteOptionsVisible ? closePasteTooltip : openPasteTooltip);
        this.buttonPasteName.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteVisibility.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteColor.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteBanner.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteName.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteVisibility.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteColor.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteBanner.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
    }

    private void updateUndoRedoVisibility() {
        this.buttonUndo.field_22764 = this.buttonPaste.field_22763 && this.undoStack.size() > 1;
        this.buttonRedo.field_22764 = this.buttonPaste.field_22763 && this.redoStack.size() > 0;
    }

    private void sendChangesToServer() {
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)this.minecraft.field_1724);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        if (actions.canUpdate && this.frontier.getHash() != this.frontierHash) {
            this.frontierHash = this.frontier.getHash();
            this.frontiersOverlayManager.clientUpdateFrontier(this.frontier);
        }
    }

    private void addToUndo(FrontierData frontier) {
        FrontierData u;
        boolean add = this.undoStack.empty();
        if (!(add || Objects.equals((u = this.undoStack.peek()).getName1(), frontier.getName1()) && Objects.equals(u.getName2(), frontier.getName2()) && Objects.equals(u.getVisibilityData(), frontier.getVisibilityData()) && u.getColor() == frontier.getColor() && Objects.equals(u.getbannerData(), frontier.getbannerData()))) {
            add = true;
        }
        if (add) {
            this.undoStack.push(frontier);
            if (!this.redoStack.empty()) {
                this.redoStack.clear();
            }
            this.updateUndoRedoVisibility();
        }
    }
}

