/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

@ParametersAreNonnullByDefault
public class ShapeVertexButtons
extends AbstractWidgetNoNarration {
    private static final int[] vertexCount = new int[]{0, 1, 3, 3, 3, 3, 4, 4, 6, 6, 8, 16};
    private static final double[] vertexAngle = new double[]{0.0, 0.0, -90.0, 0.0, 90.0, 180.0, 45.0, 0.0, 30.0, 0.0, 22.5, 0.0};
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private final StringWidget labelShapes;
    private final Consumer<ShapeVertexButtons> callbackShapeUpdated;

    public ShapeVertexButtons(class_327 font, int selected, Consumer<ShapeVertexButtons> callbackShapeUpdated) {
        super(0, 0, 324, 122, (class_2561)class_2561.method_43473());
        this.selected = selected;
        this.labelShapes = new StringWidget((class_2561)class_2561.method_43471((String)"mapfrontiers.initial_shape"), font, StringWidget.Align.Center).setColor(-1);
        this.callbackShapeUpdated = callbackShapeUpdated;
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2) {
            return ShapeMeasure.None;
        }
        if (this.selected < 7) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Radius;
    }

    public int getVertexCount() {
        return vertexCount[this.selected];
    }

    public List<class_241> getVertices() {
        return this.getVertices(vertexCount[this.selected], vertexAngle[this.selected] / 180.0 * Math.PI);
    }

    public List<class_241> getVertices(int count) {
        return this.getVertices(count, 0.0);
    }

    private List<class_241> getVertices(int count, double angleOffset) {
        if (count == 0) {
            return null;
        }
        ArrayList<class_241> vertices = new ArrayList<class_241>();
        if (count == 1) {
            vertices.add(class_241.field_1340);
            return vertices;
        }
        for (int i = 0; i < count; ++i) {
            double vertexAngle = Math.PI * 2 / (double)count * (double)i + angleOffset;
            vertices.add(new class_241((float)Math.cos(vertexAngle), (float)Math.sin(vertexAngle)));
        }
        return vertices;
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.labelShapes.method_46421(x + 162);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.labelShapes.method_46419(y + 2);
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigationEvent) {
        return null;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        double col = (event.comp_4798() - (double)this.method_46426() + 3.0) / 55.0;
        double row = (event.comp_4799() - (double)this.method_46427() - 15.0) / 55.0;
        if (col >= 0.0 && col < 6.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 6;
            this.callbackShapeUpdated.accept(this);
        }
        return true;
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int col = 0;
        int row = 0;
        for (int i = 0; i < 12; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.method_25290(class_10799.field_56883, texture, this.method_46426() + col * 55, this.method_46427() + row * 55 + 18, (float)texX, (float)texY, 49, 49, 980, 98);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Radius;

    }
}

