/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.client.model.loading.UnbakedModelDeserializerRegistry;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_10521;
import net.minecraft.class_10819;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3298;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import net.minecraft.class_801;
import net.minecraft.class_9824;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.BlockStateDefinitionsAccessor;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.IdMapperAccessor;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ModelDiscoveryAccessor;
import org.embeddedt.modernfix.dynresources.DisjointSetUnion;
import org.embeddedt.modernfix.dynresources.DynamicRegistryMap;

public class DynamicModelSystem {
    private static final class_7654 MODEL_LISTER = class_7654.method_45114((String)"models");
    private static final class_7654 BLOCKSTATE_LISTER = class_7654.method_45114((String)"blockstates");
    public static final boolean DEBUG_DYNAMIC_MODEL_LOADING = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    private static final Object NULL_BAKED = new Object();

    public static Map<class_2960, class_1100> createDynamicUnbakedModelMap(final Map<class_2960, class_3298> resourceMap) {
        LoadingCache unbakedModelCache = CacheBuilder.newBuilder().softValues().maximumSize(1000L).build((CacheLoader)new CacheLoader<class_2960, class_1100>(){

            public class_1100 load(class_2960 key) throws Exception {
                class_3298 resource = (class_3298)resourceMap.get(MODEL_LISTER.method_45112(key));
                if (resource == null) {
                    throw new IllegalArgumentException("Model " + String.valueOf(key) + " does not exist in map");
                }
                if (DEBUG_DYNAMIC_MODEL_LOADING) {
                    ModernFix.LOGGER.info("Loading unbaked model {}", (Object)key);
                }
                try (BufferedReader reader = resource.method_43039();){
                    class_1100 class_11002 = UnbakedModelDeserializerRegistry.deserialize((Reader)reader);
                    return class_11002;
                }
            }
        });
        Set unbakedIdSet = resourceMap.keySet().stream().map(arg_0 -> ((class_7654)MODEL_LISTER).method_45115(arg_0)).collect(Collectors.toUnmodifiableSet());
        return Maps.asMap(unbakedIdSet, key -> key != null ? (class_1100)unbakedModelCache.getUnchecked(key) : null);
    }

    private static Set<class_2680> getAllBlockStates() {
        return ((IdMapperAccessor)class_2248.field_10651).getReferenceMap().keySet();
    }

    public static class_9824.class_10095 createDynamicBlockStateLoadedModels(final Map<class_2960, List<class_3298>> resourceMap, final SingleBlockStateEntryLoader entryLoader) {
        LoadingCache definitionCache = CacheBuilder.newBuilder().softValues().maximumSize(1000L).build((CacheLoader)new CacheLoader<class_2960, class_9824.class_10095>(){

            public class_9824.class_10095 load(class_2960 key) throws Exception {
                if (DEBUG_DYNAMIC_MODEL_LOADING) {
                    ModernFix.LOGGER.info("Loading blockstate definition for {}", (Object)key);
                }
                class_2960 file = BLOCKSTATE_LISTER.method_45112(key);
                List<class_3298> resources = resourceMap.getOrDefault(file, List.of());
                return entryLoader.loadEntry(file, resources);
            }
        });
        Map<class_2960, class_2689<class_2248, class_2680>> staticDefinitions = BlockStateDefinitionsAccessor.getStaticDefinitions();
        Map<class_2680, class_2960> staticIdentifiers = staticDefinitions.entrySet().stream().flatMap(e -> ((class_2689)e.getValue()).method_11662().stream().map(s -> Map.entry(s, (class_2960)e.getKey()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        DisjointSetUnion<class_2680> blockStateSet = new DisjointSetUnion<class_2680>(DynamicModelSystem.getAllBlockStates(), staticIdentifiers.keySet());
        return new class_9824.class_10095(Maps.asMap(blockStateSet, state -> {
            class_2960 identifier = (class_2960)staticIdentifiers.get(state);
            if (identifier == null) {
                identifier = class_7923.field_41175.method_10221((Object)state.method_26204());
            }
            class_9824.class_10095 loadedModels = (class_9824.class_10095)definitionCache.getUnchecked((Object)identifier);
            return (class_1087.class_9979)loadedModels.comp_3063().get(state);
        }));
    }

    public static <K, U, V> Map<K, V> createDynamicBakedRegistry(final Map<K, U> input, final BiFunction<K, U, V> baker) {
        LoadingCache bakedCache = CacheBuilder.newBuilder().softValues().maximumSize(1000L).build(new CacheLoader<K, Object>(){

            public Object load(K key) throws Exception {
                Object unbaked = input.get(key);
                if (unbaked != null) {
                    if (DEBUG_DYNAMIC_MODEL_LOADING) {
                        ModernFix.LOGGER.info("Baking {}", key);
                    }
                    return baker.apply(key, unbaked);
                }
                return NULL_BAKED;
            }
        });
        return new DynamicRegistryMap<Object, Object>(input.keySet(), k -> {
            if (k != null) {
                Object value = bakedCache.getUnchecked(k);
                if (value == NULL_BAKED) {
                    value = null;
                }
                return value;
            }
            return null;
        });
    }

    public static interface SingleBlockStateEntryLoader {
        public class_9824.class_10095 loadEntry(class_2960 var1, List<class_3298> var2);
    }

    public static class BlockGroupingMap
    extends AbstractObject2IntMap<class_2680> {
        private final class_324 blockColors;
        private final class_9824.class_10095 loadedModels;
        private final Object2IntMap<GroupKey> groupKeyToId;

        public BlockGroupingMap(class_324 blockColors, class_9824.class_10095 loadedModels) {
            this.blockColors = blockColors;
            this.loadedModels = loadedModels;
            this.groupKeyToId = new Object2IntOpenHashMap();
        }

        public int size() {
            return 0;
        }

        public ObjectSet<Object2IntMap.Entry<class_2680>> object2IntEntrySet() {
            return ObjectSets.emptySet();
        }

        public int getInt(Object key) {
            return -1;
        }

        record GroupKey(Object equalityGroup, List<Object> coloringValues) {
        }
    }

    public record DynamicResolver(Map<class_2960, class_1100> inputModels, class_9824.class_10095 loadedModels, class_10521.class_10522 loadedClientInfos) {
        private class_10819 resolveModel(class_2960 id) {
            class_10097 discovery = new class_10097(this.inputModels, class_10096.method_62629());
            discovery.method_68024(class_801.field_55273, (class_1100)new class_801());
            if (!id.equals((Object)class_801.field_55273)) {
                class_1100 unbaked = this.inputModels.get(id);
                if (unbaked != null) {
                    class_10097.class_10814 wrapper = discovery.method_68029(id, unbaked);
                    ((ModelDiscoveryAccessor)discovery).mfix$getModelWrappers().put((Object)id, (Object)wrapper);
                } else {
                    ModernFix.LOGGER.warn("Cannot find the root model for {}", (Object)id);
                }
            }
            Map resolved = discovery.method_68028();
            return resolved.getOrDefault(id, discovery.method_68022());
        }

        public class_1092.class_10816 resolvedModels() {
            class_10819 resolvedMissingModel = new class_10097(this.inputModels, class_10096.method_62629()).method_68022();
            LoadingCache resolvedModelCache = CacheBuilder.newBuilder().softValues().maximumSize(1000L).build((CacheLoader)new CacheLoader<class_2960, class_10819>(){

                public class_10819 load(class_2960 key) {
                    return this.resolveModel(key);
                }
            });
            return new class_1092.class_10816(resolvedMissingModel, Maps.asMap(this.inputModels.keySet(), arg_0 -> ((LoadingCache)resolvedModelCache).getUnchecked(arg_0)));
        }
    }
}

