/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8685;

public class GroupChatManager {
    private static final class_2960 TALK_OUTLINE = class_2960.method_60655((String)"voicechat", (String)"textures/icons/talk_outline.png");
    private static final class_2960 SPEAKER_OFF_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_small_off.png");

    public static void renderIcons(class_332 guiGraphics) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        guiGraphics.method_51448().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            guiGraphics.method_51448().translate((float)mc.method_22683().method_4486(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.method_51448().translate(0.0f, (float)mc.method_22683().method_4502());
        }
        guiGraphics.method_51448().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        guiGraphics.method_51448().scale(scale, scale);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            guiGraphics.method_51448().pushMatrix();
            if (vertical) {
                if (posY < 0) {
                    guiGraphics.method_51448().translate(0.0f, (float)i * -11.0f);
                } else {
                    guiGraphics.method_51448().translate(0.0f, (float)i * 11.0f);
                }
            } else if (posX < 0) {
                guiGraphics.method_51448().translate((float)i * -11.0f, 0.0f);
            } else {
                guiGraphics.method_51448().translate((float)i * 11.0f, 0.0f);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                guiGraphics.method_25290(class_10799.field_56883, TALK_OUTLINE, posX < 0 ? -10 : 0, posY < 0 ? -10 : 0, 0.0f, 0.0f, 10, 10, 16, 16);
            }
            class_8685 skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.method_25290(class_10799.field_56883, skin.comp_1626().comp_3627(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.method_25290(class_10799.field_56883, skin.comp_1626().comp_3627(), posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 40.0f, 8.0f, 8, 8, 64, 64);
            if (state.isDisabled()) {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate(posX < 0 ? -9.0f : 1.0f, posY < 0 ? -9.0f : 1.0f);
                guiGraphics.method_51448().scale(0.5f, 0.5f);
                guiGraphics.method_25290(class_10799.field_56883, SPEAKER_OFF_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.method_51448().popMatrix();
            }
            guiGraphics.method_51448().popMatrix();
        }
        guiGraphics.method_51448().popMatrix();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

