/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.fabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.steveplays28.noisium.Noisium;
import io.github.steveplays28.noisium.config.NoisiumConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class NoisiumFabricConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("noisium.json");
    private static ConfigData config = new ConfigData();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH, StandardCharsets.UTF_8);
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
                Noisium.LOGGER.info("Loaded Fabric config from {}", (Object)CONFIG_PATH);
            }
            catch (Exception e) {
                Noisium.LOGGER.error("Failed to load Fabric config, using defaults", (Throwable)e);
            }
        } else {
            NoisiumFabricConfig.save();
        }
        NoisiumFabricConfig.syncToSharedConfig();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_PATH, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            Noisium.LOGGER.debug("Saved Fabric config to {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            Noisium.LOGGER.error("Failed to save Fabric config", (Throwable)e);
        }
        NoisiumFabricConfig.syncToSharedConfig();
    }

    private static void syncToSharedConfig() {
        NoisiumConfig.get().update(NoisiumFabricConfig.config.noiseChunkGenerator, NoisiumFabricConfig.config.generationShapeConfig, NoisiumFabricConfig.config.chunkSection, NoisiumFabricConfig.config.chainedBlockSource, NoisiumFabricConfig.config.useGuiGraphics);
    }

    public static ConfigData getConfig() {
        return config;
    }

    public static void setConfig(ConfigData newConfig) {
        config = newConfig;
        NoisiumFabricConfig.save();
    }

    public static class ConfigData {
        public boolean noiseChunkGenerator = true;
        public boolean generationShapeConfig = true;
        public boolean chunkSection = true;
        public boolean chainedBlockSource = true;
        public boolean useGuiGraphics = true;
    }
}

