/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.BlockInfoLayer;
import journeymap.client.ui.fullscreen.layer.KeybindingInfoLayer;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.fullscreen.layer.ModOverlayLayer;
import journeymap.client.ui.fullscreen.layer.WaypointLayer;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class LayerDelegate {
    long lastClick = 0L;
    class_2338 lastBlockPos = null;
    private final List<DrawStep> drawSteps = new ArrayList<DrawStep>();
    private final List<Layer> layers = new ArrayList<Layer>();
    long lastHover = 0L;
    private final long hoverDelay = 10L;

    public LayerDelegate(Fullscreen fullscreen) {
        this.layers.add(new WaypointLayer(fullscreen));
        this.layers.add(new ModOverlayLayer(fullscreen));
        this.layers.add(new BlockInfoLayer(fullscreen));
        this.layers.add(new KeybindingInfoLayer(fullscreen));
    }

    public void onMouseMove(class_310 mc, Renderer renderer, Point2D.Double mousePosition, float fontScale, boolean isScrolling) {
        long now = class_156.method_658();
        if (this.lastBlockPos == null || !isScrolling && now - this.lastHover > 10L) {
            this.lastBlockPos = this.getBlockPos(mc, renderer, mousePosition);
            this.lastHover = now;
        }
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseMove(mc, renderer, mousePosition, this.lastBlockPos, fontScale, isScrolling));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public void onMouseClicked(class_310 mc, Renderer renderer, Point2D.Double mousePosition, int button, float fontScale) {
        this.lastBlockPos = renderer.getFullscreen().getBlockAtMouse();
        long sysTime = class_156.method_658();
        boolean doubleClick = sysTime - this.lastClick < 200L;
        this.lastClick = sysTime;
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseClick(mc, renderer, mousePosition, this.lastBlockPos, button, doubleClick, fontScale));
                if (layer.propagateClick()) continue;
                break;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public class_2338 getBlockPos(class_310 mc, Renderer renderer, Point2D.Double mousePosition) {
        ChunkRenderController crc;
        class_2338 seaLevel = renderer.getBlockAtPixel(mousePosition);
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(seaLevel);
        int y = seaLevel.method_10264();
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(seaLevel, renderer.getMapType());
        if (regionData != null && JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get().booleanValue()) {
            y = regionData.getTopY(seaLevel);
            return new class_2338(seaLevel.method_10263(), y, seaLevel.method_10260());
        }
        if (chunkMD != null && (crc = JourneymapClient.getInstance().getChunkRenderController()) != null) {
            class_1923 chunkCoord = chunkMD.getCoord();
            RegionCoord rCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(mc), renderer.getMapType(), chunkCoord.field_9181, chunkCoord.field_9180);
            BaseRenderer chunkRenderer = crc.getRenderer(rCoord, renderer.getMapType(), chunkMD);
            int blockY = chunkRenderer.getBlockHeight(chunkMD, seaLevel);
            return new class_2338(seaLevel.method_10263(), blockY, seaLevel.method_10260());
        }
        return new class_2338(seaLevel.method_10263(), y + 1, seaLevel.method_10260());
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawSteps;
    }

    public void update() {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            this.drawSteps.addAll(layer.update());
        }
    }
}

