/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RegionTileShaders;
import journeymap.client.texture.RegionTexture;
import journeymap.common.mixin.client.RenderTypeInvoker;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_12245;
import net.minecraft.class_12247;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

public class JMRenderTypes {
    public static final class_2960 WAYPOINT_DEFAULT_BEAM = class_2960.method_60654((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<class_2960, class_1921> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<class_1921>> REGION_TILE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_CLAMP_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_NOBLUR_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Object2ObjectOpenHashMap<class_2960, class_1921> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    public static final class_1921 MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.createRenderType("minimap_rectangle_mask", class_12247.method_75927((RenderPipeline)Pipelines.MINIMAP_RECTANGLE_MASK_RENDER_PIPELINE).method_75930(class_12245.field_63975).method_75938());
    public static final class_1921 RECTANGLE_RENDER_TYPE = JMRenderTypes.createRenderType("rectangle", class_12247.method_75927((RenderPipeline)Pipelines.RECTANGLE_RENDER_PIPELINE).method_75930(class_12245.field_63975).method_75938());
    public static final class_1921 GRID_LINES_RENDER_TYPE = JMRenderTypes.createRenderType("grid_lines", class_12247.method_75927((RenderPipeline)Pipelines.GRID_LINES_RENDER_PIPELINE).method_75930(class_12245.field_63975).method_75937().method_75938());
    public static final class_1921 POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.createRenderType("polygon", class_12247.method_75927((RenderPipeline)Pipelines.POLYGON_POS_PIPELINE).method_75930(class_12245.field_63975).method_75938());
    public static final class_1921 POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.createRenderType("polygon_stroke", class_12247.method_75927((RenderPipeline)Pipelines.POLYGON_STROKE_PIPELINE).method_75930(class_12245.field_63975).method_75938());

    public static void registerMapShader(String key, RenderPipeline shader) {
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader() {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_NOBLUR_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        ICON_CLAMP_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
    }

    public static void clearRegionRenderTypes(int id) {
        if (id != -1) {
            Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
            if (map != null) {
                map.clear();
            }
            REGION_TILE_RENDER_TYPE_MAP.remove(id);
        }
    }

    public static class_1921 getRegionTile(RegionTexture texture, int shaderIndex) {
        class_1921 type;
        int id = ((class_10868)texture.method_68004()).method_68427();
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            REGION_TILE_RENDER_TYPE_MAP.put(id, (Object)map);
        }
        if ((type = (class_1921)map.get(shaderIndex)) == null) {
            String shader = RegionTileShaders.from(shaderIndex);
            RenderPipeline shaderState = Pipelines.REGION_SHADERS_MAP.get((Object)shader) == null ? Pipelines.REGION_DEFAULT_RENDER_PIPELINE : (RenderPipeline)Pipelines.REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.createRenderType("region_tile" + id, class_12247.method_75927((RenderPipeline)shaderState).method_75934("Sampler0", texture.getTextureLocation()).method_75930(class_12245.field_63975).method_75938());
            map.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getCircleMask(class_2960 identifier) {
        return JMRenderTypes.createRenderType("circle_mask", class_12247.method_75927((RenderPipeline)Pipelines.CIRCLE_MASK_PIPELINE).method_76560("Sampler0", identifier, () -> RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST)).method_75930(class_12245.field_63975).method_75938());
    }

    public static class_1921 getPolygonWithTexture(class_1044 texture, class_2960 identifier) {
        int id = ((class_10868)texture.method_68004()).method_68427();
        class_1921 type = (class_1921)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get((Object)identifier);
        if (type == null) {
            type = JMRenderTypes.createRenderType("polygon" + identifier.method_36181(), class_12247.method_75927((RenderPipeline)Pipelines.POLYGON_WITH_TEXTURE_RENDER_PIPELINE).method_75934("Sampler0", identifier).method_75930(class_12245.field_63975).method_75938());
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put((Object)identifier, (Object)type);
        }
        return type;
    }

    public static class_1921 getGridLines(class_2960 identifier) {
        class_1921 type = (class_1921)GRID_LINES_RENDER_TYPE_MAP.get((Object)identifier);
        if (type == null) {
            type = JMRenderTypes.createRenderType("grid_lines_" + identifier.method_36181(), class_12247.method_75927((RenderPipeline)Pipelines.GRID_LINES_RENDER_TYPE_PIPELINE).method_75934("Sampler0", identifier).method_75930(class_12245.field_63975).method_75937().method_75938());
            GRID_LINES_RENDER_TYPE_MAP.put((Object)identifier, (Object)type);
        }
        return type;
    }

    public static class_1921 createRenderType(String name, class_12247 setup) {
        return RenderTypeInvoker.invokeCreate(name, setup);
    }
}

