/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import journeymap.api.services.Services;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.model.block.BiomeMD;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.world.BiomeColors;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_5321;
import org.apache.logging.log4j.Logger;

public class VanillaBlockColorProxy
implements IBlockColorProxy {
    static Logger logger = Journeymap.getLogger();
    private final class_324 blockColors = class_310.method_1551().method_1505();
    private final CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        class_2680 blockState = blockMD.getBlockState();
        try {
            if (blockState.method_26204() instanceof class_2404) {
                return VanillaBlockColorProxy.getSpriteColor(blockMD, 0xBCBCBC, chunkMD, blockPos);
            }
            Integer color = VanillaBlockColorProxy.getSpriteColor(blockMD, null, chunkMD, blockPos);
            if (color == null) {
                color = VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
            }
            return color;
        }
        catch (Throwable e) {
            logger.error("Error deriving color for " + String.valueOf(blockMD) + ": " + LogFormatter.toPartialString(e));
            blockMD.addFlags(BlockFlag.Error);
            return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
        }
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos) {
        boolean showBiomeWaterColor = this.coreProperties.mapWaterBiomeColors.get();
        int result = blockMD.getTextureColor(chunkMD, blockPos);
        if (blockMD.isFoliage()) {
            result = RGB.adjustBrightness(result, 0.8f);
        } else if (!(!blockMD.isFluid() || blockMD.isWater() && showBiomeWaterColor)) {
            return RGB.multiply(result, Services.CLIENT_SERVICE.getFluidTint(blockMD));
        }
        return RGB.multiply(result, this.getColorMultiplier(chunkMD, blockMD, blockPos, blockMD.getBlockState().method_26217().ordinal()));
    }

    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos, int tintIndex) {
        boolean blendFoliage = this.coreProperties.mapBlendFoliage.get();
        boolean blendGrass = this.coreProperties.mapBlendGrass.get();
        boolean blendWater = this.coreProperties.mapBlendWater.get();
        if (blockMD.isGrass()) {
            if (blendGrass) {
                return BiomeColors.getAverageGrassColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((class_5321<class_1959>)((class_5321)chunkMD.getBiomeHolder(blockPos).method_40230().get())).getGrassColor(blockPos.method_10263(), blockPos.method_10260());
        }
        if (blockMD.isFoliage()) {
            if (blendFoliage) {
                return BiomeColors.getAverageFoliageColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((class_5321<class_1959>)((class_5321)chunkMD.getBiomeHolder(blockPos).method_40230().get())).getFoliageColor();
        }
        if (blockMD.isWater()) {
            if (blendWater) {
                return BiomeColors.getAverageWaterColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((class_5321<class_1959>)((class_5321)chunkMD.getBiomeHolder(blockPos).method_40230().get())).getWaterColor();
        }
        return this.blockColors.method_1697(blockMD.getBlockState(), (class_1920)JmBlockAccess.INSTANCE, blockPos, tintIndex);
    }

    public static Integer getSpriteColor(@Nonnull BlockMD blockMD, @Nullable Integer defaultColor, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, chunkMD, blockPos);
        float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
        if (rgba != null) {
            return RGB.toInteger(rgba);
        }
        return defaultColor;
    }

    public static int setBlockColorToError(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockFlag.Ignore, BlockFlag.Error);
        blockMD.setColor(-1);
        return -1;
    }

    public static int setBlockColorToMaterial(BlockMD blockMD) {
        try {
            blockMD.setAlpha(1.0f);
            blockMD.addFlags(BlockFlag.Ignore);
            return blockMD.setColor(blockMD.getBlock().method_26403().field_16011);
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to use MaterialMapColor, marking as error: %s", blockMD));
            return VanillaBlockColorProxy.setBlockColorToError(blockMD);
        }
    }
}

