/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.minecraft.class_9799;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class ByteBufferBuilderPool {
    private static final ReferenceList<Entry> FREE = new ReferenceArrayList();
    private static final ReferenceList<Entry> IN_USE = new ReferenceArrayList();
    private static final Reference2ObjectMap<class_9799, Entry> BUFFER_BUILDER_MAPPING = new Reference2ObjectOpenHashMap();

    private ByteBufferBuilderPool() {
    }

    public static class_9799 borrowBufferBuilder() {
        Entry entry;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            entry = new Entry(new class_9799(256));
        } else {
            entry = (Entry)FREE.removeFirst();
            if (entry.bufferBuilder.field_52082 == 0L) {
                BUFFER_BUILDER_MAPPING.remove((Object)entry.bufferBuilder);
                entry = new Entry(new class_9799(256));
            }
        }
        IN_USE.add((Object)entry);
        BUFFER_BUILDER_MAPPING.put((Object)entry.bufferBuilder, (Object)entry);
        entry.onBorrow();
        return entry.bufferBuilder;
    }

    public static void returnBufferBuilderSafe(class_9799 bufferBuilder) {
        RenderSystem.assertOnRenderThread();
        Entry entry = (Entry)BUFFER_BUILDER_MAPPING.get((Object)bufferBuilder);
        if (!IN_USE.remove((Object)entry)) {
            return;
        }
        entry.onReturn();
        FREE.addFirst((Object)entry);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            boolean leak = IN_USE.removeIf(entry -> {
                if (entry.inUseOverMultipleFrames) {
                    entry.onReturn();
                    FREE.addFirst(entry);
                    return true;
                }
                return false;
            });
            if (leak) {
                ImmediatelyFast.LOGGER.warn("Some BufferBuilders were not returned to the pool. Forcibly reclaiming them to prevent a memory leak.");
            }
            for (Entry entry2 : IN_USE) {
                entry2.inUseOverMultipleFrames = true;
            }
        }
        FREE.removeIf(entry -> {
            if (entry.shouldBeClosed()) {
                entry.bufferBuilder.close();
                BUFFER_BUILDER_MAPPING.remove((Object)entry.bufferBuilder);
                return true;
            }
            return false;
        });
    }

    private static class Entry {
        private final class_9799 bufferBuilder;
        private long lastAccessTime;
        private boolean inUseOverMultipleFrames;

        public Entry(class_9799 bufferBuilder) {
            this.bufferBuilder = bufferBuilder;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public boolean shouldBeClosed() {
            return System.currentTimeMillis() - this.lastAccessTime > 60000L;
        }

        public void onBorrow() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public void onReturn() {
            this.bufferBuilder.method_60811();
            this.inUseOverMultipleFrames = false;
        }
    }
}

