/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

class FabricConfig {
    private static final Path path = FabricLoader.getInstance().getConfigDir().resolve("extremesoundmuffler.json5");
    private static PropertyMirror<List<String>> forbiddenSounds = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
    private static PropertyMirror<List<String>> modsMuffled = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
    private static PropertyMirror<Boolean> lawfulAllList = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> disableInventoryButton = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> disableCreativeInventoryButton = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> disableAnchors = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> leftButtons = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> showTip = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Boolean> useDarkTheme = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static PropertyMirror<Double> defaultMuteVolume = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    private static PropertyMirror<Integer> invButtonHorizontal = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static PropertyMirror<Integer> invButtonVertical = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static PropertyMirror<Integer> creativeInvButtonHorizontal = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static PropertyMirror<Integer> creativeInvButtonVertical = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static final ConfigTree CONFIG = ConfigTree.builder().fork("General settings").beginValue("forbiddenSounds", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Arrays.asList("ui.", "music.", "ambient.")).withComment("General settings: ").withComment("").withComment("Blacklisted Sounds - add the name of the sounds to blacklist, separated with comma").finishValue(arg_0 -> forbiddenSounds.mirror(arg_0)).beginValue("modsMuffled", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), new ArrayList()).withComment("General mod muffling, any sound from these mods will be muffled down to the provided volume. \n Name of the mod and desired volume, separated by \":\" \n Example: \"minecraft:50\", \"extremesoundmuffler:0\"").finishValue(arg_0 -> modsMuffled.mirror(arg_0)).beginValue("lawfulAllList", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Allow the \"ALL\" sounds list to include the blacklisted sounds?").finishValue(arg_0 -> lawfulAllList.mirror(arg_0)).beginValue("defaultMuteVolume", (ConfigType)ConfigTypes.DOUBLE, (Object)0.0).withComment("Range: 0.0 ~ 0.9").withComment("Volume set when pressed the mute button by default").finishValue(arg_0 -> defaultMuteVolume.mirror(arg_0)).beginValue("leftButtons", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set to true to move the muffle and play buttons to the left side of the GUI").finishValue(arg_0 -> leftButtons.mirror(arg_0)).beginValue("showTip", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show tips in the Muffler screen?").finishValue(arg_0 -> showTip.mirror(arg_0)).beginValue("useDarkTheme", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Whether or not use the dark theme").finishValue(arg_0 -> useDarkTheme.mirror(arg_0)).finishBranch().fork("Inventory button settings").beginValue("disableInventoryButton", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("").withComment("Inventory button settings").withComment("").withComment("Disable the Muffle button in the player inventory?").finishValue(arg_0 -> disableInventoryButton.mirror(arg_0)).beginValue("invButtonHorizontal", (ConfigType)ConfigTypes.INTEGER, (Object)75).withComment("Coordinates for the Muffler button in the player inventory. \nYou can change this in game by holding the RMB over the button and draging it around").finishValue(arg_0 -> invButtonHorizontal.mirror(arg_0)).beginValue("invButtonVertical", (ConfigType)ConfigTypes.INTEGER, (Object)7).withComment("Coordinates for the Muffler button in the player inventory. \nYou can change this in game by holding the RMB over the button and draging it around").finishValue(arg_0 -> invButtonVertical.mirror(arg_0)).beginValue("disableCreativeInventoryButton", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disable the Muffle button in the creative player inventory?").finishValue(arg_0 -> disableCreativeInventoryButton.mirror(arg_0)).beginValue("creativeInvButtonHorizontal", (ConfigType)ConfigTypes.INTEGER, (Object)2).withComment("Coordinates for the Muffler button in the creative player inventory. \nYou can change this in game by holding the RMB over the button and draging it around").finishValue(arg_0 -> creativeInvButtonHorizontal.mirror(arg_0)).beginValue("creativeInvButtonVertical", (ConfigType)ConfigTypes.INTEGER, (Object)2).withComment("Coordinates for the Muffler button in the creative player inventory. \nYou can change this in game by holding the RMB over the button and draging it around").finishValue(arg_0 -> creativeInvButtonVertical.mirror(arg_0)).finishBranch().fork("Anchor settings").beginValue("disableAnchors", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disable the Anchors?").finishValue(arg_0 -> disableAnchors.mirror(arg_0)).finishBranch().build();

    FabricConfig() {
    }

    static void init() {
        CommonConfig.set(new CommonConfig.ConfigAccess(() -> forbiddenSounds.getValue(), () -> modsMuffled.getValue(), () -> lawfulAllList.getValue(), () -> disableInventoryButton.getValue(), () -> disableCreativeInventoryButton.getValue(), () -> disableAnchors.getValue(), () -> leftButtons.getValue(), () -> showTip.getValue(), () -> useDarkTheme.getValue(), () -> defaultMuteVolume.getValue(), () -> invButtonHorizontal.getValue(), () -> invButtonVertical.getValue(), () -> creativeInvButtonHorizontal.getValue(), () -> creativeInvButtonVertical.getValue()));
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        FabricConfig.writeDefaultConfig(serializer);
        FabricConfig.readConfig(serializer);
    }

    private static void writeDefaultConfig(JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void readConfig(JanksonValueSerializer serializer) {
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            Constants.LOG.error("Error loading ESM config", e);
        }
    }

    static void updateConfig(JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.SYNC));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static List<String> getForbiddenSounds() {
        return (List)forbiddenSounds.getValue();
    }

    static List<String> getModsMuffled() {
        return (List)modsMuffled.getValue();
    }

    static void setInvButtonHorizontal(int x) {
        invButtonHorizontal.setValue((Object)x);
    }

    static void setInvButtonVertical(int y) {
        invButtonVertical.setValue((Object)y);
    }

    static void setCreativeInvButtonHorizontal(int x) {
        creativeInvButtonHorizontal.setValue((Object)x);
    }

    static void setCreativeInvButtonVertical(int y) {
        creativeInvButtonVertical.setValue((Object)y);
    }
}

