/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import net.caffeinemc.mods.sodium.client.render.chunk.tree.BaseForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.Tree;

public abstract class BaseMultiForest<T extends Tree>
extends BaseForest<T> {
    protected final T[] trees;
    protected final int forestDim;
    protected T lastTree;

    public BaseMultiForest(int baseOffsetX, int baseOffsetY, int baseOffsetZ, float buildDistance) {
        super(baseOffsetX, baseOffsetY, baseOffsetZ, buildDistance);
        this.forestDim = BaseMultiForest.forestDimFromBuildDistance(buildDistance);
        this.trees = this.makeTrees(this.forestDim * this.forestDim * this.forestDim);
    }

    public static int forestDimFromBuildDistance(float buildDistance) {
        return (int)Math.ceil(((double)buildDistance / 8.0 + 1.0) / 64.0);
    }

    protected int getTreeIndex(int localX, int localY, int localZ) {
        int treeX = localX >> 6;
        int treeY = localY >> 6;
        int treeZ = localZ >> 6;
        if (treeX < 0 || treeX >= this.forestDim || treeY < 0 || treeY >= this.forestDim || treeZ < 0 || treeZ >= this.forestDim) {
            return -1;
        }
        return treeX + (treeZ * this.forestDim + treeY) * this.forestDim;
    }

    @Override
    public void add(int x, int y, int z) {
        if (this.lastTree != null && ((Tree)this.lastTree).add(x, y, z)) {
            return;
        }
        int localX = x - this.baseOffsetX;
        int localY = y - this.baseOffsetY;
        int localZ = z - this.baseOffsetZ;
        int treeIndex = this.getTreeIndex(localX, localY, localZ);
        if (treeIndex == -1) {
            return;
        }
        T tree = this.trees[treeIndex];
        if (tree == null) {
            int treeOffsetX = this.baseOffsetX + (localX & 0xFFFFFFC0);
            int treeOffsetY = this.baseOffsetY + (localY & 0xFFFFFFC0);
            int treeOffsetZ = this.baseOffsetZ + (localZ & 0xFFFFFFC0);
            this.trees[treeIndex] = tree = this.makeTree(treeOffsetX, treeOffsetY, treeOffsetZ);
        }
        ((Tree)tree).add(x, y, z);
        this.lastTree = tree;
    }

    @Override
    public int getPresence(int x, int y, int z) {
        int result;
        if (this.lastTree != null && (result = ((Tree)this.lastTree).getPresence(x, y, z)) != -1) {
            return result;
        }
        int localX = x - this.baseOffsetX;
        int localY = y - this.baseOffsetY;
        int localZ = z - this.baseOffsetZ;
        int treeIndex = this.getTreeIndex(localX, localY, localZ);
        if (treeIndex == -1) {
            return -1;
        }
        T tree = this.trees[treeIndex];
        if (tree != null) {
            this.lastTree = tree;
            return ((Tree)tree).getPresence(x, y, z);
        }
        return -1;
    }

    protected abstract T[] makeTrees(int var1);
}

