/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.gui.screen;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.gui.screen.AuthScreen;
import me.axieum.mcmod.authme.api.util.MicrosoftUtils;
import me.axieum.mcmod.authme.api.util.SessionUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import org.apache.http.conn.ConnectTimeoutException;

public class MicrosoftAuthScreen
extends AuthScreen {
    private ExecutorService executor = null;
    private CompletableFuture<Void> task = null;
    private class_7842 statusWidget = null;
    private final boolean selectAccount;

    public MicrosoftAuthScreen(class_437 parentScreen, class_437 successScreen, boolean selectAccount) {
        super((class_2561)class_2561.method_43471((String)"gui.authme.microsoft.title"), parentScreen, successScreen);
        this.selectAccount = selectAccount;
        this.closeOnSuccess = true;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        class_7842 titleWidget = (class_7842)this.method_37063((class_364)new class_7842((class_2561)this.field_22785.method_27661().method_54663(0xFFFFFF), this.field_22793));
        AuthScreen.centerPosition((class_8021)titleWidget, this, 0, -20);
        this.statusWidget = (class_7842)this.method_37063((class_364)new class_7842((class_2561)this.field_22785.method_27661().method_54663(0xDDDDDD), this.field_22793));
        AuthScreen.centerPosition((class_8021)this.statusWidget, this, 0, 15);
        class_4185 cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 22, 100, 20).method_46431();
        this.method_37063((class_364)cancelBtn);
        if (this.task != null) {
            return;
        }
        class_310 client = class_310.method_1551();
        this.updateStatusWidget(client, "gui.authme.microsoft.status.checkBrowser");
        this.executor = Executors.newSingleThreadExecutor();
        this.task = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)MicrosoftUtils.acquireMSAuthCode(success -> class_2561.method_43471((String)"gui.authme.microsoft.browser").getString(), this.executor, this.selectAccount ? MicrosoftUtils.MicrosoftPrompt.SELECT_ACCOUNT : null).thenComposeAsync(msAuthCode -> {
            this.updateStatusWidget(client, "gui.authme.microsoft.status.msAccessToken");
            return MicrosoftUtils.acquireMSAccessToken(msAuthCode, this.executor);
        })).thenComposeAsync(msAccessToken -> {
            this.updateStatusWidget(client, "gui.authme.microsoft.status.xboxAccessToken");
            return MicrosoftUtils.acquireXboxAccessToken(msAccessToken, this.executor);
        })).thenComposeAsync(xboxAccessToken -> {
            this.updateStatusWidget(client, "gui.authme.microsoft.status.xboxXstsToken");
            return MicrosoftUtils.acquireXboxXstsToken(xboxAccessToken, this.executor);
        })).thenComposeAsync(xboxXstsData -> {
            this.updateStatusWidget(client, "gui.authme.microsoft.status.mcAccessToken");
            return MicrosoftUtils.acquireMCAccessToken((String)xboxXstsData.get("Token"), (String)xboxXstsData.get("uhs"), this.executor);
        })).thenComposeAsync(mcToken -> {
            this.updateStatusWidget(client, "gui.authme.microsoft.status.mcProfile");
            return MicrosoftUtils.login(mcToken, this.executor);
        })).thenAccept(user -> {
            SessionUtils.setUser(user);
            class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"gui.authme.toast.greeting", (Object[])new Object[]{class_2561.method_43470((String)user.method_1676())}), null);
            AuthMe.LOGGER.info("Successfully logged in via Microsoft!");
            this.success = true;
        })).exceptionally(error -> {
            String key;
            if (error.getCause() instanceof ConnectTimeoutException) {
                key = "gui.authme.error.timeout";
            } else if ("NOT_FOUND: Not Found".equals(error.getCause().getMessage())) {
                key = "gui.authme.error.notPurchased";
            } else {
                AuthMe.LOGGER.error("Could not login via Microsoft!", error);
                key = "gui.authme.error.generic";
            }
            client.execute(() -> {
                this.statusWidget.method_25355((class_2561)class_2561.method_43471((String)key).method_27692(class_124.field_1061));
                AuthScreen.centerPosition((class_8021)this.statusWidget, this, 0, 15);
            });
            cancelBtn.method_25355((class_2561)class_2561.method_43471((String)"gui.back"));
            return null;
        });
    }

    private void updateStatusWidget(class_310 client, String translatableKey) {
        client.execute(() -> {
            this.statusWidget.method_25355((class_2561)class_2561.method_43471((String)translatableKey));
            AuthScreen.centerPosition((class_8021)this.statusWidget, this, 0, 15);
        });
    }

    @Override
    public void method_25419() {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
            this.executor.shutdownNow();
        }
        super.method_25419();
    }
}

