/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stackrefill_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class RefillEvent {
    private static final List<Pair<Player, ItemStack>> addStackList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> addSingleList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<Player, InteractionHand>> checkFishingRodList = Collections.synchronizedList(new ArrayList());
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> checkItemUsedList = Collections.synchronizedList(new ArrayList());

    public static void onWorldTick(ServerLevel world) {
        RefillEvent.processTick(false);
    }

    public static void processTick(boolean isClientSide) {
        block27: {
            try {
                ItemStack handstack;
                Player player;
                InteractionHand hand;
                Pair insidepair;
                Player player2;
                Pair<Player, ItemStack> pair;
                if (!addStackList.isEmpty()) {
                    pair = addStackList.getFirst();
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        ItemStack stackToGive = (ItemStack)pair.getSecond();
                        if (player2.isAlive()) {
                            ItemStack heldmainhand = player2.getMainHandItem();
                            if (heldmainhand.isEmpty()) {
                                player2.setItemInHand(InteractionHand.MAIN_HAND, stackToGive);
                            } else {
                                ItemFunctions.giveOrDropItemStack((Player)player2, (ItemStack)stackToGive);
                            }
                        } else {
                            player2.drop(stackToGive, false);
                        }
                        player2.getInventory().setChanged();
                    }
                    addStackList.removeFirst();
                }
                if (!addSingleList.isEmpty()) {
                    pair = addSingleList.getFirst();
                    if (pair != null) {
                        insidepair = (Pair)pair.getSecond();
                        hand = (InteractionHand)pair.getFirst();
                        player = (Player)insidepair.getFirst();
                        ItemStack stackToGive = (ItemStack)insidepair.getSecond();
                        if (player.isAlive()) {
                            handstack = player.getItemInHand(hand).copy();
                            player.setItemInHand(hand, stackToGive);
                            if (!handstack.isEmpty()) {
                                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                            }
                        } else {
                            player.drop(stackToGive, false);
                        }
                        player.getInventory().setChanged();
                    }
                    addSingleList.removeFirst();
                }
                if (!checkFishingRodList.isEmpty()) {
                    pair = checkFishingRodList.getFirst();
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        if (player2.isAlive() && player2.getItemInHand(hand = (InteractionHand)pair.getSecond()).isEmpty()) {
                            Inventory inv = player2.getInventory();
                            for (int i = 35; i > 8; --i) {
                                ItemStack slot = inv.getItem(i);
                                if (!(slot.getItem() instanceof FishingRodItem)) continue;
                                player2.setItemInHand(hand, slot.copy());
                                slot.setCount(0);
                                break;
                            }
                        }
                        player2.getInventory().setChanged();
                    }
                    checkFishingRodList.removeFirst();
                }
                if (checkItemUsedList.isEmpty()) break block27;
                pair = checkItemUsedList.getFirst();
                if (pair != null) {
                    insidepair = (Pair)pair.getSecond();
                    hand = (InteractionHand)pair.getFirst();
                    player = (Player)insidepair.getFirst();
                    if (player.isAlive() && !player.isUsingItem()) {
                        ItemStack usedstack = (ItemStack)insidepair.getSecond();
                        handstack = player.getItemInHand(hand).copy();
                        if (!usedstack.getItem().equals(handstack.getItem()) || usedstack.getCount() != handstack.getCount()) {
                            boolean shouldcontinue = false;
                            if (handstack.getCount() <= 1) {
                                if (usedstack.getItem().equals(handstack.getItem())) {
                                    if (handstack.isEmpty()) {
                                        shouldcontinue = true;
                                    }
                                } else {
                                    shouldcontinue = true;
                                }
                            }
                            if (shouldcontinue) {
                                Item useditem = usedstack.getItem();
                                Inventory inv = player.getInventory();
                                for (int i = 35; i > 8; --i) {
                                    ItemStack slot = inv.getItem(i);
                                    Item slotitem = slot.getItem();
                                    if (!useditem.equals(slotitem) || slotitem instanceof PotionItem && !Objects.equals(usedstack.get(DataComponents.POTION_CONTENTS), slot.get(DataComponents.POTION_CONTENTS))) continue;
                                    player.setItemInHand(hand, slot.copy());
                                    slot.setCount(0);
                                    if (!handstack.isEmpty()) {
                                        ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                                    }
                                    player.getInventory().setChanged();
                                    break;
                                }
                            }
                        }
                    }
                }
                checkItemUsedList.removeFirst();
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    public static ItemStack onItemUse(Player player, ItemStack used, ItemStack newItem, InteractionHand hand) {
        if (player.isCreative()) {
            return null;
        }
        int amount = used.getCount();
        if (amount > 1) {
            return null;
        }
        Pair insidepair = new Pair((Object)player, (Object)used.copy());
        Pair pair = new Pair((Object)hand, (Object)insidepair);
        checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        return null;
    }

    public static void onItemBreak(Player player, ItemStack used, InteractionHand hand) {
        if (player.isCreative()) {
            return;
        }
        if (used == null) {
            return;
        }
        Item useditem = used.getItem();
        if (useditem instanceof BlockItem || useditem instanceof BucketItem || useditem instanceof PotionItem) {
            return;
        }
        int amount = used.getCount();
        if (amount > 1) {
            return;
        }
        if (hand == null) {
            return;
        }
        Inventory inv = player.getInventory();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.getItem(i);
            Item slotitem = slot.getItem();
            if (!useditem.equals(slotitem)) continue;
            Pair insidepair = new Pair((Object)player, (Object)slot.copy());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            addSingleList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
            slot.setCount(0);
            break;
        }
        player.getInventory().setChanged();
    }

    public static void onItemToss(Player player, ItemStack tossedstack) {
        if (player.isCreative()) {
            return;
        }
        Item tosseditem = tossedstack.getItem();
        InteractionHand activehand = InteractionHand.MAIN_HAND;
        ItemStack activestack = player.getMainHandItem();
        if (!activestack.isEmpty()) {
            return;
        }
        if (tossedstack.getCount() > 1) {
            return;
        }
        Inventory inv = player.getInventory();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.getItem(i);
            Item slotitem = slot.getItem();
            if (!tosseditem.equals(slotitem) || slotitem instanceof PotionItem && !Objects.equals(tossedstack.get(DataComponents.POTION_CONTENTS), slot.get(DataComponents.POTION_CONTENTS))) continue;
            player.setItemInHand(activehand, slot.copy());
            slot.setCount(0);
            break;
        }
        player.getInventory().setChanged();
    }

    public static InteractionResult onItemRightClick(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCreative()) {
            return InteractionResult.PASS;
        }
        Item item = stack.getItem();
        if (item instanceof FishingRodItem) {
            int damage = stack.getDamageValue();
            int maxdamage = stack.getMaxDamage();
            if (maxdamage - damage < 5) {
                Pair toadd = new Pair((Object)player, (Object)hand);
                checkFishingRodList.add((Pair<Player, InteractionHand>)toadd);
            }
        } else if (item instanceof EggItem || item instanceof SnowballItem || item instanceof FireworkRocketItem) {
            if (stack.getCount() > 1) {
                return InteractionResult.PASS;
            }
            Pair insidepair = new Pair((Object)player, (Object)stack.copy());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        return InteractionResult.PASS;
    }

    public static void onBlockRightClick(Level world, Player player, InteractionHand activehand, BlockPos pos, BlockHitResult hitVec) {
        if (player.isCreative()) {
            return;
        }
        if (player.isUsingItem()) {
            return;
        }
        ItemStack active = player.getItemInHand(activehand);
        int amount = active.getCount();
        if (amount > 26) {
            return;
        }
        Pair insidepair = new Pair((Object)player, (Object)active.copy());
        Pair pair = new Pair((Object)activehand, (Object)insidepair);
        try {
            checkItemUsedList.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

