/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.audio.ogg;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.resource.resources.audio.ALAudio;
import de.keksuccino.fancymenu.util.resource.resources.audio.AudioPlayTimeTracker;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.melody.resources.audio.openal.ALAudioBuffer;
import de.keksuccino.melody.resources.audio.openal.ALAudioClip;
import de.keksuccino.melody.resources.audio.openal.ALUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3419;
import net.minecraft.class_4228;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OggAudio
implements IAudio,
ALAudio {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected volatile ALAudioClip clip;
    @Nullable
    protected volatile ALAudioBuffer audioBuffer;
    protected class_2960 sourceLocation;
    protected File sourceFile;
    protected String sourceURL;
    protected volatile float duration = 0.0f;
    protected final AudioPlayTimeTracker playTimeTracker = new AudioPlayTimeTracker();
    protected volatile boolean decoded = false;
    protected volatile boolean loadingCompleted = false;
    protected volatile boolean loadingFailed = false;
    protected volatile boolean closed = false;

    @NotNull
    public static OggAudio location(@NotNull class_2960 location) {
        return OggAudio.location(location, null);
    }

    @NotNull
    public static OggAudio location(@NotNull class_2960 location, @Nullable OggAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(location);
        OggAudio audio = writeTo != null ? writeTo : new OggAudio();
        audio.sourceLocation = location;
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! OpenAL not ready! Returning empty audio for: " + String.valueOf(location));
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Failed to create clip: " + String.valueOf(location), (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Clip was NULL: " + String.valueOf(location));
            return audio;
        }
        try {
            Optional resource = class_310.method_1551().method_1478().method_14486(location);
            if (resource.isPresent()) {
                InputStream in = ((class_3298)resource.get()).method_14482();
                OggAudio.of(in, location.toString(), audio, clip);
            }
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio from Identifier: " + String.valueOf(location), (Throwable)ex);
        }
        return audio;
    }

    @NotNull
    public static OggAudio local(@NotNull File oggAudioFile) {
        return OggAudio.local(oggAudioFile, null);
    }

    @NotNull
    public static OggAudio local(@NotNull File oggAudioFile, @Nullable OggAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(oggAudioFile);
        OggAudio audio = writeTo != null ? writeTo : new OggAudio();
        audio.sourceFile = oggAudioFile;
        if (!oggAudioFile.isFile()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio from file! File not found: " + oggAudioFile.getPath());
            return audio;
        }
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! OpenAL not ready! Returning empty audio for: " + oggAudioFile.getPath());
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Failed to create clip: " + oggAudioFile.getPath(), (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Clip was NULL: " + oggAudioFile.getPath());
            return audio;
        }
        try {
            FileInputStream in = new FileInputStream(oggAudioFile);
            OggAudio.of(in, oggAudioFile.getPath(), audio, clip);
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio from file: " + oggAudioFile.getPath(), (Throwable)ex);
        }
        return audio;
    }

    @NotNull
    public static OggAudio web(@NotNull String oggAudioURL) {
        return OggAudio.web(oggAudioURL, null);
    }

    @NotNull
    public static OggAudio web(@NotNull String oggAudioURL, @Nullable OggAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(oggAudioURL);
        OggAudio audio = writeTo != null ? writeTo : new OggAudio();
        audio.sourceURL = oggAudioURL;
        if (!TextValidators.BASIC_URL_TEXT_VALIDATOR.get(oggAudioURL).booleanValue()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio from URL! Invalid URL: " + oggAudioURL);
            return audio;
        }
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! OpenAL not ready! Returning empty audio for: " + oggAudioURL);
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Failed to create clip: " + oggAudioURL, (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Clip was NULL: " + oggAudioURL);
            return audio;
        }
        new Thread(() -> {
            InputStream webIn = null;
            try {
                webIn = WebUtils.openResourceStream(oggAudioURL);
                if (webIn == null) {
                    throw new NullPointerException("Web resource input stream was NULL!");
                }
                ByteArrayInputStream byteIn = new ByteArrayInputStream(webIn.readAllBytes());
                OggAudio.of(byteIn, oggAudioURL, audio, clip);
            }
            catch (Exception ex) {
                audio.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to read OGG audio from URL: " + oggAudioURL, (Throwable)ex);
            }
            CloseableUtils.closeQuietly(webIn);
        }).start();
        return audio;
    }

    @NotNull
    public static OggAudio of(@NotNull InputStream in, @Nullable String oggAudioName, @Nullable OggAudio writeTo, @Nullable ALAudioClip clip) {
        OggAudio audio;
        String name = oggAudioName != null ? oggAudioName : "[Generic InputStream Source]";
        OggAudio oggAudio = audio = writeTo != null ? writeTo : new OggAudio();
        if (clip == null) {
            RenderSystem.assertOnRenderThread();
        }
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! OpenAL not ready! Returning empty audio for: " + name);
            return audio;
        }
        try {
            audio.clip = clip != null ? clip : ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Failed to create clip: " + name, (Throwable)ex);
            return audio;
        }
        ALAudioClip cachedClip = audio.clip;
        if (cachedClip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read OGG audio! Clip was NULL: " + name);
            return audio;
        }
        new Thread(() -> {
            class_4228 stream = null;
            try {
                ALAudioBuffer audioBuffer;
                byte[] fullData = in.readAllBytes();
                ByteArrayInputStream byteIn = new ByteArrayInputStream(fullData);
                try {
                    stream = new class_4228((InputStream)byteIn);
                    ByteBuffer pcmData = stream.method_59757();
                    audio.duration = (float)(pcmData.remaining() / (2 * stream.method_19719().getChannels())) / stream.method_19719().getSampleRate();
                }
                catch (Exception ex) {
                    LOGGER.warn("[FANCYMENU] Failed to read OGG duration metadata, duration will be approximate: " + name, (Throwable)ex);
                }
                byteIn.reset();
                CloseableUtils.closeQuietly((AutoCloseable)stream);
                stream = new class_4228((InputStream)byteIn);
                ByteBuffer byteBuffer = stream.method_59757();
                audio.audioBuffer = audioBuffer = new ALAudioBuffer(byteBuffer, stream.method_19719());
                cachedClip.setStaticBuffer(audioBuffer);
                audio.decoded = true;
                audio.loadingCompleted = true;
            }
            catch (Exception ex) {
                audio.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to read OGG audio: " + name, (Throwable)ex);
            }
            CloseableUtils.closeQuietly(stream);
            CloseableUtils.closeQuietly(in);
        }).start();
        return audio;
    }

    @NotNull
    public static OggAudio of(@NotNull InputStream in) {
        return OggAudio.of(in, null, null, null);
    }

    protected OggAudio() {
    }

    protected void forClip(@NotNull Consumer<ALAudioClip> clip) {
        ALAudioClip cached = this.clip;
        if (cached != null) {
            clip.accept(cached);
        }
    }

    @Nullable
    public ALAudioClip getClip() {
        return this.clip;
    }

    @Override
    public void play() {
        this.forClip(oggAudioClip -> {
            try {
                oggAudioClip.play();
                this.playTimeTracker.onPlay();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public boolean isPlaying() {
        try {
            ALAudioClip cached = this.clip;
            if (cached != null) {
                return cached.isPlaying();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void pause() {
        this.forClip(oggAudioClip -> {
            try {
                oggAudioClip.pause();
                this.playTimeTracker.onPause();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public boolean isPaused() {
        try {
            ALAudioClip cached = this.clip;
            if (cached != null) {
                return cached.isPaused();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void stop() {
        this.forClip(oggAudioClip -> {
            try {
                oggAudioClip.stop();
                this.playTimeTracker.onStop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void setVolume(float volume) {
        this.forClip(oggAudioClip -> {
            try {
                oggAudioClip.setVolume(volume);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public float getVolume() {
        ALAudioClip cached = this.clip;
        return cached != null ? cached.getVolume() : 0.0f;
    }

    @Override
    public void setSoundChannel(@NotNull class_3419 channel) {
        this.forClip(oggAudioClip -> oggAudioClip.setSoundChannel(channel));
    }

    @Override
    @NotNull
    public class_3419 getSoundChannel() {
        ALAudioClip cached = this.clip;
        return cached != null ? cached.getSoundChannel() : class_3419.field_15250;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public float getPlayTime() {
        return this.playTimeTracker.getCurrentPlayTime();
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        if (this.sourceURL != null) {
            return WebUtils.openResourceStream(this.sourceURL);
        }
        if (this.sourceFile != null) {
            return new FileInputStream(this.sourceFile);
        }
        if (this.sourceLocation != null) {
            return class_310.method_1551().method_1478().open(this.sourceLocation);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        if (this.closed || !this.decoded) {
            return false;
        }
        ALAudioClip cachedClip = this.clip;
        if (cachedClip != null) {
            if (cachedClip.isClosed()) {
                return false;
            }
            if (cachedClip.isValidOpenAlSource()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLoadingCompleted() {
        return !this.closed && !this.loadingFailed && this.loadingCompleted;
    }

    @Override
    public boolean isLoadingFailed() {
        return this.loadingFailed;
    }

    public boolean isValidOpenAlSource() {
        ALAudioClip cached = this.clip;
        return cached != null && cached.isValidOpenAlSource();
    }

    @Override
    public int getALSource() {
        if (this.clip == null) {
            return 0;
        }
        try {
            Field f = ALAudioClip.class.getDeclaredField("source");
            f.setAccessible(true);
            return f.getInt(this.clip);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get AL source in OggAudio!", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            ALAudioClip cachedClip = this.clip;
            if (cachedClip != null) {
                cachedClip.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to close OGG audio clip!", (Throwable)ex);
        }
        this.clip = null;
        try {
            ALAudioBuffer cachedBuffer = this.audioBuffer;
            if (cachedBuffer != null) {
                cachedBuffer.delete();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to delete OGG audio buffer!", (Throwable)ex);
        }
        this.audioBuffer = null;
        this.decoded = false;
    }

    @Override
    public boolean isClosed() {
        ALAudioClip cachedClip;
        if (!this.closed && (cachedClip = this.clip) != null && !cachedClip.isValidOpenAlSource()) {
            this.close();
        }
        return this.closed;
    }
}

