/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinRealmsNotificationsScreen;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;

public class RealmsNotificationRenderer {
    private static final class_2960 UNSEEN_NOTIFICATION_SPRITE = class_2960.method_60656((String)"icon/unseen_notification");
    private static final class_2960 NEWS_SPRITE = class_2960.method_60656((String)"icon/news");
    private static final class_2960 INVITE_SPRITE = class_2960.method_60656((String)"icon/invite");
    private static final class_2960 TRIAL_AVAILABLE_SPRITE = class_2960.method_60656((String)"icon/trial_available");
    private final IMixinRealmsNotificationsScreen screenAccess;
    private final class_310 minecraft;
    private final int screenWidth;
    private final int screenHeight;

    public RealmsNotificationRenderer(@NotNull class_4399 screen, int screenWidth, int screenHeight) {
        this.screenAccess = (IMixinRealmsNotificationsScreen)screen;
        this.minecraft = class_310.method_1551();
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public int getDefaultPositionX() {
        int originalRightPosition = this.screenWidth / 2 + 100 - 3;
        return originalRightPosition - this.getTotalWidth();
    }

    public int getDefaultPositionY() {
        int k = this.screenHeight / 4 + 48;
        return k + 48 + 2;
    }

    public int getTotalWidth() {
        int iconCount = 0;
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        if (hasUnseenNotifications) {
            ++iconCount;
        }
        if (showOldNotifications) {
            if (hasUnreadNews) {
                ++iconCount;
            }
            if (pendingInvites > 0) {
                ++iconCount;
            }
            if (trialAvailable) {
                ++iconCount;
            }
        }
        return iconCount > 0 ? (iconCount - 1) * 16 + 14 : 0;
    }

    public int getTotalHeight() {
        return 18;
    }

    public void renderIcons(class_332 guiGraphics, int x, int y, int color) {
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        int currentX = x;
        if (trialAvailable && showOldNotifications) {
            guiGraphics.method_52707(class_10799.field_56883, TRIAL_AVAILABLE_SPRITE, currentX, y + 4, 8, 8, color);
            currentX += 16;
        }
        if (pendingInvites > 0 && showOldNotifications) {
            guiGraphics.method_52707(class_10799.field_56883, INVITE_SPRITE, currentX, y + 1, 14, 14, color);
            currentX += 16;
        }
        if (hasUnreadNews && showOldNotifications) {
            guiGraphics.method_52707(class_10799.field_56883, NEWS_SPRITE, currentX, y + 1, 14, 14, color);
            currentX += 16;
        }
        if (hasUnseenNotifications) {
            guiGraphics.method_52707(class_10799.field_56883, UNSEEN_NOTIFICATION_SPRITE, currentX, y + 3, 10, 10, color);
        }
    }

    public void renderIcons(class_332 guiGraphics, int color) {
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu().getNow(false);
        if (isValidClient) {
            this.renderIcons(guiGraphics, this.getDefaultPositionX(), this.getDefaultPositionY(), color);
        }
    }

    public boolean shouldShowOldNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu().getNow(false);
        boolean inTitleScreen = this.minecraft.field_1755 instanceof class_442;
        if (!isValidClient || !inTitleScreen) {
            return false;
        }
        return (Boolean)this.minecraft.field_1690.method_42440().method_41753();
    }

    public int getNumberOfPendingInvites() {
        if (RealmsNotificationRenderer.isEditor()) {
            return 1;
        }
        return this.screenAccess.get_numberOfPendingInvites_FancyMenu();
    }

    public boolean hasUnseenNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnseenNotifications();
    }

    public boolean hasUnreadNews() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnreadNews_FancyMenu();
    }

    public boolean isTrialAvailable() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_trialAvailable_FancyMenu();
    }

    protected static boolean isEditor() {
        return class_310.method_1551().field_1755 instanceof LayoutEditorScreen;
    }
}

