/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.theme;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorTheme;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIColorThemeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final TypeAdapter<DrawableColor> DRAWABLE_COLOR_TYPE_ADAPTER = new TypeAdapter<DrawableColor>(){

        public void write(JsonWriter out, DrawableColor value) throws IOException {
            out.beginObject();
            out.name("hex").value(value.getHex());
            out.endObject();
        }

        public DrawableColor read(JsonReader in) throws IOException {
            String hex = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (!name.equals("hex")) continue;
                hex = in.nextString();
                break;
            }
            in.endObject();
            return hex != null ? DrawableColor.of(hex) : DrawableColor.WHITE;
        }
    };

    @Nullable
    public static UIColorTheme deserializeTheme(@NotNull String json) {
        Objects.requireNonNull(json);
        try {
            Gson gson = UIColorThemeSerializer.buildGsonInstance();
            return (UIColorTheme)gson.fromJson(json, UIColorTheme.class);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize FancyMenu theme!", (Throwable)ex);
            return null;
        }
    }

    @Nullable
    public static UIColorTheme deserializeThemeFromResource(@NotNull class_2960 resource) {
        InputStream in = null;
        try {
            StringBuilder json = new StringBuilder();
            in = Objects.requireNonNull(class_310.method_1551().method_1478().open(resource));
            for (String s : FileUtils.readTextLinesFrom(in)) {
                json.append(s);
            }
            CloseableUtils.closeQuietly(in);
            return UIColorThemeSerializer.deserializeTheme(json.toString());
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize FancyMenu theme from Identifier: " + String.valueOf(resource), (Throwable)ex);
            CloseableUtils.closeQuietly(in);
            return null;
        }
    }

    @Nullable
    public static UIColorTheme deserializeThemeFromFile(@NotNull File file) {
        StringBuilder json = new StringBuilder();
        for (String s : FileUtils.getFileLines((File)file)) {
            json.append(s);
        }
        return UIColorThemeSerializer.deserializeTheme(json.toString());
    }

    @Nullable
    public static String serializeTheme(@NotNull UIColorTheme theme) {
        Objects.requireNonNull(theme);
        try {
            Gson gson = UIColorThemeSerializer.buildGsonInstance();
            return gson.toJson((Object)theme);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to serialize FancyMenu theme!", (Throwable)ex);
            return null;
        }
    }

    public static void serializeThemeToFile(@NotNull UIColorTheme theme, @NotNull File file) {
        Objects.requireNonNull(theme);
        Objects.requireNonNull(file);
        try {
            Gson gson = UIColorThemeSerializer.buildGsonInstance();
            String json = gson.toJson((Object)theme);
            if (json != null) {
                FileUtils.writeTextToFile((File)file, (boolean)false, (String[])new String[]{json});
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to serialize FancyMenu theme to file!", (Throwable)ex);
        }
    }

    private static Gson buildGsonInstance() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(DrawableColor.class, DRAWABLE_COLOR_TYPE_ADAPTER);
        return gsonBuilder.create();
    }
}

