/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorLine
extends ExtendedEditBox {
    private static final Logger LOGGER = LogManager.getLogger();
    public TextEditorScreen parent;
    protected String lastTickValue = "";
    public boolean isInMouseHighlightingMode = false;
    protected final class_327 font2;
    public int textWidth = 0;
    public int lineIndex = 0;
    protected int currentHighlightPosXStart = 0;
    protected int currentHighlightPosXEnd = 0;
    protected static boolean leftRightArrowWasDown = false;

    public TextEditorLine(class_327 font, int x, int y, int width, int height, @Nullable CharacterFilter characterFilter, TextEditorScreen parent) {
        super(font, x, y, width, height, (class_2561)class_2561.method_43473());
        this.setCharacterFilter(characterFilter);
        this.parent = parent;
        this.font2 = font;
        this.method_1858(false);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.isInEditorArea()) {
            super.method_25394(graphics, mouseX, mouseY, partial);
        }
        this.lastTickValue = this.method_1882();
    }

    protected class_5250 getFormattedText(String text, int characterStartIndex) {
        class_5250 comp = class_2561.method_43470((String)"");
        int currentIndex = characterStartIndex;
        for (char c : text.toCharArray()) {
            class_2583 style = class_2583.field_24360;
            for (TextEditorFormattingRule r : this.parent.formattingRules) {
                class_2583 rs = r.getStyle(c, currentIndex, this.method_1881(), this, this.parent.currentRenderCharacterIndexTotal + currentIndex, this.parent);
                if (rs == null || rs == class_2583.field_24360) continue;
                style = rs.method_27702(style);
            }
            comp.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_27696(style));
            ++currentIndex;
        }
        return comp;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partial) {
        int textAfterCursorX;
        if (!this.method_1885() || !this.isInEditorArea()) {
            return;
        }
        if (this.lineIndex == 0) {
            this.parent.currentRenderCharacterIndexTotal = 0;
        }
        this.method_1868(this.parent.textColor.getRGB());
        this.method_1860(this.parent.textColor.getRGB());
        if (this.method_25370()) {
            graphics.method_25294(0, this.method_46427(), this.parent.field_22789, this.method_46427() + this.field_22759, this.parent.focusedLineColor.getRGB());
        }
        int textColorInt = this.isEditable() ? this.getAsAccessor().getTextColorFancyMenu() : this.getAsAccessor().getTextColorUneditableFancyMenu();
        int displayPos = this.getAsAccessor().getDisplayPosFancyMenu();
        int cursorPos = this.method_1881() - displayPos;
        int highlightPos = this.getAsAccessor().getHighlightPosFancyMenu() - displayPos;
        String visibleText = this.method_1882().substring(displayPos);
        boolean isCursorInVisibleArea = cursorPos >= 0 && cursorPos <= visibleText.length();
        boolean renderCursor = this.method_25370() && (class_156.method_658() - this.getAsAccessor().getFocusedTimeFancyMenu()) / 300L % 2L == 0L && isCursorInVisibleArea;
        int textX = this.method_46426() + 1;
        int n = this.method_46427();
        int n2 = this.method_25364();
        Objects.requireNonNull(this.font2);
        int textY = n + (n2 - 9) / 2;
        String textBeforeCursorStr = isCursorInVisibleArea ? visibleText.substring(0, cursorPos) : visibleText;
        String textAfterCursorStr = isCursorInVisibleArea ? visibleText.substring(cursorPos) : "";
        class_5250 textBeforeCursorComp = this.getFormattedText(textBeforeCursorStr, displayPos);
        class_5250 textAfterCursorComp = this.getFormattedText(textAfterCursorStr, displayPos + textBeforeCursorStr.length());
        int cursorRenderX = textAfterCursorX = textX + this.font2.method_27525((class_5348)textBeforeCursorComp);
        graphics.method_51439(this.font2, (class_2561)textBeforeCursorComp, textX, textY, textColorInt, false);
        graphics.method_51439(this.font2, (class_2561)textAfterCursorComp, textAfterCursorX, textY, textColorInt, false);
        this.parent.currentRenderCharacterIndexTotal += visibleText.length();
        if (highlightPos != cursorPos) {
            int selectionStart = Math.min(cursorPos, highlightPos);
            int selectionEnd = Math.max(cursorPos, highlightPos);
            String textToHighlightStart = visibleText.substring(0, selectionStart);
            String textToHighlightEnd = visibleText.substring(0, selectionEnd);
            int highlightStartX = textX + this.font2.method_27525((class_5348)this.getFormattedText(textToHighlightStart, displayPos));
            int highlightEndX = textX + this.font2.method_27525((class_5348)this.getFormattedText(textToHighlightEnd, displayPos));
            this.currentHighlightPosXStart = highlightStartX;
            this.currentHighlightPosXEnd = highlightEndX;
            boolean invert = true;
            Objects.requireNonNull(this.font2);
            graphics.method_72238(highlightStartX, textY - 1, highlightEndX, textY + 1 + 9, invert);
        } else {
            this.currentHighlightPosXStart = 0;
            this.currentHighlightPosXEnd = 0;
        }
        if (renderCursor) {
            boolean isCursorAtEnd;
            boolean bl = isCursorAtEnd = this.method_1881() >= this.method_1882().length();
            if (isCursorAtEnd) {
                graphics.method_51433(this.font2, "_", cursorRenderX, textY, textColorInt, false);
            } else {
                Objects.requireNonNull(this.font2);
                graphics.method_25294(cursorRenderX, textY - 1, cursorRenderX + 1, textY + 9, textColorInt);
            }
        }
    }

    public boolean isInEditorArea() {
        return this.method_46427() + this.method_25364() >= this.parent.getEditorAreaY() && this.method_46427() <= this.parent.getEditorAreaY() + this.parent.getEditorAreaHeight();
    }

    public boolean isHighlightedHovered() {
        if (this.isInEditorArea() && this.currentHighlightPosXStart != this.currentHighlightPosXEnd && this.method_49606()) {
            int mouseX = MouseInput.getMouseX();
            return mouseX >= Math.min(this.currentHighlightPosXStart, this.currentHighlightPosXEnd) && mouseX <= Math.max(this.currentHighlightPosXStart, this.currentHighlightPosXEnd);
        }
        return false;
    }

    public int getActualHeight() {
        int h = this.field_22759;
        if (this.getAsAccessor().getBorderedFancyMenu()) {
            h += 2;
        }
        return h;
    }

    public IMixinEditBox getAsAccessor() {
        return (IMixinEditBox)((Object)this);
    }

    public void method_1875(int newPos) {
        this.textWidth = this.font2.method_1727(this.method_1882());
        super.method_1875(newPos);
        if (newPos != this.parent.lastCursorPosSetByUser && this.method_25370()) {
            this.parent.lastCursorPosSetByUser = this.method_1881();
        }
        this.parent.correctXScroll(this);
    }

    public void tick() {
        if (!MouseInput.isLeftMouseDown() && this.isInMouseHighlightingMode) {
            this.isInMouseHighlightingMode = false;
        }
        leftRightArrowWasDown = false;
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.method_74242() || event.method_74243() || event.method_74241() || event.method_74244()) {
            return false;
        }
        if (event.comp_4795() == 259) {
            return false;
        }
        if ((event.comp_4795() == 262 || event.comp_4795() == 263) && this.parent.isInMouseHighlightingMode()) {
            return false;
        }
        if (event.comp_4795() == 263) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.method_1881() <= 0 && this.parent.getLineIndex(this) > 0) {
                    leftRightArrowWasDown = true;
                    this.parent.goUpLine();
                    this.parent.getFocusedLine().method_1883(this.parent.getFocusedLine().method_1882().length(), false);
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        if (event.comp_4795() == 262) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.method_1881() >= this.method_1882().length() && this.parent.getLineIndex(this) < this.parent.getLineCount() - 1) {
                    leftRightArrowWasDown = true;
                    this.parent.goDownLine(false);
                    this.parent.getFocusedLine().method_1883(0, false);
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        return super.method_25404(event);
    }

    @Override
    public void method_1878(int i) {
        if (!this.parent.justSwitchedLineByWordDeletion) {
            if (this.method_1881() == 0 && this.parent.getFocusedLineIndex() > 0) {
                int lastLineIndex = this.parent.getFocusedLineIndex();
                this.parent.justSwitchedLineByWordDeletion = true;
                this.parent.goUpLine();
                this.parent.getFocusedLine().method_1872(false);
                this.parent.getFocusedLine().method_1867(this.method_1882());
                this.parent.getFocusedLine().method_1875(this.parent.getFocusedLine().method_1881() - this.method_1882().length());
                this.parent.getFocusedLine().method_1884(this.parent.getFocusedLine().method_1881());
                if (lastLineIndex > 0) {
                    this.parent.removeLineAtIndex(this.parent.getFocusedLineIndex() + 1);
                    this.parent.correctYScroll(-1);
                }
            } else {
                super.method_1878(i);
            }
        }
        this.textWidth = this.font2.method_1727(this.method_1882());
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (!this.parent.isMouseInsideEditorArea() || this.parent.rightClickContextMenu.isOpen()) {
            return false;
        }
        if (event.method_74245() == 0 && this.method_49606() && !this.isInMouseHighlightingMode && this.method_1885()) {
            if (!this.parent.isAtLeastOneLineInHighlightMode()) {
                this.parent.startHighlightLine = this;
            }
            this.isInMouseHighlightingMode = true;
            this.parent.setFocusedLine(Math.max(0, this.parent.getLineIndex(this)));
            super.method_25402(event, isDoubleClick);
            this.method_1884(this.method_1881());
        } else if (event.method_74245() == 0 && !this.method_49606()) {
            this.method_1884(this.method_1881());
        }
        if (!this.isInMouseHighlightingMode && event.method_74245() == 0) {
            return super.method_25402(event, isDoubleClick);
        }
        return true;
    }

    @Override
    public void method_1852(String p_94145_) {
        super.method_1852(p_94145_);
        this.textWidth = this.font2.method_1727(this.method_1882());
    }

    @Override
    public void method_1867(String textToWrite) {
        super.method_1867(textToWrite);
        this.textWidth = this.font2.method_1727(this.method_1882());
    }

    public void method_1880(int p_94200_) {
        super.method_1880(p_94200_);
        this.textWidth = this.font2.method_1727(this.method_1882());
    }
}

