/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderRegistry;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBridge {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String JAVASCRIPT_NAMESPACE = "fancymenu";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final String REQUEST_TYPE_ACTION = "fancymenu_action";
    private static final String REQUEST_TYPE_PLACEHOLDER = "fancymenu_placeholder";
    private static final String PLACEHOLDER_ERROR_NOT_FOUND = "NOT_FOUND";
    private static final String PLACEHOLDER_ERROR_MISSING_VARIABLE = "MISSING_VARIABLE";
    private static final String PLACEHOLDER_ERROR_INVALID_VARIABLE = "INVALID_VARIABLE";
    private static final String PLACEHOLDER_ERROR_EVALUATION = "EVALUATION_ERROR";
    private static final long PLACEHOLDER_MAIN_THREAD_TIMEOUT_MS = 3000L;
    private static CefMessageRouter messageRouter;
    private static boolean initialized;
    public static final String JAVASCRIPT_API;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!MCEFUtil.isMCEFLoaded()) {
            LOGGER.warn("[FANCYMENU] Cannot initialize ActionBridge - MCEF is not loaded");
            return;
        }
        try {
            LOGGER.info("[FANCYMENU] Initializing ActionBridge message router");
            if (MCEF.getClient() == null) {
                LOGGER.warn("[FANCYMENU] MCEF client is not initialized yet, delaying ActionBridge initialization");
                return;
            }
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
            config.jsQueryFunction = "cefQuery";
            config.jsCancelFunction = "cefQueryCancel";
            messageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
            messageRouter.addHandler((CefMessageRouterHandler)ActionBridge.createMessageHandler(), true);
            MCEF.getClient().getHandle().addMessageRouter(messageRouter);
            initialized = true;
            LOGGER.info("[FANCYMENU] ActionBridge message router initialized successfully");
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to initialize ActionBridge message router", (Throwable)ex);
        }
    }

    public static void dispose() {
        if (messageRouter != null && initialized) {
            try {
                MCEF.getClient().getHandle().removeMessageRouter(messageRouter);
                messageRouter.dispose();
                messageRouter = null;
                initialized = false;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to dispose ActionBridge message router", (Throwable)ex);
            }
        }
    }

    public static CefMessageRouterHandlerAdapter createMessageHandler() {
        return new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
                JsonObject payload;
                LOGGER.info("[FANCYMENU] Received query from browser: {}", (Object)request);
                if (request == null || request.isEmpty()) {
                    callback.failure(400, "Empty request");
                    return true;
                }
                try {
                    JsonElement parsed = JsonParser.parseString((String)request);
                    if (!parsed.isJsonObject()) {
                        callback.failure(400, "Invalid request payload");
                        return true;
                    }
                    payload = parsed.getAsJsonObject();
                }
                catch (JsonParseException ex) {
                    LOGGER.warn("[FANCYMENU] Failed to parse browser request JSON", (Throwable)ex);
                    callback.failure(400, "Invalid JSON payload");
                    return true;
                }
                String type = ActionBridge.getStringOrNull(payload, "type");
                if (type == null || type.isEmpty()) {
                    callback.failure(400, "Missing request type");
                    return true;
                }
                try {
                    return switch (type) {
                        case ActionBridge.REQUEST_TYPE_ACTION -> ActionBridge.handleActionRequest(payload, callback);
                        case ActionBridge.REQUEST_TYPE_PLACEHOLDER -> ActionBridge.handlePlaceholderRequest(payload, callback);
                        default -> {
                            LOGGER.debug("[FANCYMENU] Query type '{}' not handled by FancyMenu bridge", (Object)type);
                            yield false;
                        }
                    };
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error processing browser request", (Throwable)ex);
                    callback.failure(500, "Internal error: " + ex.getMessage());
                    return true;
                }
            }
        };
    }

    private static boolean handleActionRequest(@NotNull JsonObject payload, @NotNull CefQueryCallback callback) {
        String actionString = ActionBridge.getStringOrNull(payload, "action");
        if (actionString == null || actionString.isEmpty()) {
            callback.failure(400, "Invalid action format");
            return true;
        }
        LOGGER.info("[FANCYMENU] Processing action: {}", (Object)actionString);
        boolean success = ActionBridge.processAction(actionString);
        if (success) {
            JsonObject response = new JsonObject();
            response.addProperty("success", Boolean.valueOf(true));
            response.addProperty("message", "Action executed successfully");
            callback.success(GSON.toJson((JsonElement)response));
        } else {
            callback.failure(500, "Failed to execute action");
        }
        return true;
    }

    private static boolean handlePlaceholderRequest(@NotNull JsonObject payload, @NotNull CefQueryCallback callback) {
        List<String> requiredNames;
        String identifier = ActionBridge.getStringOrNull(payload, "identifier");
        if (identifier == null) {
            ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Placeholder identifier is required");
            return true;
        }
        if ((identifier = identifier.trim()).isEmpty()) {
            ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Placeholder identifier is required");
            return true;
        }
        Placeholder placeholder = PlaceholderRegistry.getPlaceholder(identifier);
        if (placeholder == null && !identifier.equals(identifier.toLowerCase(Locale.ROOT))) {
            placeholder = PlaceholderRegistry.getPlaceholder(identifier.toLowerCase(Locale.ROOT));
        }
        if (placeholder == null) {
            ActionBridge.sendPlaceholderFailure(callback, 404, PLACEHOLDER_ERROR_NOT_FOUND, "Unknown placeholder: " + identifier);
            return true;
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        JsonElement varsElement = payload.get("vars");
        if (varsElement != null && !varsElement.isJsonNull()) {
            if (!varsElement.isJsonArray()) {
                ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Placeholder variables must be provided as an array");
                return true;
            }
            JsonArray varsArray = varsElement.getAsJsonArray();
            for (JsonElement element : varsArray) {
                if (!element.isJsonPrimitive()) {
                    ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Placeholder variables must be strings");
                    return true;
                }
                String raw = element.getAsString();
                int colonIndex = raw.indexOf(58);
                if (colonIndex <= 0) {
                    ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Invalid placeholder variable format: " + raw);
                    return true;
                }
                String name = raw.substring(0, colonIndex).trim();
                String value = raw.substring(colonIndex + 1).trim();
                if (name.isEmpty()) {
                    ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_INVALID_VARIABLE, "Placeholder variable name is empty");
                    return true;
                }
                values.put(name, value);
            }
        }
        if ((requiredNames = placeholder.getValueNames()) != null && !requiredNames.isEmpty()) {
            for (String required : requiredNames) {
                if (values.containsKey(required)) continue;
                ActionBridge.sendPlaceholderFailure(callback, 400, PLACEHOLDER_ERROR_MISSING_VARIABLE, "Missing placeholder variable: " + required);
                return true;
            }
        }
        LinkedHashMap<String, String> valuesCopy = new LinkedHashMap<String, String>(values);
        DeserializedPlaceholderString deserialized = new DeserializedPlaceholderString(placeholder.getIdentifier(), valuesCopy, "");
        deserialized.placeholderString = deserialized.toString();
        try {
            String replacement = ActionBridge.evaluatePlaceholderValue(placeholder, deserialized);
            if (replacement == null) {
                replacement = "";
            }
            ActionBridge.sendPlaceholderSuccess(callback, placeholder.getIdentifier(), replacement);
        }
        catch (TimeoutException ex) {
            LOGGER.error("[FANCYMENU] Placeholder '{}' evaluation timed out", (Object)placeholder.getIdentifier(), (Object)ex);
            ActionBridge.sendPlaceholderFailure(callback, 504, PLACEHOLDER_ERROR_EVALUATION, "Placeholder evaluation timed out", ex.getMessage());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOGGER.error("[FANCYMENU] Placeholder '{}' evaluation interrupted", (Object)placeholder.getIdentifier(), (Object)ex);
            ActionBridge.sendPlaceholderFailure(callback, 500, PLACEHOLDER_ERROR_EVALUATION, "Placeholder evaluation interrupted", ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to evaluate placeholder '{}'", (Object)placeholder.getIdentifier(), (Object)ex);
            ActionBridge.sendPlaceholderFailure(callback, 500, PLACEHOLDER_ERROR_EVALUATION, "Placeholder evaluation failed", ex.getMessage());
        }
        return true;
    }

    @Nullable
    private static String getStringOrNull(@NotNull JsonObject payload, @NotNull String key) {
        JsonElement element = payload.get(key);
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (!element.isJsonPrimitive()) {
            return null;
        }
        return element.getAsString();
    }

    private static void sendPlaceholderSuccess(@NotNull CefQueryCallback callback, @NotNull String identifier, @NotNull String value) {
        JsonObject result = new JsonObject();
        result.addProperty("success", Boolean.valueOf(true));
        result.addProperty("identifier", identifier);
        result.addProperty("value", value);
        callback.success(GSON.toJson((JsonElement)result));
    }

    private static void sendPlaceholderFailure(@NotNull CefQueryCallback callback, int statusCode, @NotNull String code, @NotNull String message) {
        ActionBridge.sendPlaceholderFailure(callback, statusCode, code, message, null);
    }

    private static void sendPlaceholderFailure(@NotNull CefQueryCallback callback, int statusCode, @NotNull String code, @NotNull String message, @Nullable String details) {
        JsonObject error = new JsonObject();
        error.addProperty("code", code);
        error.addProperty("message", message);
        if (details != null && !details.isEmpty()) {
            error.addProperty("details", details);
        }
        callback.failure(statusCode, GSON.toJson((JsonElement)error));
    }

    @NotNull
    private static String evaluatePlaceholderValue(@NotNull Placeholder placeholder, @NotNull DeserializedPlaceholderString deserialized) throws Exception {
        boolean sameThread = class_310.method_1551().method_18854();
        if (placeholder.canRunAsync() || sameThread) {
            if (!placeholder.checkAsync()) {
                throw new IllegalStateException("Placeholder cannot be evaluated in the current thread");
            }
            return placeholder.getReplacementFor(deserialized);
        }
        CompletableFuture future = new CompletableFuture();
        MainThreadTaskExecutor.executeInMainThread(() -> {
            try {
                if (!placeholder.checkAsync()) {
                    future.completeExceptionally(new IllegalStateException("Placeholder cannot be evaluated in the current thread"));
                    return;
                }
                future.complete(placeholder.getReplacementFor(deserialized));
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        try {
            return (String)future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                Exception exception = (Exception)cause;
                throw exception;
            }
            throw ex;
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw ex;
        }
    }

    private static boolean processAction(@NotNull String actionString) {
        try {
            ActionInstance action = ActionBridge.parseBrowserAction(actionString);
            if (action != null) {
                ActionBridge.executeAction(action);
                return true;
            }
            LOGGER.warn("[FANCYMENU] Failed to parse browser action: {}", (Object)actionString);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error processing browser action: " + actionString, (Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static ActionInstance parseBrowserAction(@NotNull String actionString) {
        try {
            String actionType;
            String value = null;
            if (actionString.contains(":")) {
                String[] array = actionString.split(":", 2);
                actionType = array[0];
                value = array[1];
            } else {
                actionType = actionString;
            }
            String parsableKey = "[executable_action_instance:" + ScreenCustomization.generateUniqueIdentifier() + "][action_type:" + actionType + "]";
            PropertyContainer container = new PropertyContainer("dummy_action_holder");
            container.putProperty(parsableKey, value == null ? "" : value);
            List<ActionInstance> deserialized = ActionInstance.deserializeAll(container);
            if (!deserialized.isEmpty()) {
                return deserialized.get(0);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to parse browser action: " + actionString, (Throwable)ex);
        }
        return null;
    }

    public static void executeAction(@NotNull ActionInstance action) {
        try {
            action.execute();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute browser action!", (Throwable)ex);
        }
    }

    static {
        initialized = false;
        JAVASCRIPT_API = "(function() {\n    console.log('[FancyMenu] Initializing JavaScript API...');\n    console.log('[FancyMenu] typeof window.cefQuery:', typeof window.cefQuery);\n\n    // Wait for cefQuery to be available\n    var attempts = 0;\n    function waitForCefQuery(callback) {\n        attempts++;\n        if (typeof window.cefQuery !== 'undefined') {\n            console.log('[FancyMenu] cefQuery found after ' + attempts + ' attempts');\n            callback();\n        } else if (attempts > 100) {\n            console.error('[FancyMenu] cefQuery not found after 100 attempts. Message router may not be properly configured.');\n        } else {\n            setTimeout(function() {\n                waitForCefQuery(callback);\n            }, 50);\n        }\n    }\n\n    waitForCefQuery(function() {\n        function executeWithCallbackInternal(actionType, actionValue, onSuccess, onFailure) {\n            // Handle overloaded calls\n            if (typeof actionValue === 'function') {\n                // executeWithCallback(actionType, onSuccess, onFailure)\n                onFailure = onSuccess;\n                onSuccess = actionValue;\n                actionValue = null;\n            }\n\n            if (!actionType || typeof actionType !== 'string') {\n                if (onFailure) onFailure('Invalid action type');\n                return;\n            }\n\n            // Construct action string\n            var actionString = actionType;\n            if (actionValue !== null && actionValue !== undefined && actionValue !== '') {\n                actionString += ':' + actionValue;\n            }\n\n            console.log('[FancyMenu] Executing action:', actionString);\n\n            window.cefQuery({\n                request: JSON.stringify({\n                    type: '%action_type%',\n                    action: actionString\n                }),\n                onSuccess: function(response) {\n                    console.log('[FancyMenu] Action response:', response);\n                    if (onSuccess) {\n                        try {\n                            var result = JSON.parse(response);\n                            onSuccess(result);\n                        } catch (e) {\n                            onSuccess(response);\n                        }\n                    }\n                },\n                onFailure: function(error_code, error_message) {\n                    console.error('[FancyMenu] Action failed:', error_code, error_message);\n                    if (onFailure) onFailure(error_message);\n                }\n            });\n        }\n\n        function executeInternal(actionType, actionValue) {\n            if (arguments.length === 1) {\n                // Single argument - action without value\n                executeWithCallbackInternal(actionType);\n            } else {\n                // Two arguments - action with value\n                executeWithCallbackInternal(actionType, actionValue);\n            }\n        }\n\n        var actionsNamespace = {\n            executeWithCallback: executeWithCallbackInternal,\n            execute: executeInternal\n        };\n\n        window.%namespace% = {\n            actions: actionsNamespace,\n            executeWithCallback: function(actionType, actionValue, onSuccess, onFailure) {\n                return executeWithCallbackInternal.apply(null, arguments);\n            },\n\n            // Convenience method for executing actions without callbacks\n            execute: function(actionType, actionValue) {\n                return executeInternal.apply(null, arguments);\n            },\n\n            placeholders: {\n                get: function(identifier) {\n                    return this.getWithVars(identifier);\n                },\n\n                getWithVars: function(identifier) {\n                    var rawVars = Array.prototype.slice.call(arguments, 1);\n                    return new Promise(function(resolve, reject) {\n                        if (!identifier || typeof identifier !== 'string') {\n                            reject({ code: 'INVALID_VARIABLE', message: 'Placeholder identifier must be a non-empty string.' });\n                            return;\n                        }\n\n                        var normalizedVars = [];\n                        for (var i = 0; i < rawVars.length; i++) {\n                            var entry = rawVars[i];\n                            if (typeof entry !== 'string') {\n                                reject({ code: 'INVALID_VARIABLE', message: 'Placeholder variables must be strings.' });\n                                return;\n                            }\n                            var colonIndex = entry.indexOf(':');\n                            if (colonIndex <= 0) {\n                                reject({ code: 'INVALID_VARIABLE', message: 'Placeholder variable \"' + entry + '\" must contain a colon separator.' });\n                                return;\n                            }\n                            normalizedVars.push(entry);\n                        }\n\n                        window.cefQuery({\n                            request: JSON.stringify({\n                                type: '%placeholder_type%',\n                                identifier: identifier,\n                                vars: normalizedVars\n                            }),\n                            onSuccess: function(response) {\n                                try {\n                                    var payload = JSON.parse(response);\n                                    if (payload && typeof payload.value !== 'undefined') {\n                                        resolve(payload.value);\n                                        return;\n                                    }\n                                } catch (e) {\n                                    // Fallback below\n                                }\n                                resolve(response);\n                            },\n                            onFailure: function(error_code, error_message) {\n                                var errorPayload = {\n                                    code: 'INTERNAL_ERROR',\n                                    message: error_message || 'Unknown error',\n                                    details: { status: error_code }\n                                };\n\n                                if (error_message) {\n                                    try {\n                                        var parsedError = JSON.parse(error_message);\n                                        if (parsedError && parsedError.code) {\n                                            errorPayload = parsedError;\n                                            if (parsedError.details && typeof parsedError.details === 'object') {\n                                                parsedError.details.status = error_code;\n                                            } else {\n                                                errorPayload.details = { status: error_code };\n                                            }\n                                        }\n                                    } catch (e) {\n                                        errorPayload.message = error_message;\n                                    }\n                                }\n\n                                console.error('[FancyMenu] Placeholder request failed:', errorPayload);\n                                reject(errorPayload);\n                            }\n                        });\n                    });\n                }\n            }\n        };\n\n        // Also create a global alias for easier access\n        window.FancyMenu = window.%namespace%;\n\n        console.log('[FancyMenu] API initialized successfully');\n\n        // Dispatch event to notify that the API is ready\n        window.dispatchEvent(new Event('fancymenu-ready'));\n    });\n})();\n".replace("%namespace%", JAVASCRIPT_NAMESPACE).replace("%placeholder_type%", REQUEST_TYPE_PLACEHOLDER).replace("%action_type%", REQUEST_TYPE_ACTION);
    }
}

