/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.server;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.structures.StructureEventPacket;
import de.keksuccino.fancymenu.util.level.StructureUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class MixinServerPlayer {
    @Unique
    private static final int STRUCTURE_LEAVE_GRACE_TICKS_FANCYMENU = 40;
    @Unique
    private final Map<String, Integer> structureMissingTickCounter_FancyMenu = new HashMap<String, Integer>();
    @Unique
    private boolean structureHighPrecisionInitialized_FancyMenu;
    @Unique
    private String lastHighPrecisionStructureKey_FancyMenu;
    @Unique
    private static final int STRUCTURE_HIGH_PRECISION_LEAVE_GRACE_TICKS_FANCYMENU = 20;
    @Unique
    private int highPrecisionMissingTickCounter_FancyMenu;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void after_tick_FancyMenu(CallbackInfo info) {
        this.updateStructureListeners_FancyMenu((class_3222)this);
    }

    @Unique
    private void updateStructureListeners_FancyMenu(@NotNull class_3222 self) {
        if (!PacketHandler.isFancyMenuClient(self)) {
            this.structureMissingTickCounter_FancyMenu.clear();
            this.structureHighPrecisionInitialized_FancyMenu = false;
            this.lastHighPrecisionStructureKey_FancyMenu = null;
            this.highPrecisionMissingTickCounter_FancyMenu = 0;
            return;
        }
        Set<String> currentStructureKeys = this.detectStructureKeys_FancyMenu(self);
        for (String currentKey : currentStructureKeys) {
            if (!this.structureMissingTickCounter_FancyMenu.containsKey(currentKey)) {
                this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.ENTER, currentKey);
            }
            this.structureMissingTickCounter_FancyMenu.put(currentKey, 0);
        }
        HashSet<String> trackedKeys = new HashSet<String>(this.structureMissingTickCounter_FancyMenu.keySet());
        for (String trackedKey : trackedKeys) {
            if (currentStructureKeys.contains(trackedKey)) continue;
            int newCounter = this.structureMissingTickCounter_FancyMenu.getOrDefault(trackedKey, 0) + 1;
            if (newCounter > 40) {
                this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.LEAVE, trackedKey);
                this.structureMissingTickCounter_FancyMenu.remove(trackedKey);
                continue;
            }
            this.structureMissingTickCounter_FancyMenu.put(trackedKey, newCounter);
        }
        this.updateHighPrecisionStructureListeners_FancyMenu(self);
    }

    @Unique
    private Set<String> detectStructureKeys_FancyMenu(@NotNull class_3222 self) {
        class_3218 class_32182 = self.method_51469();
        if (!(class_32182 instanceof class_3218)) {
            return Set.of();
        }
        class_3218 level = class_32182;
        class_2338 blockPos = self.method_24515();
        if (!level.method_8477(blockPos)) {
            return Set.of();
        }
        return new HashSet<String>(StructureUtils.convertStructureKeysToStrings(StructureUtils.getAllStructuresAt(level, blockPos)));
    }

    @Unique
    private void updateHighPrecisionStructureListeners_FancyMenu(@NotNull class_3222 self) {
        String currentStructureKey = this.detectHighPrecisionStructureKey_FancyMenu(self);
        if (!this.structureHighPrecisionInitialized_FancyMenu) {
            this.structureHighPrecisionInitialized_FancyMenu = true;
            this.lastHighPrecisionStructureKey_FancyMenu = currentStructureKey;
            this.highPrecisionMissingTickCounter_FancyMenu = 0;
            if (currentStructureKey != null) {
                this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.ENTER_HIGH_PRECISION, currentStructureKey);
            }
            return;
        }
        if (Objects.equals(this.lastHighPrecisionStructureKey_FancyMenu, currentStructureKey)) {
            if (currentStructureKey != null) {
                this.highPrecisionMissingTickCounter_FancyMenu = 0;
            }
            return;
        }
        if (currentStructureKey != null) {
            if (this.lastHighPrecisionStructureKey_FancyMenu != null) {
                this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.LEAVE_HIGH_PRECISION, this.lastHighPrecisionStructureKey_FancyMenu);
            }
            this.lastHighPrecisionStructureKey_FancyMenu = currentStructureKey;
            this.highPrecisionMissingTickCounter_FancyMenu = 0;
            this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.ENTER_HIGH_PRECISION, currentStructureKey);
            return;
        }
        if (this.lastHighPrecisionStructureKey_FancyMenu != null) {
            ++this.highPrecisionMissingTickCounter_FancyMenu;
            if (this.highPrecisionMissingTickCounter_FancyMenu > 20) {
                this.sendStructureEvent_FancyMenu(self, StructureEventPacket.StructureEventType.LEAVE_HIGH_PRECISION, this.lastHighPrecisionStructureKey_FancyMenu);
                this.lastHighPrecisionStructureKey_FancyMenu = null;
                this.highPrecisionMissingTickCounter_FancyMenu = 0;
            }
        }
    }

    @Unique
    private String detectHighPrecisionStructureKey_FancyMenu(@NotNull class_3222 self) {
        class_3218 class_32182 = self.method_51469();
        if (!(class_32182 instanceof class_3218)) {
            return null;
        }
        class_3218 level = class_32182;
        class_2338 blockPos = self.method_24515();
        if (!level.method_8477(blockPos)) {
            return null;
        }
        class_5138 structureManager = level.method_27056();
        class_3449 structureStart = structureManager.method_41413(blockPos, holder -> true);
        if (structureStart == class_3449.field_16713) {
            return null;
        }
        class_3195 structure = structureStart.method_16656();
        if (structure == null) {
            return null;
        }
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        class_2960 location = registry.method_10221((Object)structure);
        return location != null ? location.toString() : null;
    }

    @Unique
    private void sendStructureEvent_FancyMenu(@NotNull class_3222 self, @NotNull StructureEventPacket.StructureEventType type, @NotNull String structureKey) {
        StructureEventPacket packet = new StructureEventPacket();
        packet.event_type = type;
        packet.structure_identifier = structureKey;
        PacketHandler.sendToClient(self, packet);
    }
}

