/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.slideshow;

import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ExternalTextureSlideshowRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    public List<ResourceSupplier<ITexture>> images = new ArrayList<ResourceSupplier<ITexture>>();
    @Nullable
    public ResourceSupplier<ITexture> overlayTexture;
    protected String name = null;
    public String dir;
    protected boolean prepared = false;
    protected double imageDuration = 10.0;
    protected float fadeSpeed = 1.0f;
    protected int originalWidth = 10;
    protected int originalHeight = 10;
    protected boolean randomize = false;
    public int width = 50;
    public int height = 50;
    public int x = 0;
    public int y = 0;
    protected float opacity = 1.0f;
    protected int frameCounter = -1;
    protected long opacityTick = -1L;
    protected long lastChange = -1L;
    protected boolean firstLoop = true;
    public float slideshowOpacity = 1.0f;
    protected ResourceSupplier<ITexture> previous;
    protected ResourceSupplier<ITexture> current;

    public ExternalTextureSlideshowRenderer(String slideshowDir) {
        List<PropertyContainer> l;
        PropertyContainerSet s;
        this.dir = slideshowDir;
        File props = new File(this.dir + "/properties.txt");
        if (!props.isFile()) {
            props = new File(this.dir + "/properties.txt.txt");
        }
        if (props.exists() && (s = PropertiesParser.deserializeSetFromFile(props.getPath())) != null && !(l = s.getContainersOfType("slideshow-meta")).isEmpty()) {
            String sh;
            String sw;
            String sy;
            String sx;
            String fs;
            this.name = l.get(0).getValue("name");
            String dur = l.get(0).getValue("duration");
            if (dur != null && MathUtils.isDouble((String)dur)) {
                this.imageDuration = Double.parseDouble(dur);
            }
            if ((fs = l.get(0).getValue("fadespeed")) != null && MathUtils.isFloat((String)fs)) {
                float f = Float.parseFloat(fs);
                if (f < 0.0f) {
                    f = 0.0f;
                }
                this.fadeSpeed = f;
            }
            if ((sx = l.get(0).getValue("x")) != null && MathUtils.isInteger((String)sx)) {
                this.x = Integer.parseInt(sx);
            }
            if ((sy = l.get(0).getValue("y")) != null && MathUtils.isInteger((String)sy)) {
                this.y = Integer.parseInt(sy);
            }
            if ((sw = l.get(0).getValue("width")) != null && MathUtils.isInteger((String)sw)) {
                this.width = Integer.parseInt(sw);
            }
            if ((sh = l.get(0).getValue("height")) != null && MathUtils.isInteger((String)sh)) {
                this.height = Integer.parseInt(sh);
            }
            this.randomize = SerializationUtils.deserializeBoolean(this.randomize, l.get(0).getValue("randomize"));
        }
    }

    public void prepareSlideshow() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(this.dir + "/images"))).exists() && imagesDir.isDirectory()) {
            ArrayList images;
            String[] list = imagesDir.list();
            ArrayList arrayList = images = list != null ? Arrays.asList(list) : new ArrayList();
            if (!images.isEmpty()) {
                File overlay;
                ITexture t;
                images.sort(String.CASE_INSENSITIVE_ORDER);
                for (String s : images) {
                    File f = new File(imagesDir.getPath() + "/" + s);
                    if (!f.exists() || !f.isFile() || !f.getPath().toLowerCase().endsWith(".jpg") && !f.getPath().toLowerCase().endsWith(".png")) continue;
                    this.images.add(ResourceSupplier.image(f.getPath()));
                }
                if (!this.images.isEmpty() && (t = this.images.get(0).get()) != null) {
                    t.waitForReady(5000L);
                    this.originalWidth = t.getWidth();
                    this.originalHeight = t.getHeight();
                }
                if ((overlay = new File(this.dir + "/overlay.png")).exists()) {
                    this.overlayTexture = ResourceSupplier.image(overlay.getPath());
                }
            }
            this.prepared = true;
        }
    }

    public void render(class_332 graphics) {
        try {
            if (!this.images.isEmpty()) {
                this.tick();
                this.renderCurrent(graphics);
                this.renderPrevious(graphics);
                this.renderOverlay(graphics);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render slideshow!", (Throwable)ex);
        }
    }

    protected void tick() {
        if (!this.images.isEmpty()) {
            long time = System.currentTimeMillis();
            long duration = (long)(1000.0 * this.imageDuration);
            long opacityTickSpeed = 25L;
            if (this.firstLoop) {
                duration /= 2L;
            }
            if (this.previous == null && this.lastChange + duration < time) {
                if (!this.randomize) {
                    ++this.frameCounter;
                } else if (this.images.size() > 1) {
                    int i = this.frameCounter;
                    while (i == this.frameCounter) {
                        this.frameCounter = de.keksuccino.fancymenu.util.MathUtils.getRandomNumberInRange((int)0, (int)(this.images.size() - 1));
                    }
                } else {
                    this.frameCounter = 0;
                }
                if (this.frameCounter > this.images.size() - 1) {
                    this.frameCounter = 0;
                }
                this.lastChange = time;
                this.opacity = 1.0f;
                this.previous = this.current;
                this.current = this.images.get(this.frameCounter);
            }
            if (this.previous != null && this.opacity > 0.0f) {
                this.firstLoop = false;
                if (this.opacityTick + opacityTickSpeed < time) {
                    this.opacityTick = time;
                    this.opacity -= 0.005f * this.fadeSpeed;
                    if (this.opacity < 0.0f) {
                        this.opacity = 0.0f;
                    }
                }
            } else {
                this.previous = null;
            }
        }
    }

    protected void renderPrevious(class_332 graphics) {
        if (this.previous != null && this.current != this.previous) {
            ITexture t;
            class_2960 loc;
            float o = this.opacity;
            if (o > this.slideshowOpacity) {
                o = this.slideshowOpacity;
            }
            class_2960 class_29602 = loc = (t = this.previous.get()) != null ? t.getIdentifier() : null;
            if (loc != null) {
                graphics.method_25291(class_10799.field_56883, loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height, DrawableColor.WHITE.getColorIntWithAlpha(o));
            }
        }
    }

    protected void renderCurrent(class_332 graphics) {
        if (this.current != null) {
            class_2960 loc;
            ITexture t = this.current.get();
            class_2960 class_29602 = loc = t != null ? t.getIdentifier() : null;
            if (loc != null) {
                graphics.method_25291(class_10799.field_56883, loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height, DrawableColor.WHITE.getColorIntWithAlpha(this.slideshowOpacity));
            }
        }
    }

    protected void renderOverlay(class_332 graphics) {
        if (this.overlayTexture != null) {
            class_2960 loc;
            ITexture t = this.overlayTexture.get();
            class_2960 class_29602 = loc = t != null ? t.getIdentifier() : null;
            if (loc != null) {
                graphics.method_25291(class_10799.field_56883, loc, this.x, this.y, 0.0f, 0.0f, this.width, this.height, this.width, this.height, -1);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDuration(double duration) {
        this.imageDuration = duration;
    }

    public void setFadeSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.fadeSpeed = speed;
    }

    public boolean isReady() {
        return this.prepared;
    }

    public int getImageWidth() {
        return this.originalWidth;
    }

    public int getImageHeight() {
        return this.originalHeight;
    }

    public int getImageCount() {
        return this.images.size();
    }
}

