/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_12096;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class HasPlayerPermissionLevelRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public HasPlayerPermissionLevelRequirement() {
        super("fancymenu_loading_requirement_has_player_permission_level");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        int requiredLevel;
        if (value == null) {
            return false;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return false;
        }
        try {
            requiredLevel = Integer.parseInt(trimmed);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("[FANCYMENU] Invalid permission level '{}' provided to '{}' requirement!", (Object)trimmed, (Object)this.getIdentifier());
            return false;
        }
        class_12094 permissionLevel = class_12094.method_75027((int)requiredLevel);
        if (permissionLevel == class_12094.field_63196) {
            return true;
        }
        try {
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if (level != null && player != null) {
                class_12096 permissionSet = player.method_75004();
                return permissionSet.hasPermission((class_12087)new class_12087.class_12089(permissionLevel));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.world.has_player_permission_level", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.has_player_permission_level.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.world.has_player_permission_level.value_name", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return String.valueOf(class_12094.field_63198.method_75026());
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

