/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnMouseButtonReleasedListener
extends AbstractListener {
    @Nullable
    private Integer lastButton;
    @Nullable
    private Double lastMouseX;
    @Nullable
    private Double lastMouseY;

    public OnMouseButtonReleasedListener() {
        super("mouse_button_released");
    }

    public void onMouseButtonReleased(int button, double mouseX, double mouseY) {
        this.lastButton = button;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("button", () -> this.formatButton(this.lastButton)));
        list.add(new AbstractListener.CustomVariable("mouse_pos_x", () -> this.formatCoordinate(this.lastMouseX)));
        list.add(new AbstractListener.CustomVariable("mouse_pos_y", () -> this.formatCoordinate(this.lastMouseY)));
    }

    private String formatButton(@Nullable Integer button) {
        if (button == null) {
            return "ERROR";
        }
        return switch (button) {
            case 0 -> "left";
            case 1 -> "right";
            case 2 -> "middle";
            default -> Integer.toString(button);
        };
    }

    private String formatCoordinate(@Nullable Double value) {
        if (value == null) {
            return "ERROR";
        }
        return Double.toString(value);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_mouse_button_released");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_mouse_button_released.desc", new String[0]));
    }
}

