/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.gui;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.gui.BuddyGuiButton;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.FoodItem;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.PlayBall;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling.BuddyAchievement;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling.LevelingManager;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuddyStatusScreen
implements class_4068 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int SCREEN_WIDTH = 320;
    private static final int SCREEN_HEIGHT = 240;
    private static final int SCREEN_BORDER_WIDTH = 390;
    private static final int SCREEN_BORDER_HEIGHT = 293;
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/gui/status_screen_background.png");
    private static final class_2960 BACKGROUND_BORDER_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/gui/status_screen_background_border.png");
    private static final class_2960 TAB_BUTTON_TEXTURE_NORMAL = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/gui/tab_button_normal.png");
    private static final class_2960 TAB_BUTTON_TEXTURE_SELECTED = class_2960.method_60655((String)"fancymenu", (String)"textures/buddy/gui/tab_button_selected.png");
    private static final int TAB_STATS = 0;
    private static final int TAB_ACHIEVEMENTS = 1;
    private final Buddy buddy;
    private final LevelingManager levelingManager;
    private final class_327 font;
    private boolean isVisible = false;
    private int guiX;
    private int guiY;
    private int currentTab = 0;
    private final List<BuddyGuiButton> buttons = new ArrayList<BuddyGuiButton>();
    private final List<BuddyGuiButton> actionButtons = new ArrayList<BuddyGuiButton>();
    private int achievementsScrollOffset = 0;
    public long sleepButtonCooldownEnd = 0L;
    private boolean isMouseClicked = false;

    public BuddyStatusScreen(@NotNull Buddy buddy, @NotNull LevelingManager levelingManager) {
        this.buddy = buddy;
        this.levelingManager = levelingManager;
        this.font = class_310.method_1551().field_1772;
        this.initButtons();
    }

    private void initButtons() {
        this.buttons.clear();
        this.buttons.add(new BuddyGuiButton(this.buddy, 0, 0, 20, 20, buddy -> "", this::hide, () -> true).setCloseButtonTextures());
        this.actionButtons.clear();
        this.actionButtons.add(new BuddyGuiButton(this.buddy, buddy -> "Feed", () -> {
            if (!this.buddy.hasBeenAwakened) {
                return;
            }
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            LOGGER.debug("Creating food at screen coordinates: ({}, {})", (Object)mouseX, (Object)mouseY);
            FoodItem food = new FoodItem(mouseX, mouseY, this.buddy);
            this.buddy.setDroppedFood(food);
            food.stickToCursor = true;
            this.hide();
        }, () -> this.buddy.getDroppedFood() == null && !this.buddy.isSleeping && !this.buddy.isPlaying && !this.buddy.isEating && !this.buddy.isPooping));
        this.actionButtons.add(new BuddyGuiButton(this.buddy, buddy -> "Play", () -> {
            if (!this.buddy.hasBeenAwakened) {
                return;
            }
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            LOGGER.debug("Creating play ball at screen coordinates: ({}, {})", (Object)mouseX, (Object)mouseY);
            PlayBall ball = new PlayBall(mouseX, mouseY, this.buddy);
            this.buddy.setPlayBall(ball);
            this.buddy.setChasingBall(true);
            ball.stickToCursor = true;
            this.hide();
        }, () -> !this.buddy.isSleeping && this.buddy.getEnergy() > 10.0f && this.buddy.getPlayBall() == null && !this.buddy.isEating && !this.buddy.isPooping));
        this.actionButtons.add(new BuddyGuiButton(this.buddy, buddy -> {
            if (System.currentTimeMillis() < this.sleepButtonCooldownEnd) {
                long secondsLeft = (this.sleepButtonCooldownEnd - System.currentTimeMillis()) / 1000L;
                return "Sleep (" + secondsLeft + "s)";
            }
            return "Sleep";
        }, () -> {
            if (!this.buddy.hasBeenAwakened) {
                return;
            }
            if (this.buddy.chanceCheck(8.0f)) {
                LOGGER.debug("Buddy refuses to go to sleep!");
                this.buddy.refuseSleep();
                this.sleepButtonCooldownEnd = System.currentTimeMillis() + 60000L;
                this.hide();
            } else {
                LOGGER.debug("Buddy agrees to go to sleep");
                this.buddy.startSleeping();
                this.hide();
            }
        }, () -> !this.buddy.isSleeping && this.buddy.getEnergy() < 20.0f && !this.buddy.isEating && !this.buddy.isPooping && System.currentTimeMillis() >= this.sleepButtonCooldownEnd));
    }

    public void show(int screenWidth, int screenHeight) {
        this.isMouseClicked = false;
        this.isVisible = true;
        this.guiX = (screenWidth - 320) / 2;
        this.guiY = (screenHeight - 240) / 2;
        this.updateButtonPositions();
        LOGGER.debug("Showing buddy leveling stats screen at ({}, {})", (Object)this.guiX, (Object)this.guiY);
    }

    public void hide() {
        this.isVisible = false;
        LOGGER.debug("Hiding buddy leveling stats screen");
    }

    private void updateButtonPositions() {
        int closeButtonX = this.guiX + 320 - 25;
        int closeButtonY = this.guiY + 5;
        if (!this.buttons.isEmpty()) {
            this.buttons.get(0).setPosition(closeButtonX, closeButtonY);
        }
        int statusBarsEndX = this.guiX + 20 + 150;
        int rightEdgeX = this.guiX + 320 - 20;
        int actionButtonWidth = 80;
        int actionButtonStartX = statusBarsEndX + (rightEdgeX - statusBarsEndX - actionButtonWidth) / 2;
        int statusBarsStartY = this.guiY + 50;
        Objects.requireNonNull(this.font);
        int statusBarsHeight = 4 * (9 + 10 + 2 + 4);
        int totalButtonsHeight = this.actionButtons.size() * 20 + (this.actionButtons.size() - 1) * 5;
        int actionButtonStartY = statusBarsStartY + (statusBarsHeight - totalButtonsHeight) / 2;
        int actionButtonSpacing = 25;
        for (int i = 0; i < this.actionButtons.size(); ++i) {
            int y = actionButtonStartY + i * actionButtonSpacing;
            this.actionButtons.get(i).setPosition(actionButtonStartX, y);
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.isVisible) {
            return;
        }
        graphics.method_51448().pushMatrix();
        int borderXDiff = 35;
        int borderYDiff = 27;
        graphics.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, this.guiX, this.guiY, 0.0f, 0.0f, 320, 240, 320, 240);
        graphics.method_25290(class_10799.field_56883, BACKGROUND_BORDER_TEXTURE, this.guiX - borderXDiff, this.guiY - borderYDiff, 0.0f, 0.0f, 390, 293, 390, 293);
        this.renderTabs(graphics, mouseX, mouseY, partial);
        switch (this.currentTab) {
            case 0: {
                this.renderStatsTab(graphics, mouseX, mouseY, partial);
                break;
            }
            case 1: {
                this.renderAchievementsTab(graphics, mouseX, mouseY, partial);
            }
        }
        for (BuddyGuiButton button : this.buttons) {
            button.method_25394(graphics, mouseX, mouseY, partial);
        }
        graphics.method_51448().popMatrix();
    }

    private void renderTabs(class_332 graphics, int mouseX, int mouseY, float partial) {
        class_327 font = class_310.method_1551().field_1772;
        int tabWidth = 80;
        int tabHeight = 20;
        int tabStartX = this.guiX + 5;
        int tabY = this.guiY - 8;
        String[] tabNames = new String[]{"Stats", "Achievements"};
        for (int i = 0; i < tabNames.length; ++i) {
            int tabX = tabStartX + i * tabWidth;
            boolean isSelected = i == this.currentTab;
            class_2960 buttonTexture = isSelected ? TAB_BUTTON_TEXTURE_SELECTED : TAB_BUTTON_TEXTURE_NORMAL;
            graphics.method_25290(class_10799.field_56883, buttonTexture, tabX, tabY, 0.0f, 0.0f, tabWidth, tabHeight, tabWidth, tabHeight);
            int textColor = isSelected ? 0xFFFFFF : 0xAAAAAA;
            int textX = tabX + (tabWidth - font.method_1727(tabNames[i])) / 2;
            Objects.requireNonNull(font);
            int textY = tabY + (tabHeight - 9) / 2;
            graphics.method_25303(font, tabNames[i], textX, textY, textColor);
        }
    }

    private void renderStatsTab(class_332 graphics, int mouseX, int mouseY, float partial) {
        class_327 font = class_310.method_1551().field_1772;
        int contentStartX = this.guiX + 20;
        int contentStartY = this.guiY + 30;
        String title = "Status & Stats";
        graphics.method_25303(font, title, this.guiX + (320 - font.method_1727(title)) / 2, contentStartY, 0xFFFFFF);
        this.renderStatusBars(graphics, contentStartX, contentStartY + 20);
        for (BuddyGuiButton button : this.actionButtons) {
            button.updateActiveState();
        }
        for (BuddyGuiButton button : this.actionButtons) {
            button.updateActiveState();
            button.method_25394(graphics, mouseX, mouseY, partial);
        }
        graphics.method_25294(contentStartX, contentStartY + 130, contentStartX + 320 - 40, contentStartY + 131, -2130706433);
        String levelText = "Level: " + this.levelingManager.getCurrentLevel();
        graphics.method_25303(font, levelText, contentStartX, contentStartY + 140, 0xFFFFFF);
        int xpBarX = contentStartX + 80;
        int xpBarY = contentStartY + 140;
        int xpBarWidth = 150;
        int xpBarHeight = 10;
        graphics.method_25294(xpBarX, xpBarY, xpBarX + xpBarWidth, xpBarY + xpBarHeight, Integer.MIN_VALUE);
        int progressPercentage = this.levelingManager.getLevelProgressPercentage();
        int fillWidth = xpBarWidth * progressPercentage / 100;
        if (fillWidth > 0) {
            graphics.method_25294(xpBarX, xpBarY, xpBarX + fillWidth, xpBarY + xpBarHeight, -16711936);
        }
        String xpText = this.levelingManager.getExperience() + " XP";
        xpText = this.levelingManager.getCurrentLevel() < 30 ? xpText + " / Next Level: " + this.levelingManager.getExperienceForNextLevel() + " XP" : xpText + " (Max Level)";
        graphics.method_25303(font, xpText, contentStartX, contentStartY + 155, 0xFFFFFF);
    }

    private void renderAchievementsTab(class_332 graphics, int mouseX, int mouseY, float partial) {
        boolean canScrollDown;
        class_327 font = class_310.method_1551().field_1772;
        int contentStartX = this.guiX + 20;
        int contentStartY = this.guiY + 30;
        String title = "Achievements";
        graphics.method_25303(font, title, this.guiX + (320 - font.method_1727(title)) / 2, contentStartY, 0xFFFFFF);
        int listStartY = contentStartY + 20;
        int listItemHeight = 25;
        int listWidth = 275;
        int maxVisibleItems = 6;
        ArrayList<BuddyAchievement> achievementsList = new ArrayList<BuddyAchievement>();
        for (Map.Entry<BuddyAchievement.AchievementType, BuddyAchievement> entry : this.levelingManager.getAchievements().entrySet()) {
            achievementsList.add(entry.getValue());
        }
        achievementsList.sort((a1, a2) -> {
            if (a1.isUnlocked() != a2.isUnlocked()) {
                return a1.isUnlocked() ? -1 : 1;
            }
            return Integer.compare(a1.getType().getTier(), a2.getType().getTier());
        });
        int maxScrollOffset = Math.max(0, achievementsList.size() - maxVisibleItems) * listItemHeight;
        this.achievementsScrollOffset = Math.min(this.achievementsScrollOffset, maxScrollOffset);
        int scissorY = listStartY;
        int scissorHeight = maxVisibleItems * listItemHeight;
        graphics.method_44379(contentStartX - 5, scissorY, contentStartX + listWidth, scissorY + scissorHeight);
        for (int i = 0; i < achievementsList.size(); ++i) {
            String rewardText;
            int itemY = listStartY + i * listItemHeight - this.achievementsScrollOffset;
            if (itemY + listItemHeight < scissorY - 50 || itemY > scissorY + scissorHeight + 50) continue;
            BuddyAchievement achievement = (BuddyAchievement)achievementsList.get(i);
            boolean isUnlocked = achievement.isUnlocked();
            int bgColor = isUnlocked ? -2147418368 : -2130771968;
            graphics.method_25294(contentStartX, itemY, contentStartX + listWidth, itemY + listItemHeight - 2, bgColor);
            String name = achievement.getType().getName();
            int nameColor = isUnlocked ? 0xFFFFFF : 0xAAAAAA;
            int nameMaxX = contentStartX + listWidth - 5;
            Objects.requireNonNull(font);
            BuddyStatusScreen.renderScrollingString(graphics, font, name, contentStartX + 5, itemY + 2, nameMaxX, itemY + 2 + 9, nameColor);
            Object description = achievement.getDescription();
            if (!isUnlocked) {
                description = "???" + (String)(achievement.getType().getTier() > 2 ? " (Tier " + achievement.getType().getTier() + ")" : "");
            }
            int descriptionMaxX = contentStartX + listWidth - 5;
            if (isUnlocked && achievement.getExperienceReward() > 0) {
                rewardText = "+" + achievement.getExperienceReward() + " XP";
                descriptionMaxX -= font.method_1727(rewardText) + 10;
            }
            Objects.requireNonNull(font);
            BuddyStatusScreen.renderScrollingString(graphics, font, (String)description, contentStartX + 5, itemY + 14, descriptionMaxX, itemY + 14 + 9, nameColor);
            if (!isUnlocked || achievement.getExperienceReward() <= 0) continue;
            rewardText = "+" + achievement.getExperienceReward() + " XP";
            graphics.method_25303(font, rewardText, contentStartX + listWidth - font.method_1727(rewardText) - 5, itemY + 5, 0xFFFF00);
        }
        graphics.method_44380();
        boolean canScrollUp = this.achievementsScrollOffset > 0;
        boolean bl = canScrollDown = this.achievementsScrollOffset < maxScrollOffset;
        if (canScrollUp) {
            graphics.method_25303(font, "\u25b2", this.guiX + 320 - 20, listStartY - 5, 0xFFFFFF);
        }
        if (canScrollDown) {
            graphics.method_25303(font, "\u25bc", this.guiX + 320 - 20, listStartY + maxVisibleItems * listItemHeight + 5, 0xFFFFFF);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible) {
            return false;
        }
        this.isMouseClicked = true;
        int tabWidth = 80;
        int tabHeight = 20;
        int tabStartX = this.guiX + 5;
        int tabY = this.guiY - 8;
        for (int i = 0; i < 2; ++i) {
            int tabX = tabStartX + i * tabWidth;
            if (!(mouseX >= (double)tabX) || !(mouseX < (double)(tabX + tabWidth)) || !(mouseY >= (double)tabY) || !(mouseY < (double)(tabY + tabHeight))) continue;
            this.currentTab = i;
            this.updateButtonPositions();
            return true;
        }
        if (mouseX >= (double)this.guiX && mouseX < (double)(this.guiX + 320) && mouseY >= (double)this.guiY && mouseY < (double)(this.guiY + 240)) {
            switch (this.currentTab) {
                case 0: {
                    break;
                }
                case 1: {
                    int listStartY = this.guiY + 50;
                    int maxVisibleItems = 6;
                    int listItemHeight = 25;
                    if (!(mouseX >= (double)(this.guiX + 320 - 20))) break;
                    if (mouseY >= (double)(listStartY - 10) && mouseY <= (double)(listStartY + 10)) {
                        this.achievementsScrollOffset = Math.max(0, this.achievementsScrollOffset - listItemHeight);
                        return true;
                    }
                    if (!(mouseY >= (double)(listStartY + maxVisibleItems * listItemHeight)) || !(mouseY <= (double)(listStartY + maxVisibleItems * listItemHeight + 20))) break;
                    this.achievementsScrollOffset += listItemHeight;
                    return true;
                }
            }
            if (this.currentTab == 0) {
                for (BuddyGuiButton actionButton : this.actionButtons) {
                    actionButton.updateActiveState();
                    if (!actionButton.isActive() || !actionButton.isMouseOver(mouseX, mouseY)) continue;
                    actionButton.onClick();
                    return true;
                }
            }
            for (BuddyGuiButton button2 : this.buttons) {
                if (!button2.isMouseOver(mouseX, mouseY)) continue;
                button2.onClick();
                return true;
            }
            return true;
        }
        this.hide();
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isMouseClicked = false;
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.isVisible) {
            return false;
        }
        if (mouseX >= (double)this.guiX && mouseX < (double)(this.guiX + 320) && mouseY >= (double)this.guiY && mouseY < (double)(this.guiY + 240)) {
            switch (this.currentTab) {
                case 1: {
                    this.achievementsScrollOffset = Math.max(0, this.achievementsScrollOffset - (int)(deltaY * 20.0));
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private static void renderScrollingString(class_332 graphics, class_327 font, String text, int minX, int minY, int maxX, int maxY, int color) {
        int availableWidth;
        int textWidth = font.method_1727(text);
        if (textWidth > (availableWidth = maxX - minX)) {
            int overflow = textWidth - availableWidth;
            double time = (double)System.currentTimeMillis() / 1000.0;
            double scrollPeriod = Math.max((double)overflow * 0.5, 3.0);
            double scrollProgress = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * time / scrollPeriod)) / 2.0 + 0.5;
            double scrollOffset = scrollProgress * (double)overflow;
            graphics.method_44379(minX, minY, maxX, maxY);
            graphics.method_25303(font, text, minX - (int)scrollOffset, minY, color);
            graphics.method_44380();
        } else {
            graphics.method_25303(font, text, minX, minY, color);
        }
    }

    private void renderStatusBars(class_332 graphics, int startX, int startY) {
        int barWidth = 150;
        int barHeight = 10;
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int labelHeight = 9;
        int verticalGap = 4;
        int totalItemHeight = labelHeight + barHeight + verticalGap;
        for (int i = 0; i < 4; ++i) {
            String label;
            int currentY = startY + totalItemHeight * i;
            graphics.method_25303(font, label, startX, currentY, switch (i) {
                case 0 -> {
                    label = "Hunger";
                    yield -44976;
                }
                case 1 -> {
                    label = "Happiness";
                    yield -11468976;
                }
                case 2 -> {
                    label = "Energy";
                    yield -11513601;
                }
                case 3 -> {
                    label = "Fun";
                    yield -3649281;
                }
                default -> {
                    label = "";
                    yield -1;
                }
            });
            int barY = currentY + labelHeight + 2;
            float fillAmount = 0.0f;
            DrawableColor barColor = switch (i) {
                case 0 -> {
                    fillAmount = this.buddy.getHunger() / 100.0f;
                    yield DrawableColor.of(255, 80, 80);
                }
                case 1 -> {
                    fillAmount = this.buddy.getHappiness() / 100.0f;
                    yield DrawableColor.of(80, 255, 80);
                }
                case 2 -> {
                    fillAmount = this.buddy.getEnergy() / 100.0f;
                    yield DrawableColor.of(80, 80, 255);
                }
                case 3 -> {
                    fillAmount = this.buddy.getFunLevel() / 100.0f;
                    yield DrawableColor.of(200, 80, 255);
                }
                default -> {
                    fillAmount = 0.0f;
                    yield DrawableColor.of(255, 255, 255);
                }
            };
            graphics.method_25294(startX, barY, startX + barWidth, barY + barHeight, Integer.MIN_VALUE);
            int fillWidth = Math.max(1, (int)((float)barWidth * fillAmount));
            if (fillWidth <= 0) continue;
            graphics.method_25294(startX, barY, startX + fillWidth, barY + barHeight, barColor.getColorInt());
        }
    }
}

