/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.ui;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.LogicExecutorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActionScreen
extends class_437
implements InitialWidgetFocusScreen {
    protected final ActionInstance instance;
    protected Consumer<ActionInstance> callback;
    protected Action originalAction = null;
    protected String originalActionValue = null;
    protected ScrollArea actionsListScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ExtendedEditBox searchBar;
    public boolean isEdit;

    public ChooseActionScreen(@Nullable ActionInstance instanceToEdit, @NotNull Consumer<ActionInstance> callback) {
        super((class_2561)(instanceToEdit != null ? class_2561.method_43471((String)"fancymenu.actions.screens.edit_action") : class_2561.method_43471((String)"fancymenu.actions.screens.add_action")));
        boolean bl = this.isEdit = instanceToEdit != null;
        if (this.isEdit) {
            this.originalAction = instanceToEdit.action;
            this.originalActionValue = instanceToEdit.value;
        }
        this.instance = this.isEdit ? instanceToEdit : new ActionInstance(Action.EMPTY, null);
        this.callback = callback;
    }

    protected void method_25426() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 21, 66, this.field_22789 / 2 - 40 - 2, 18, (class_2561)class_2561.method_43473());
        this.searchBar.setHintFancyMenu(consumes -> class_2561.method_43471((String)"fancymenu.actions.build_action.screen.search_action"));
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateActionsList());
        this.method_37063((class_364)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.setupInitialFocusWidget(this, (class_364)this.searchBar);
        this.actionsListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.actionsListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.actionsListScrollArea.setX(20.0f, true);
        this.actionsListScrollArea.setY(90.0f, true);
        this.method_37063(this.actionsListScrollArea);
        this.descriptionScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, this.field_22790 / 2 - 50 - 25), true);
        this.descriptionScrollArea.setX((float)(this.field_22789 - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(65.0f, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.method_37063(this.descriptionScrollArea);
        int cancelButtonX = this.field_22789 - 20 - 150;
        int cancelButtonY = this.field_22790 - 20 - 20 - 5 - 20;
        int doneButtonX = this.field_22789 - 20 - 150;
        int doneButtonY = this.field_22790 - 20 - 20;
        ExtendedButton doneOrNextButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (class_2561)class_2561.method_43473(), button -> this.onNextStep()).setLabelSupplier(consumes -> this.needsValueFirst() ? class_2561.method_43471((String)"fancymenu.ui.generic.next_step") : class_2561.method_43471((String)"fancymenu.common_components.done"));
        this.method_37063((class_364)doneOrNextButton);
        UIBase.applyDefaultWidgetSkinTo(doneOrNextButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.cancel"), button -> this.callback.accept(null));
        this.method_37063((class_364)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        this.updateActionsList();
        this.setDescription(this.instance.action);
        if (this.isEdit) {
            this.onNextStep();
        }
    }

    protected void onEditValue() {
        if (this.instance.action == Action.EMPTY) {
            return;
        }
        this.originalAction = null;
        this.originalActionValue = null;
        this.instance.action.editValue(LogicExecutorScreen.build(() -> {
            if (this.canClickDone()) {
                this.onDone();
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }), this.instance);
    }

    protected boolean hasValue() {
        return this.instance.action != Action.EMPTY && this.instance.action.hasValue();
    }

    protected void onDone() {
        this.callback.accept(this.instance.action != Action.EMPTY ? this.instance : null);
    }

    protected boolean canClickDone() {
        if (this.instance.action == Action.EMPTY) {
            return false;
        }
        return this.instance.value != null || !this.instance.action.hasValue();
    }

    protected boolean needsValueFirst() {
        return this.hasValue() && !this.canClickDone();
    }

    protected void onNextStep() {
        if (this.hasValue()) {
            this.onEditValue();
        } else if (this.canClickDone()) {
            this.onDone();
        }
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.actions.screens.build_screen.available_actions"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        class_5250 descLabel = class_2561.method_43471((String)"fancymenu.actions.screens.build_screen.action_description");
        int descLabelWidth = this.field_22793.method_27525((class_5348)descLabel);
        graphics.method_51439(this.field_22793, (class_2561)descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.method_25394(graphics, mouseX, mouseY, partial);
        this.performInitialWidgetFocusActionInRender();
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    protected void setDescription(@Nullable Action action) {
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        if (action != null && action.getActionDescription() != null) {
            for (class_2561 c : action.getActionDescription()) {
                this.addDescriptionLine(c);
            }
        }
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull class_2561 line) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.field_22793.method_27525((class_5348)line) > maxWidth) {
            this.field_22793.method_27527().method_27495((class_5348)line, maxWidth, class_2583.field_24360).forEach(formatted -> lines.add((class_2561)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (class_2561)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean actionFitsSearchValue(@NotNull Action action, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (action.getActionDisplayName().getString().toLowerCase().contains(s)) {
            return true;
        }
        return this.actionDescriptionContains(action, s);
    }

    protected boolean actionDescriptionContains(@NotNull Action action, @NotNull String s) {
        class_2561[] desc;
        for (class_2561 c : desc = Objects.requireNonNullElse(action.getActionDescription(), new class_2561[0])) {
            if (!c.getString().toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfActionsList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.actionsListScrollArea.clearEntries();
        List<Action> actions = ActionRegistry.getActions();
        actions.sort(Comparator.comparing(action -> action.getActionDisplayName().getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(action -> action.getActionDisplayName().getString()).thenComparing(Action::getIdentifier));
        for (Action action2 : actions) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !action2.shouldShowUpInEditorActionMenu(LayoutEditorScreen.getCurrentInstance()) || !this.actionFitsSearchValue(action2, searchValue)) continue;
            ActionScrollEntry e = new ActionScrollEntry(this.actionsListScrollArea, action2, entry -> {
                this.instance.action = action2;
                this.instance.value = this.originalAction == action2 ? this.originalActionValue : null;
                this.setDescription(action2);
            });
            this.actionsListScrollArea.addEntry(e);
        }
    }

    protected void updateActionsList() {
        this.setContentOfActionsList();
        if (this.instance.action != Action.EMPTY) {
            for (ScrollAreaEntry e : this.actionsListScrollArea.getEntries()) {
                if (!(e instanceof ActionScrollEntry) || ((ActionScrollEntry)e).action != this.instance.action) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public class ActionScrollEntry
    extends TextListScrollAreaEntry {
        public Action action;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;

        public ActionScrollEntry(@NotNull ScrollArea parent, @NotNull Action action, Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, ActionScrollEntry.buildLabel(action), UIBase.getUIColorTheme().listing_dot_color_1, onClick);
            this.lastClickTime = 0L;
            this.action = action;
        }

        @NotNull
        private static class_2561 buildLabel(@NotNull Action action) {
            class_5250 c = action.getActionDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
            if (action.isDeprecated()) {
                c = c.method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
                c = c.method_10852((class_2561)class_2561.method_43470((String)" ").method_10862(class_2583.field_24360.method_36140(Boolean.valueOf(false))));
                c = c.method_10852((class_2561)class_2561.method_43471((String)"fancymenu.actions.deprecated").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()).method_36140(Boolean.valueOf(false))));
            }
            return c;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 500L && ChooseActionScreen.this.instance.action == this.action) {
                ChooseActionScreen.this.onNextStep();
                this.lastClickTime = 0L;
                return;
            }
            this.lastClickTime = currentTime;
            super.onClick(entry, mouseX, mouseY, button);
        }
    }
}

