/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestStorageExtended;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.NearbyPointOfInterestStream;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.SphereChunkOrderedPoiSetSpliterator;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_3977;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_4180;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9820;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4153.class})
public abstract class PoiManagerMixin
extends class_4180<class_4157, class_4157.class_9865>
implements PointOfInterestStorageExtended,
RegionBasedStorageSectionExtended<class_4157> {
    public PoiManagerMixin(class_3977 simpleRegionStorage, Codec<class_4157.class_9865> codec, Function<class_4157, class_4157.class_9865> function, BiFunction<class_4157.class_9865, Runnable, class_4157> biFunction, Function<Runnable, class_4157> function2, class_5455 registryAccess, class_9820 chunkIOErrorReporter, class_5539 levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Overwrite
    public Optional<class_2338> method_20005(Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_4153.class_4155 status, class_2338 pos, int radius, class_5819 rand) {
        ArrayList<class_4156> list = this.withinSquareInL2Range(typePredicate, pos, radius, status);
        for (int i = list.size() - 1; i >= 0; --i) {
            class_4156 currentPOI = list.set(rand.method_43048(i + 1), list.get(i));
            list.set(i, currentPOI);
            if (!posPredicate.test(currentPOI.method_19141())) continue;
            return Optional.of(currentPOI.method_19141());
        }
        return Optional.empty();
    }

    @Override
    public Collection<Pair<class_6880<class_4158>, class_2338>> lithium$getNClosestFirstWithType(Predicate<class_6880<class_4158>> typeFilter, Predicate<class_2338> posFilter, class_2338 center, int radius, class_4153.class_4155 status, long n) {
        boolean b;
        int radiusSq = radius * radius;
        NearbyPointOfInterestStream poisInRange = new NearbyPointOfInterestStream(typeFilter, status, poiRecord -> posFilter.test(poiRecord.method_19141()), center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR);
        ArrayList<Pair<class_6880<class_4158>, class_2338>> collectedPois = new ArrayList<Pair<class_6880<class_4158>, class_2338>>();
        int i = 0;
        while ((long)i < n && (b = poisInRange.tryAdvance((Consumer<? super class_4156>)((Consumer<class_4156>)poi -> collectedPois.add(Pair.of((Object)poi.method_19142(), (Object)poi.method_19141())))))) {
            ++i;
        }
        return collectedPois;
    }

    @Overwrite
    public Optional<class_2338> method_19127(Predicate<class_6880<class_4158>> predicate, Predicate<class_2338> filter, class_2338 center, int radius, class_4153.class_4155 status) {
        long radiusSq = (long)radius * (long)radius;
        int minChunkX = center.method_10263() - radius - 1 >> 4;
        int maxChunkX = center.method_10263() + radius + 1 >> 4;
        int minChunkZ = center.method_10260() - radius - 1 >> 4;
        int maxChunkZ = center.method_10260() + radius + 1 >> 4;
        int chunkX = minChunkX;
        int chunkZ = minChunkZ;
        while (chunkZ <= maxChunkZ) {
            long deltaYSqMargin;
            class_4156 firstMatch;
            long minChunkToBlockDistanceL2Sq = Distances.getMinChunkToBlockDistanceL2Sq(center, chunkX, chunkZ);
            if (minChunkToBlockDistanceL2Sq <= radiusSq && (firstMatch = (class_4156)this.lithium$getFirstInRangeInChunkColumn(chunkX, chunkZ, deltaYSqMargin = radiusSq - minChunkToBlockDistanceL2Sq, center, radiusSq, (poiSection, pos, typeFilter, posPredicate, occupancy, maxDistSq) -> ((PointOfInterestSetExtended)poiSection).lithium$getFirstMatchingPoint((class_2338)pos, maxDistSq, (Predicate<class_6880<class_4158>>)typeFilter, (Predicate<class_2338>)posPredicate, (class_4153.class_4155)occupancy), predicate, filter, status)) != null) {
                return Optional.of(firstMatch.method_19141());
            }
            if (++chunkX <= maxChunkX) continue;
            ++chunkZ;
            chunkX = minChunkX;
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<Pair<class_6880<class_4158>, class_2338>> method_43985(Predicate<class_6880<class_4158>> typeFilter, class_2338 center, int radius, class_4153.class_4155 status) {
        int radiusSq = radius * radius;
        class_4156 closestPoi = new NearbyPointOfInterestStream(typeFilter, status, null, center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR).getFirst();
        return closestPoi == null ? Optional.empty() : Optional.of(Pair.of((Object)closestPoi.method_19142(), (Object)closestPoi.method_19141()));
    }

    @Override
    public Optional<class_2338> lithium$takeAt(Predicate<class_6880<class_4158>> typeFilter, BiPredicate<class_6880<class_4158>, class_2338> biPredicate, class_2338 blockPos) {
        class_4156 poiRecord;
        Optional poiSection = this.method_19294(class_4076.method_33706((class_2338)blockPos));
        if (poiSection.isPresent() && (poiRecord = ((PointOfInterestSetExtended)poiSection.get()).lithium$getAt(blockPos)) != null && typeFilter.test((class_6880<class_4158>)poiRecord.method_19142())) {
            poiRecord.method_19137();
            return Optional.of(poiRecord.method_19141());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<class_2338> method_20006(Predicate<class_6880<class_4158>> predicate, class_2338 center, int radius, class_4153.class_4155 status) {
        return this.method_34712(predicate, null, center, radius, status);
    }

    @Overwrite
    public Optional<class_2338> method_34712(Predicate<class_6880<class_4158>> predicate, Predicate<class_2338> posPredicate, class_2338 center, int radius, class_4153.class_4155 status) {
        int radiusSq = radius * radius;
        class_4156 closest = new NearbyPointOfInterestStream(predicate, status, posPredicate == null ? null : poi -> posPredicate.test(poi.method_19141()), center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR).getFirst();
        return closest == null ? Optional.empty() : Optional.of(closest.method_19141());
    }

    @Overwrite
    public long method_20252(Predicate<class_6880<class_4158>> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        return this.withinSquareInL2Range(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<class_4156> method_19125(Predicate<class_6880<class_4158>> predicate, class_2338 center, int radius, class_4153.class_4155 status) {
        return StreamSupport.stream(new SphereChunkOrderedPoiSetSpliterator(radius, center, this, predicate, status), false);
    }

    @Override
    public Optional<class_4156> lithium$findNearestForPortalLogic(class_2338 origin, int radius, class_6880<class_4158> type, class_4153.class_4155 status, Predicate<class_4156> afterSortPredicate, class_2784 worldBorder) {
        boolean worldBorderIsFarAway = worldBorder == null || worldBorder.method_11961((double)origin.method_10263(), (double)origin.method_10260()) > (double)(radius + 3);
        Predicate<class_4156> poiPredicateAfterSorting = worldBorderIsFarAway ? afterSortPredicate : poi -> worldBorder.method_11952(poi.method_19141()) && afterSortPredicate.test((class_4156)poi);
        SinglePointOfInterestTypeFilter typePredicate = new SinglePointOfInterestTypeFilter(type);
        class_4156 nearestPoi = new NearbyPointOfInterestStream(typePredicate, status, poiPredicateAfterSorting, origin, radius, this, (pos, pos2) -> Distances.isWithinCubeRadius(pos, radius, pos2), NearbyPointOfInterestStream.NEGATIVE_Y_POINT_COMPARATOR).getFirst();
        return nearestPoi == null ? Optional.empty() : Optional.of(nearestPoi);
    }

    @Unique
    private ArrayList<class_4156> withinSquareInL2Range(Predicate<class_6880<class_4158>> predicate, class_2338 origin, int radius, class_4153.class_4155 status) {
        int radiusSq = Math.multiplyExact(radius, radius);
        int minChunkX = origin.method_10263() - radius - 1 >> 4;
        int minChunkZ = origin.method_10260() - radius - 1 >> 4;
        int maxChunkX = origin.method_10263() + radius + 1 >> 4;
        int maxChunkZ = origin.method_10260() + radius + 1 >> 4;
        ArrayList<class_4156> points = new ArrayList<class_4156>();
        Consumer<class_4156> collector = point -> {
            if (Distances.isWithinSphereRadius(origin, radiusSq, point.method_19141())) {
                points.add((class_4156)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (class_4157 set : this.lithium$getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).lithium$collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }
}

