/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.entity;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import net.caffeinemc.mods.lithium.common.tracking.entity.EntityMovementTrackerSection;
import net.caffeinemc.mods.lithium.common.tracking.entity.MovementTrackerHelper;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedEntityMovementListener;
import net.caffeinemc.mods.lithium.common.util.tuples.WorldSectionBox;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.caffeinemc.mods.lithium.mixin.util.entity_movement_tracking.PersistentEntitySectionManagerAccessor;
import net.caffeinemc.mods.lithium.mixin.util.entity_movement_tracking.ServerLevelAccessor;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;

public abstract class SectionedEntityMovementTracker<E extends class_5568> {
    final WorldSectionBox trackedWorldSections;
    final Object clazz;
    private final int trackedIndex;
    ArrayList<class_5572<E>> sortedSections;
    boolean[] sectionVisible;
    private int timesRegistered;
    private final ArrayList<EntityMovementTrackerSection> sectionsNotListeningTo;
    private long maxChangeTime;
    private ReferenceOpenHashSet<SectionedEntityMovementListener> sectionedEntityMovementListeners;

    public SectionedEntityMovementTracker(WorldSectionBox interactionChunks, Object entityType) {
        this.clazz = entityType;
        this.trackedWorldSections = interactionChunks;
        this.trackedIndex = MovementTrackerHelper.getTrackerIndex(entityType);
        assert (this.trackedIndex != -1);
        this.sectionedEntityMovementListeners = null;
        this.sectionsNotListeningTo = new ArrayList();
    }

    public int hashCode() {
        return HashCommon.mix((int)this.trackedWorldSections.hashCode()) ^ HashCommon.mix((int)this.trackedIndex) ^ this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.clazz == ((SectionedEntityMovementTracker)obj).clazz && this.trackedWorldSections.equals(((SectionedEntityMovementTracker)obj).trackedWorldSections);
    }

    public boolean isUnchangedSince(long lastCheckedTime) {
        if (lastCheckedTime <= this.maxChangeTime) {
            return false;
        }
        if (!this.sectionsNotListeningTo.isEmpty()) {
            this.setChanged(this.listenToAllSectionsAndGetMaxChangeTime());
            return lastCheckedTime > this.maxChangeTime;
        }
        return true;
    }

    private long listenToAllSectionsAndGetMaxChangeTime() {
        long maxChangeTime = Long.MIN_VALUE;
        ArrayList<EntityMovementTrackerSection> notListeningTo = this.sectionsNotListeningTo;
        for (int i = notListeningTo.size() - 1; i >= 0; --i) {
            EntityMovementTrackerSection entityMovementTrackerSection = notListeningTo.remove(i);
            entityMovementTrackerSection.lithium$listenToMovementOnce(this, this.trackedIndex);
            maxChangeTime = Math.max(maxChangeTime, entityMovementTrackerSection.lithium$getChangeTime(this.trackedIndex));
        }
        return maxChangeTime;
    }

    public void register(class_3218 world) {
        assert (world == this.trackedWorldSections.world());
        if (this.timesRegistered == 0) {
            class_5573 cache = ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)world).getEntityManager()).getCache();
            WorldSectionBox trackedSections = this.trackedWorldSections;
            int size = trackedSections.numSections();
            assert (size > 0);
            this.sortedSections = new ArrayList(size);
            this.sectionVisible = new boolean[size];
            for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
                for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                    for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                        class_5572 section = cache.method_31784(class_4076.method_18685((int)x, (int)y, (int)z));
                        EntityMovementTrackerSection sectionAccess = (EntityMovementTrackerSection)section;
                        this.sortedSections.add(section);
                        sectionAccess.lithium$addListener(this);
                    }
                }
            }
            this.setChanged(world.method_75260());
        }
        ++this.timesRegistered;
    }

    public void unRegister(class_3218 world) {
        assert (world == this.trackedWorldSections.world());
        if (--this.timesRegistered > 0) {
            return;
        }
        assert (this.timesRegistered == 0);
        class_5573 cache = ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)world).getEntityManager()).getCache();
        ((LithiumData)world).lithium$getData().entityMovementTrackers().deleteCanonical(this);
        ArrayList<class_5572<E>> sections = this.sortedSections;
        for (int i = sections.size() - 1; i >= 0; --i) {
            class_5572<E> section = sections.get(i);
            EntityMovementTrackerSection sectionAccess = (EntityMovementTrackerSection)section;
            sectionAccess.lithium$removeListener(cache, this);
            if (this.sectionsNotListeningTo.remove(section)) continue;
            ((EntityMovementTrackerSection)section).lithium$removeListenToMovementOnce(this, this.trackedIndex);
        }
        this.setChanged(world.method_75260());
    }

    public void onSectionEnteredRange(EntityMovementTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().method_75260());
        int sectionIndex = this.sortedSections.lastIndexOf(section);
        this.sectionVisible[sectionIndex] = true;
        this.sectionsNotListeningTo.add(section);
        this.notifyAllListeners();
    }

    public void onSectionLeftRange(EntityMovementTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().method_75260());
        int sectionIndex = this.sortedSections.lastIndexOf(section);
        this.sectionVisible[sectionIndex] = false;
        if (!this.sectionsNotListeningTo.remove(section)) {
            section.lithium$removeListenToMovementOnce(this, this.trackedIndex);
            this.notifyAllListeners();
        }
    }

    private void setChanged(long atTime) {
        if (atTime > this.maxChangeTime) {
            this.maxChangeTime = atTime;
        }
    }

    public void listenToEntityMovementOnce(SectionedEntityMovementListener listener) {
        if (this.sectionedEntityMovementListeners == null) {
            this.sectionedEntityMovementListeners = new ReferenceOpenHashSet();
        }
        this.sectionedEntityMovementListeners.add((Object)listener);
        if (!this.sectionsNotListeningTo.isEmpty()) {
            this.setChanged(this.listenToAllSectionsAndGetMaxChangeTime());
        }
    }

    public void emitEntityMovement(int classMask, EntityMovementTrackerSection section) {
        if ((classMask & 1 << this.trackedIndex) != 0) {
            this.notifyAllListeners();
            this.sectionsNotListeningTo.add(section);
        }
    }

    private void notifyAllListeners() {
        ReferenceOpenHashSet<SectionedEntityMovementListener> listeners = this.sectionedEntityMovementListeners;
        if (listeners != null && !listeners.isEmpty()) {
            for (SectionedEntityMovementListener listener : listeners) {
                listener.lithium$handleEntityMovement(this.clazz);
            }
            listeners.clear();
        }
    }
}

