/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.platform;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.data.RenameData;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.data.SyncData;
import com.mrbysco.armorposer.packets.ArmorStandRenamePayload;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import com.mrbysco.armorposer.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1531;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8942;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public void updateEntity(class_1531 armorStand, class_2487 compound) {
        try (class_8942.class_11340 problemreporter$scopedcollector = new class_8942.class_11340(Reference.LOGGER);){
            class_11362 output = class_11362.method_71459((class_8942)problemreporter$scopedcollector, (class_7225.class_7874)armorStand.method_56673());
            armorStand.method_5647((class_11372)output);
            class_2487 outputCompound = output.method_71475();
            outputCompound.method_10543(compound);
            armorStand.method_5651(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)armorStand.method_56673(), (class_2487)outputCompound));
            SyncData data = new SyncData(armorStand.method_5667(), outputCompound);
            ClientPlayNetworking.send((class_8710)new ArmorStandSyncPayload(data));
        }
    }

    @Override
    public void swapSlots(class_1531 armorStand, SwapData.Action action) {
        SwapData data = new SwapData(armorStand.method_5667(), action);
        ClientPlayNetworking.send((class_8710)new ArmorStandSwapPayload(data));
    }

    @Override
    public void renameArmorStand(class_1531 armorStand, String newName) {
        RenameData data = new RenameData(armorStand.method_5667(), newName);
        ClientPlayNetworking.send((class_8710)new ArmorStandRenamePayload(data));
    }

    @Override
    public boolean allowScrolling() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.general.allowScrolling;
    }

    @Override
    public Path getUserPresetFolder() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isResizeRestrictedToOPS() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.general.restrictResizeToOP;
    }

    @Override
    public List<? extends String> getResizeWhitelist() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.general.resizeWhitelist;
    }

    @Override
    public boolean nameBasedFeatures() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.general.nameBasedFeatures;
    }

    @Override
    public String getModVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("armorposer").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public boolean directNametagOnly() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.client.directNametagOnly;
    }

    @Override
    public int nametagRenderDistance() {
        PoserConfig config = (PoserConfig)AutoConfig.getConfigHolder(PoserConfig.class).getConfig();
        return config.client.nametagRenderDistance;
    }
}

