/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.mixin.AbstractSliderButtonAccessor;
import java.text.DecimalFormat;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5250;
import net.minecraft.class_9848;

public class RangeSlider
extends class_357 {
    protected class_2561 prefix;
    protected class_2561 suffix;
    protected double minValue;
    protected double maxValue;
    private final double stepSize = 1.0;
    private final DecimalFormat format = new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
    protected boolean drawString;
    protected final OnChange onChange;

    public RangeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString, OnChange onChange) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.field_22753 = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        this.onChange = onChange;
        this.method_25346();
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void method_25347(double value) {
        this.setFractionalValue((value - this.minValue) / (this.maxValue - this.minValue));
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        ((AbstractSliderButtonAccessor)((Object)this)).armorposer$setDragging(this.field_22763);
        this.setValueFromMouse(event.comp_4798());
    }

    protected void method_25349(class_11909 event, double dragX, double dragY) {
        super.method_25349(event, dragX, dragY);
        this.setValueFromMouse(event.comp_4798());
    }

    public boolean method_25404(class_11908 keyEvent) {
        boolean flag = keyEvent.method_74232();
        if (flag || keyEvent.method_74233()) {
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f = flag ? -1.0f : 1.0f;
            this.method_25347(this.getValue() + (double)f * this.stepSize);
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setFractionalValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setFractionalValue(double fractionalValue) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(fractionalValue);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    private double snapToNearest(double value) {
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = 1.0 * (double)Math.round(value / 1.0);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)class_2561.method_43470((String)"").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    protected void method_25344() {
        if (this.onChange != null) {
            this.onChange.onChange(this.getValueInt());
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_52707(class_10799.field_56883, ((AbstractSliderButtonAccessor)((Object)this)).armorposer$getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), class_9848.method_61317((float)this.field_22765));
        guiGraphics.method_52707(class_10799.field_56883, ((AbstractSliderButtonAccessor)((Object)this)).armorposer$getHandleSprite(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364(), class_9848.method_61317((float)this.field_22765));
        int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        class_5250 message = this.method_25369().method_27661().method_27694(style -> style.method_36139(i));
        this.method_75799(guiGraphics.method_75787((class_339)this, class_332.class_12228.field_63850), (class_2561)message, 2);
        if (this.method_49606()) {
            guiGraphics.method_74037(((AbstractSliderButtonAccessor)((Object)this)).armorposer$isDragging() ? class_11876.field_62457 : class_11876.field_62455);
        }
    }

    public static interface OnChange {
        public void onChange(int var1);
    }
}

