/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import java.util.Objects;
import net.minecraft.class_10017;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3730;
import net.minecraft.class_4280;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import net.minecraft.class_9998;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PoseListWidget
extends class_4280<ListEntry> {
    private final ArmorPosesScreen parent;
    private final int listWidth;
    private final class_2561 title;

    public PoseListWidget(ArmorPosesScreen parent, class_2561 title, boolean user, int listWidth, int top, int bottom) {
        class_310 class_3102 = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(class_3102, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(user);
    }

    protected int method_65507() {
        return this.method_46426() + this.listWidth - 6;
    }

    public int method_25322() {
        return this.listWidth;
    }

    public void refreshList(boolean user) {
        this.method_25339();
        if (user) {
            this.parent.buildUserPoseList(x$0 -> this.method_25321((class_350.class_351)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        } else {
            this.parent.buildPoseList(x$0 -> this.method_25321((class_350.class_351)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        }
    }

    protected void renderSelection(class_332 guiGraphics, ListEntry listEntry, int p_240142_) {
        int x1 = listEntry.method_46426();
        int y1 = listEntry.method_46427();
        int x2 = x1 + listEntry.method_25368();
        int y2 = y1 + listEntry.method_25364();
        guiGraphics.method_25296(x1, y1, x2, y2, -1945083888, -1676648432);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_25296(this.method_46426(), 0, this.method_46426() + this.listWidth, this.parent.field_22790, -1945104368, -1676668912);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_27534(this.parent.getScreenFont(), this.title, this.method_46426() + this.listWidth / 2, 2, class_9848.method_61334((int)0xFFFFFF));
    }

    public void setSelected(@Nullable ListEntry selected) {
        this.parent.setSelected((ListEntry)this.method_25334(), selected, this.field_22764);
        super.method_25313((class_350.class_351)selected);
    }

    public class ListEntry
    extends class_4280.class_4281<ListEntry> {
        private final PoseEntry poseEntry;
        private final ArmorPosesScreen parent;
        private final class_9998 armorStandPreview = new class_9998();

        ListEntry(PoseEntry entry, ArmorPosesScreen parent) {
            class_638 level;
            this.poseEntry = entry;
            this.parent = parent;
            this.armorStandPreview.field_58171 = class_1299.field_6131;
            this.armorStandPreview.field_53448 = 25.0f;
            this.armorStandPreview.field_53446 = 210.0f;
            class_310 mc = parent.getScreenMinecraft();
            if (mc == null) {
                Reference.LOGGER.error("Minecraft is null, cannot create pose entry {}", (Object)entry.pose().name());
                return;
            }
            Object object = level = mc.method_1496() && mc.method_1576() != null ? (class_1937)mc.method_1576().method_3738().iterator().next() : mc.field_1687;
            if (level != null) {
                try {
                    class_1531 armorStand;
                    class_2487 tag = class_2522.method_67315((String)entry.pose().data());
                    class_2487 nbt = new class_2487();
                    nbt.method_10582("id", "minecraft:armor_stand");
                    if (!tag.method_33133()) {
                        nbt.method_10543(tag);
                    }
                    if ((armorStand = (class_1531)class_1299.method_71371((class_2487)nbt, (class_1937)level, (class_3730)class_3730.field_52444, entity -> {
                        if (entity instanceof class_1531) {
                            class_1531 stand = (class_1531)entity;
                            stand.method_6907(true);
                            stand.method_6913(true);
                            stand.field_6283 = 210.0f;
                            stand.method_36457(25.0f);
                            stand.field_6241 = stand.method_36454();
                            stand.field_6259 = stand.method_36454();
                        }
                        return entity;
                    })) != null) {
                        this.updateState(armorStand);
                    }
                }
                catch (Exception e) {
                    Reference.LOGGER.error("Unable to parse nbt pose {}", (Object)e.getMessage());
                }
            }
        }

        public void updateState(class_1531 stand) {
            this.armorStandPreview.field_53250 = stand.method_61489();
            this.armorStandPreview.field_53248 = stand.method_6914();
            this.armorStandPreview.field_53249 = stand.method_6929();
            this.armorStandPreview.field_53333 = stand.method_5767();
            this.armorStandPreview.field_53337 = stand.method_5797();
            this.armorStandPreview.field_53251 = stand.method_6921();
            this.armorStandPreview.field_53252 = stand.method_6923();
            this.armorStandPreview.field_53253 = stand.method_6930();
            this.armorStandPreview.field_53254 = stand.method_6903();
            this.armorStandPreview.field_53255 = stand.method_6917();
            this.armorStandPreview.field_53256 = stand.method_6900();
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            int left = this.method_73380();
            int top = this.method_73382();
            Matrix3x2fStack pose = guiGraphics.method_51448();
            pose.pushMatrix();
            pose.translate(0.0f, (float)top - (float)PoseListWidget.this.field_22759 / 2.0f);
            PoseListWidget.this.method_75799(guiGraphics.method_75788(), this.getName(), 18);
            if (PoseListWidget.this.method_25334() == this) {
                this.renderPose(guiGraphics, left + 16, top + 28, partialTick);
            }
            pose.popMatrix();
        }

        public void renderPose(class_332 guiGraphics, int xPos, int yPos, float partialTick) {
            if (this.armorStandPreview != null) {
                int startX = xPos - 40;
                int startY = yPos - 60;
                int endX = xPos + 40;
                int endY = yPos + 60;
                guiGraphics.method_70856((class_10017)this.armorStandPreview, 20.0f, Reference.ARMOR_STAND_TRANSLATION, Reference.ARMOR_STAND_ANGLE, null, startX, startY, endX, endY);
            }
        }

        public class_2487 getTag() {
            return this.poseEntry.getTag();
        }

        public class_2561 getName() {
            return this.poseEntry.getName();
        }

        public boolean userAdded() {
            return this.poseEntry.userAdded();
        }

        public String rawName() {
            return this.poseEntry.pose().name();
        }

        public class_2561 method_37006() {
            return this.getName();
        }
    }
}

