/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.SavePoseScreen;
import com.mrbysco.armorposer.client.gui.widgets.NumberFieldBox;
import com.mrbysco.armorposer.client.gui.widgets.SizeField;
import com.mrbysco.armorposer.client.gui.widgets.ToggleButton;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.platform.Services;
import com.mrbysco.armorposer.util.ArmorStandData;
import com.mrbysco.armorposer.util.ArmorUtil;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2379;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_347;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.minecraft.class_8942;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;

public class ArmorStandScreen
extends class_437 {
    private static final class_8666 MIRROR_POSE_SPRITES = new class_8666(Reference.modLoc("widget/mirror_pose"), Reference.modLoc("widget/mirror_pose_highlighted"));
    private static final class_8666 MIRROR_LEGS_SPRITES = new class_8666(Reference.modLoc("widget/mirror_legs"), Reference.modLoc("widget/mirror_legs_highlighted"));
    private static final class_8666 MIRROR_ARMS_SPRITES = new class_8666(Reference.modLoc("widget/mirror_arms"), Reference.modLoc("widget/mirror_arms_highlighted"));
    private static final class_8666 SWAP_TO_HEAD_SPRITES = new class_8666(Reference.modLoc("widget/swap_to_head"), Reference.modLoc("widget/swap_to_head_highlighted"));
    private static final class_8666 MIRROR_HANDS_SPRITES = new class_8666(Reference.modLoc("widget/mirror_hands"), Reference.modLoc("widget/mirror_hands_highlighted"));
    private static final class_8666 BLOCK_SPRITES = new class_8666(Reference.modLoc("widget/block"), Reference.modLoc("widget/block_highlighted"));
    private static final class_8666 ITEM_SPRITES = new class_8666(Reference.modLoc("widget/item"), Reference.modLoc("widget/item_highlighted"));
    private static final class_8666 TOOL_SPRITES = new class_8666(Reference.modLoc("widget/tool"), Reference.modLoc("widget/tool_highlighted"));
    private final class_1531 entityArmorStand;
    private final ArmorStandData armorStandData;
    private final SavePoseScreen savePoseScreen;
    private final String[] buttonLabels = new String[]{"invisible", "base_plate", "gravity", "show_arms", "small", "name_visible", "rotation", "scale"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private final String version;
    private class_342 nameField;
    private String oldName;
    private String changedName;
    private class_4185 renameButton;
    private NumberFieldBox rotationTextField;
    private final ToggleButton[] toggleButtons = new ToggleButton[6];
    protected final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private SizeField sizeField;
    private class_347 lockButton;
    private final boolean allowScrolling;
    private class_243 lastSendOffset = new class_243(0.0, 0.0, 0.0);
    private final class_7919 yPositionTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.y_position"));
    private final class_7919 yPositionTooltipDisabled = class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.y_position.disabled").method_27692(class_124.field_1061));
    private final int whiteColor = class_9848.method_61334((int)0xFFFFFF);

    public ArmorStandScreen(class_1531 armorStand) {
        super((class_2561)class_2561.method_43471((String)"armorposer.gui.title"));
        this.entityArmorStand = armorStand;
        this.oldName = armorStand.method_16914() ? armorStand.method_5477().getString() : this.method_25440().getString();
        this.armorStandData = new ArmorStandData();
        try (class_8942.class_11340 problemreporter$scopedcollector = new class_8942.class_11340(Reference.LOGGER);){
            class_11362 output = class_11362.method_71459((class_8942)problemreporter$scopedcollector, (class_7225.class_7874)armorStand.method_56673());
            armorStand.method_5647((class_11372)output);
            class_2487 tag = output.method_71475();
            if (tag.method_68568("Pose").method_33133()) {
                class_2487 poseTag = ArmorUtil.writeAllPoses(armorStand);
                tag.method_10566("Pose", (class_2520)poseTag);
            }
            this.armorStandData.readFromNBT(tag);
        }
        this.allowScrolling = Services.PLATFORM.allowScrolling();
        this.version = Services.PLATFORM.getModVersion();
        this.savePoseScreen = new SavePoseScreen(this);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        int height;
        int width;
        int y;
        int x;
        int i;
        super.method_25426();
        this.nameField = new class_342(this.field_22793, this.field_22789 / 2 - this.field_22793.method_1727(this.oldName) / 2, 10, 100, 20, (class_2561)class_2561.method_43471((String)"armorposer.gui.label.name"));
        this.nameField.method_1852(this.oldName);
        this.nameField.method_1868(this.whiteColor);
        this.nameField.method_1860(this.whiteColor);
        this.nameField.method_1858(false);
        this.nameField.method_1880(50);
        this.nameField.method_71503(true);
        this.nameField.method_25365(false);
        this.nameField.method_1863(text -> {
            this.changedName = text;
            this.updateRenameButton();
        });
        this.method_25429((class_364)this.nameField);
        this.renameButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.label.rename"), button -> {
            if (this.hasLevels() && !this.oldName.equals(this.changedName)) {
                this.entityArmorStand.method_5665((class_2561)class_2561.method_43470((String)this.changedName));
                Services.PLATFORM.renameArmorStand(this.entityArmorStand, this.changedName);
                this.oldName = this.changedName;
                this.updateRenameButton();
            }
        }).method_46434(this.field_22789 / 2, 24, 40, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.rename"))).method_46431();
        this.method_37063((class_364)this.renameButton);
        this.renameButton.field_22764 = false;
        this.renameButton.field_22763 = false;
        int offsetX = 110;
        int offsetY = 20;
        for (i = 0; i < this.toggleButtons.length; ++i) {
            x = offsetX;
            y = offsetY + i * 22;
            width = 40;
            height = 20;
            this.toggleButtons[i] = new ToggleButton.Builder(this.armorStandData.getBooleanValue(i), button -> {
                ToggleButton toggleButton;
                toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
                this.textFieldUpdated();
            }).bounds(x, y, width, height).build();
            this.method_37063((class_364)this.toggleButtons[i]);
            this.toggleButtons[i].method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("armorposer.gui.tooltip." + this.buttonLabels[i]))));
        }
        this.rotationTextField = new NumberFieldBox(this.field_22793, 1 + offsetX, 1 + offsetY + this.toggleButtons.length * 22, 38, 17, (class_2561)class_2561.method_43471((String)"armorposer.gui.label.rotation"));
        this.rotationTextField.method_1852(String.valueOf((int)this.armorStandData.rotation));
        this.rotationTextField.method_1880(4);
        this.method_25429((class_364)this.rotationTextField);
        this.rotationTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.rotation")));
        this.sizeField = new SizeField(this.field_22793, 1 + offsetX, offsetY + (this.toggleButtons.length + 1) * 22, 38, 17, (class_2561)class_2561.method_43471((String)"armorposer.gui.label.scale"));
        this.sizeField.method_1852(String.valueOf((double)this.entityArmorStand.method_55693()));
        this.sizeField.method_1880(4);
        this.method_25429((class_364)this.sizeField);
        this.sizeField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.scale")));
        if (this.field_22787 != null && !Reference.canResize((class_1657)this.field_22787.field_1724)) {
            this.sizeField.method_1888(false);
            this.sizeField.field_22763 = false;
            this.sizeField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.size.disabled").method_27692(class_124.field_1061)));
        }
        offsetX = this.field_22789 - 20 - 100;
        for (i = 0; i < this.poseTextFields.length; ++i) {
            boolean lastRow;
            x = 1 + offsetX + i % 3 * 35;
            y = 1 + offsetY + i / 3 * 22;
            width = 28;
            height = 17;
            String value = String.valueOf((int)this.armorStandData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.field_22793, x, y, width, height, (class_2561)class_2561.method_43470((String)value));
            this.poseTextFields[i].method_1852(value);
            this.poseTextFields[i].method_1880(4);
            boolean bl = lastRow = i >= 18 && i < 21;
            if (lastRow) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].allowDecimal = true;
                this.poseTextFields[i].method_1880(6);
            }
            if (i % 3 == 0) {
                this.poseTextFields[i].method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("armorposer.gui.tooltip." + (lastRow ? "x_position" : "x_rotation")))));
            } else if (i % 3 == 1) {
                this.poseTextFields[i].method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("armorposer.gui.tooltip." + (lastRow ? "y_position" : "y_rotation")))));
            } else {
                this.poseTextFields[i].method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("armorposer.gui.tooltip." + (lastRow ? "z_position" : "z_rotation")))));
            }
            this.method_25429((class_364)this.poseTextFields[i]);
        }
        offsetY = this.field_22790 / 4 + 134;
        offsetX = 20;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.label.poses"), button -> this.field_22787.method_1507((class_437)new ArmorPosesScreen(this))).method_46434(offsetX, offsetY, 130, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.poses"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.label.copy"), button -> {
            class_2487 compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.field_22787 != null) {
                this.field_22787.field_1774.method_1455(clipboardData);
            }
        }).method_46434(offsetX, offsetY + 22, 42, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.copy"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.field_22787 != null) {
                    clipboardData = this.field_22787.field_1774.method_1460();
                }
                if (clipboardData != null) {
                    class_2487 compound;
                    compound.method_10556("NoBasePlate", !(compound = class_2522.method_67315(clipboardData)).method_68566("NoBasePlate", false));
                    compound.method_10556("NoGravity", !compound.method_68566("NoGravity", false));
                    this.readFieldsFromNBT(compound);
                    this.textFieldUpdated();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).method_46434(offsetX + 44, offsetY + 22, 42, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.paste"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.label.save"), button -> this.field_22787.method_1507((class_437)this.savePoseScreen)).method_46434(offsetX + 88, offsetY + 22, 42, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.save"))).method_46431());
        offsetX = this.field_22789 - 20;
        int buttonsLeft = 9;
        int buttonOffset = -4;
        class_344 mirrorPose = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_POSE_SPRITES, button -> {
            float[] head = new float[]{this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()};
            this.poseTextFields[0].method_1852(String.valueOf(head[0]));
            this.poseTextFields[1].method_1852(String.valueOf(head[1] != 0.0f ? -head[1] : 0.0f));
            this.poseTextFields[2].method_1852(String.valueOf(head[2] != 0.0f ? -head[2] : 0.0f));
            float[] body = new float[]{this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()};
            this.poseTextFields[3].method_1852(String.valueOf(body[0]));
            this.poseTextFields[4].method_1852(String.valueOf(body[1] != 0.0f ? -body[1] : 0.0f));
            this.poseTextFields[5].method_1852(String.valueOf(body[2] != 0.0f ? -body[2] : 0.0f));
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].method_1852(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].method_1852(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].method_1852(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].method_1852(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].method_1852(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].method_1852(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].method_1852(String.valueOf(rightArm[0]));
            this.poseTextFields[13].method_1852(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].method_1852(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].method_1852(String.valueOf(leftArm[0]));
            this.poseTextFields[16].method_1852(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].method_1852(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorPose.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.mirror")));
        class_344 mirrorLegs = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_LEGS_SPRITES, button -> {
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].method_1852(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].method_1852(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].method_1852(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].method_1852(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].method_1852(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].method_1852(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorLegs.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.mirror_legs")));
        class_344 mirrorArms = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_ARMS_SPRITES, button -> {
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].method_1852(String.valueOf(rightArm[0]));
            this.poseTextFields[13].method_1852(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].method_1852(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].method_1852(String.valueOf(leftArm[0]));
            this.poseTextFields[16].method_1852(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].method_1852(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorArms.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.mirror_arms")));
        class_344 swapToHead = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, SWAP_TO_HEAD_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_WITH_HEAD)));
        swapToHead.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.swap_head")));
        class_344 swapHands = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_HANDS_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_HANDS)));
        swapHands.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.swap_hands")));
        class_344 blockButton = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, BLOCK_SPRITES, button -> {
            try {
                class_243 pos = this.entityArmorStand.method_73189();
                double xDiff = this.getDesiredOffset(pos.field_1352, 1.0725);
                double yDiff = this.getDesiredOffset(pos.field_1351, -0.655);
                double zDiff = this.getDesiredOffset(pos.field_1350, 0.852);
                class_243 offset = new class_243(xDiff, yDiff, zDiff);
                int closestDegree = class_3532.method_28139((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.field_1350 - 0.7;
                        double newZ = -offset.field_1352 + 1.18;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.field_1352;
                        double newZ = -offset.field_1350;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.field_1350 + 0.7;
                        double newZ = offset.field_1352 - 1.18;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                }
                class_2487 tag = class_2522.method_67315((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-15.0f,135.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.method_1852(String.valueOf(closestDegree));
                this.poseTextFields[18].method_1852(String.valueOf(offset.field_1352));
                this.poseTextFields[19].method_1852(String.valueOf(offset.field_1351));
                this.poseTextFields[20].method_1852(String.valueOf(offset.field_1350));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        blockButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.block")));
        class_344 itemButton = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, ITEM_SPRITES, button -> {
            if (this.field_22787.method_74187()) {
                try {
                    class_243 pos = this.entityArmorStand.method_73189();
                    double xDiff = this.getDesiredOffset(pos.field_1352, 0.86);
                    double yDiff = this.getDesiredOffset(pos.field_1351, -1.41);
                    double zDiff = this.getDesiredOffset(pos.field_1350, -0.0625);
                    class_243 offset = new class_243(xDiff, yDiff, zDiff);
                    int closestDegree = class_3532.method_28139((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.field_1350 + 1.12;
                            double newZ = -offset.field_1352 + 0.74;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.field_1352;
                            double newZ = -offset.field_1350;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.field_1350 - 1.12;
                            double newZ = offset.field_1352 - 0.74;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                    }
                    class_2487 tag = class_2522.method_67315((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-90.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.method_1852(String.valueOf(closestDegree));
                    this.poseTextFields[18].method_1852(String.valueOf(offset.field_1352));
                    this.poseTextFields[19].method_1852(String.valueOf(offset.field_1351));
                    this.poseTextFields[20].method_1852(String.valueOf(offset.field_1350));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException pos) {}
            } else {
                try {
                    class_243 pos = this.entityArmorStand.method_73189();
                    double xDiff = this.getDesiredOffset(pos.field_1352, 0.886);
                    double yDiff = this.getDesiredOffset(pos.field_1351, -0.78);
                    double zDiff = this.getDesiredOffset(pos.field_1350, 0.205);
                    class_243 offset = new class_243(xDiff, yDiff, zDiff);
                    int closestDegree = class_3532.method_28139((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.field_1350 + 0.59;
                            double newZ = -offset.field_1352 + 0.78;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.field_1352;
                            double newZ = -offset.field_1350;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.field_1350 - 0.59;
                            double newZ = offset.field_1352 - 0.78;
                            offset = new class_243(newX, offset.field_1351, newZ);
                            break;
                        }
                    }
                    class_2487 tag = class_2522.method_67315((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[0.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.method_1852(String.valueOf(closestDegree));
                    this.poseTextFields[18].method_1852(String.valueOf(offset.field_1352));
                    this.poseTextFields[19].method_1852(String.valueOf(offset.field_1351));
                    this.poseTextFields[20].method_1852(String.valueOf(offset.field_1350));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }));
        itemButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.item").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.item2").method_27692(class_124.field_1080))));
        class_344 toolButton = (class_344)this.method_37063((class_364)new class_344(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, TOOL_SPRITES, button -> {
            try {
                class_243 pos = this.entityArmorStand.method_73189();
                double xDiff = this.getDesiredOffset(pos.field_1352, 0.33);
                double yDiff = this.getDesiredOffset(pos.field_1351, -1.285);
                double zDiff = this.getDesiredOffset(pos.field_1350, 0.059999);
                class_243 offset = new class_243(xDiff, yDiff, zDiff);
                int closestDegree = class_3532.method_28139((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.field_1350 + 0.88;
                        double newZ = -offset.field_1352 - 0.34;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.field_1352;
                        double newZ = -offset.field_1350;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.field_1350 - 0.88;
                        double newZ = offset.field_1352 + 0.34;
                        offset = new class_243(newX, offset.field_1351, newZ);
                        break;
                    }
                }
                class_2487 tag = class_2522.method_67315((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-10.0f,0.0f,-90.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.method_1852(String.valueOf(closestDegree));
                this.poseTextFields[18].method_1852(String.valueOf(offset.field_1352));
                this.poseTextFields[19].method_1852(String.valueOf(offset.field_1351));
                this.poseTextFields[20].method_1852(String.valueOf(offset.field_1350));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        toolButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.tool")));
        this.lockButton = new class_347(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, button -> {
            this.lockButton.method_1895(!this.lockButton.method_1896());
            this.textFieldUpdated();
        });
        this.method_37063((class_364)this.lockButton);
        this.lockButton.method_1895(this.armorStandData.getBooleanValue(6));
        this.lockButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.lock")));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            this.textFieldUpdated();
            this.field_22787.method_1507((class_437)null);
        }).method_46434(offsetX - 194, offsetY + 22, 97, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
            this.poseTextFields[18].method_1852("0");
            this.poseTextFields[19].method_1852("0");
            this.poseTextFields[20].method_1852("0");
            this.textFieldUpdated();
            this.updateEntity(this.armorStandData.writeToNBT());
            this.field_22787.method_1507((class_437)null);
        }).method_46434(offsetX - 95, offsetY + 22, 97, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udca1"), button -> this.field_22787.method_1507((class_437)new ArmorGlowScreen(this))).method_46434(0, 0, 16, 16).method_46431());
    }

    public void method_25410(int width, int height) {
        String s = this.nameField.method_1882();
        this.method_25423(width, height);
        this.nameField.method_1852(s);
    }

    private double getDesiredOffset(double posValue, double desiredValue) {
        double value = posValue - (double)((int)posValue);
        if (value < 0.0) {
            value = -value;
        }
        return desiredValue - value;
    }

    private boolean hasLevels() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return false;
        }
        if (this.field_22787.field_1724.method_31549().field_7477) {
            return true;
        }
        return this.field_22787.field_1724.field_7520 >= 1;
    }

    private void updateRenameButton() {
        if (!this.oldName.equals(this.changedName)) {
            this.renameButton.field_22764 = true;
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                if (!this.hasLevels()) {
                    this.renameButton.field_22763 = false;
                    this.renameButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.rename.disabled").method_27692(class_124.field_1061)));
                } else {
                    this.renameButton.field_22763 = true;
                }
            }
        } else {
            this.renameButton.field_22764 = false;
            this.renameButton.field_22763 = false;
            this.renameButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorposer.gui.tooltip.rename")));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.nameField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.rotationTextField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.sizeField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        int offsetY = 20;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.field_22793);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.method_51433(this.field_22793, class_1074.method_4662((String)("armorposer.gui.label." + this.buttonLabels[i]), (Object[])new Object[0]), x, y, this.whiteColor, true);
        }
        offsetX = this.field_22789 - 20 - 100;
        guiGraphics.method_51433(this.field_22793, "X", offsetX + 10, 7, this.whiteColor, true);
        guiGraphics.method_51433(this.field_22793, "Y", offsetX + 45, 7, this.whiteColor, true);
        guiGraphics.method_51433(this.field_22793, "Z", offsetX + 80, 7, this.whiteColor, true);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            String translatedLabel = class_1074.method_4662((String)("armorposer.gui.label." + this.sliderLabels[i]), (Object[])new Object[0]);
            int x = offsetX - this.field_22793.method_1727(translatedLabel) - 10;
            Objects.requireNonNull(this.field_22793);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.method_51433(this.field_22793, translatedLabel, x, y, this.whiteColor, true);
        }
        Matrix3x2fStack pose = guiGraphics.method_51448();
        if (Services.PLATFORM.allowScrolling()) {
            pose.pushMatrix();
            pose.rotate(1.5708f);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"armorposer.gui.label.scroll", (Object[])new Object[]{this.version}), 21, -this.field_22789 + 10, class_9848.method_61334((int)0xAAAAAA), true);
            pose.popMatrix();
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void method_25393() {
        super.method_25393();
        boolean gravityEnabled = this.toggleButtons[2].getValue();
        NumberFieldBox yPositionField = this.poseTextFields[19];
        yPositionField.method_1888(!gravityEnabled);
        if (!gravityEnabled) {
            yPositionField.method_47400(this.yPositionTooltip);
        } else {
            yPositionField.method_25365(false);
            yPositionField.method_47400(this.yPositionTooltipDisabled);
        }
    }

    public boolean method_25400(class_11905 characterEvent) {
        boolean typed = super.method_25400(characterEvent);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean method_25401(double mouseX, double mouseY, double xScroll, double yScroll) {
        block7: {
            float multiplier;
            block6: {
                float f = multiplier = this.field_22787.method_74187() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(yScroll > 0.0)) break block6;
                if (this.rotationTextField.method_20315()) {
                    int nextValue = (int)(this.rotationTextField.getFloat() + 1.0f * multiplier);
                    this.rotationTextField.method_1852(String.valueOf(nextValue));
                    this.rotationTextField.method_1875(0);
                    this.rotationTextField.method_1884(0);
                    this.textFieldUpdated();
                    return true;
                }
                if (this.sizeField.method_20315()) {
                    float nextValue = (float)((double)this.sizeField.getFloat() + (double)(multiplier * this.sizeField.scrollMultiplier));
                    nextValue = Math.clamp(nextValue, this.sizeField.minValue, this.sizeField.maxValue);
                    this.sizeField.method_1852(String.valueOf(nextValue));
                    this.sizeField.method_1875(0);
                    this.sizeField.method_1884(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.method_20315()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.method_1852(String.valueOf(nextValue));
                    textField.method_1875(0);
                    textField.method_1884(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block7;
            }
            if (!this.allowScrolling || !(yScroll < 0.0)) break block7;
            if (this.rotationTextField.method_20315()) {
                int previousValue = (int)(this.rotationTextField.getFloat() - 1.0f * multiplier);
                this.rotationTextField.method_1852(String.valueOf(previousValue));
                this.rotationTextField.method_1875(0);
                this.rotationTextField.method_1884(0);
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.method_20315()) {
                float previousValue = (float)((double)this.sizeField.getFloat() - (double)(multiplier * this.sizeField.scrollMultiplier));
                previousValue = Math.clamp(previousValue, this.sizeField.minValue, this.sizeField.maxValue);
                this.sizeField.method_1852(String.valueOf(previousValue));
                this.sizeField.method_1875(0);
                this.sizeField.method_1884(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.method_20315()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.method_1852(String.valueOf(previousValue));
                textField.method_1875(0);
                textField.method_1884(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, xScroll, yScroll);
    }

    public boolean method_25404(class_11908 keyEvent) {
        int keyCode = keyEvent.comp_4795();
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].method_25370()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].method_1872(false);
                this.poseTextFields[i].method_25365(false);
                int j = !this.field_22787.method_74187() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].method_25365(true);
                this.poseTextFields[j].method_1883(0, false);
                this.poseTextFields[j].method_1884(this.poseTextFields[j].method_1882().length());
            }
        } else {
            if (this.nameField.method_25404(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.rotationTextField.method_25404(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.method_25404(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.method_25404(keyEvent)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_25402(class_11909 buttonEvent, boolean flag) {
        return super.method_25402(buttonEvent, flag);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    protected class_2487 writeFieldsToNBT() {
        class_2487 compound = new class_2487();
        compound.method_10556("Invisible", this.toggleButtons[0].getValue());
        compound.method_10556("NoBasePlate", !this.toggleButtons[1].getValue());
        compound.method_10556("NoGravity", !this.toggleButtons[2].getValue());
        compound.method_10556("ShowArms", this.toggleButtons[3].getValue());
        compound.method_10556("Small", this.toggleButtons[4].getValue());
        compound.method_10556("CustomNameVisible", this.toggleButtons[5].getValue());
        compound.method_10556("Invulnerable", this.lockButton.method_1896());
        compound.method_10569("DisabledSlots", this.lockButton.method_1896() ? 0x3F3F3F : 0);
        compound.method_10549("Scale", (double)this.sizeField.getFloat());
        compound.method_67494("Rotation", class_241.field_56695, (Object)new class_241(this.rotationTextField.getFloat(), 0.0f));
        class_2487 poseTag = new class_2487();
        poseTag.method_67494("Head", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()));
        poseTag.method_67494("Body", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()));
        poseTag.method_67494("LeftLeg", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()));
        poseTag.method_67494("RightLeg", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()));
        poseTag.method_67494("LeftArm", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()));
        poseTag.method_67494("RightArm", class_2379.field_57040, (Object)new class_2379(this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()));
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.field_1352;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.field_1351;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.field_1350;
        compound.method_67494("Move", class_243.field_38277, (Object)new class_243(offsetXDiff, offsetYDiff, offsetZDiff));
        this.lastSendOffset = new class_243((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.method_10566("Pose", (class_2520)poseTag);
        return compound;
    }

    protected void readFieldsFromNBT(class_2487 compound) {
        class_2487 armorStandTag = this.armorStandData.writeToNBT();
        armorStandTag.method_10543(compound);
        this.armorStandData.readFromNBT(armorStandTag);
        this.toggleButtons[0].setValue(compound.method_68566("Invisible", false));
        this.toggleButtons[1].setValue(compound.method_68566("NoBasePlate", false));
        this.toggleButtons[2].setValue(compound.method_68566("NoGravity", false));
        this.toggleButtons[3].setValue(compound.method_68566("ShowArms", false));
        this.toggleButtons[4].setValue(compound.method_68566("Small", false));
        this.toggleButtons[5].setValue(compound.method_68566("CustomNameVisible", false));
        this.lockButton.method_1895(compound.method_68566("Invulnerable", false));
        this.sizeField.method_1852(String.valueOf(compound.method_68563("Scale", 1.0)));
        Optional rotation = compound.method_67491("Rotation", class_241.field_56695);
        if (rotation.isPresent()) {
            this.rotationTextField.method_1852(String.valueOf(((class_241)rotation.get()).field_1343));
        }
        class_2487 poseTag = compound.method_68568("Pose");
        class_2379 poseHeadTag = poseTag.method_67491("Head", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[0].method_1852(String.valueOf(poseHeadTag.comp_3776()));
        this.poseTextFields[1].method_1852(String.valueOf(poseHeadTag.comp_3777()));
        this.poseTextFields[2].method_1852(String.valueOf(poseHeadTag.comp_3778()));
        class_2379 poseBodyTag = poseTag.method_67491("Body", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[3].method_1852(String.valueOf(poseBodyTag.comp_3776()));
        this.poseTextFields[4].method_1852(String.valueOf(poseBodyTag.comp_3777()));
        this.poseTextFields[5].method_1852(String.valueOf(poseBodyTag.comp_3778()));
        class_2379 poseLeftLegTag = poseTag.method_67491("LeftLeg", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[6].method_1852(String.valueOf(poseLeftLegTag.comp_3776()));
        this.poseTextFields[7].method_1852(String.valueOf(poseLeftLegTag.comp_3777()));
        this.poseTextFields[8].method_1852(String.valueOf(poseLeftLegTag.comp_3778()));
        class_2379 poseRightLegTag = poseTag.method_67491("RightLeg", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[9].method_1852(String.valueOf(poseRightLegTag.comp_3776()));
        this.poseTextFields[10].method_1852(String.valueOf(poseRightLegTag.comp_3777()));
        this.poseTextFields[11].method_1852(String.valueOf(poseRightLegTag.comp_3778()));
        class_2379 poseLeftArmTag = poseTag.method_67491("LeftArm", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[12].method_1852(String.valueOf(poseLeftArmTag.comp_3776()));
        this.poseTextFields[13].method_1852(String.valueOf(poseLeftArmTag.comp_3777()));
        this.poseTextFields[14].method_1852(String.valueOf(poseLeftArmTag.comp_3778()));
        class_2379 poseRightArmTag = poseTag.method_67491("RightArm", class_2379.field_57040).orElse(new class_2379(0.0f, 0.0f, 0.0f));
        this.poseTextFields[15].method_1852(String.valueOf(poseRightArmTag.comp_3776()));
        this.poseTextFields[16].method_1852(String.valueOf(poseRightArmTag.comp_3777()));
        this.poseTextFields[17].method_1852(String.valueOf(poseRightArmTag.comp_3778()));
        Optional optionalOffset = compound.method_67491("Move", class_243.field_38277);
        if (optionalOffset.isPresent()) {
            class_243 offset = (class_243)optionalOffset.get();
            this.poseTextFields[18].method_1852(String.valueOf(offset.method_10216() + this.lastSendOffset.field_1352));
            this.poseTextFields[19].method_1852(String.valueOf(offset.method_10214() + this.lastSendOffset.field_1351));
            this.poseTextFields[20].method_1852(String.valueOf(offset.method_10215() + this.lastSendOffset.field_1350));
            this.lastSendOffset = new class_243(offset.method_10216() + this.lastSendOffset.field_1352, offset.method_10214() + this.lastSendOffset.field_1351, offset.method_10215() + this.lastSendOffset.field_1350);
        }
    }

    public static void openScreen(class_1531 armorStandEntity) {
        class_310.method_1551().method_1507((class_437)new ArmorStandScreen(armorStandEntity));
    }

    public void updateEntity(class_2487 compound) {
        Services.PLATFORM.updateEntity(this.entityArmorStand, compound);
    }
}

