/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.client.gui.DeletePoseScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import com.mrbysco.armorposer.client.gui.widgets.PoseListWidget;
import com.mrbysco.armorposer.poses.UserPoseHandler;
import com.mrbysco.armorposer.util.PoseData;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ArmorPosesScreen
extends class_437 {
    private static final int PADDING = 6;
    private final PoseListWidget[] poseListWidget = new PoseListWidget[2];
    protected PoseListWidget.ListEntry selected = null;
    private List<PoseEntry> poses;
    private final List<PoseEntry> unsortedPoses;
    private List<PoseEntry> userPoses;
    private final List<PoseEntry> unsortedUserPoses;
    private class_4185 applyButton;
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private class_342 search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    public final ArmorStandScreen parentScreen;
    private final DeletePoseScreen deletePoseScreen;

    public ArmorPosesScreen(ArmorStandScreen parent) {
        super((class_2561)class_2561.method_43471((String)"armorposer.gui.poses.title"));
        this.parentScreen = parent;
        this.deletePoseScreen = new DeletePoseScreen(this);
        List rawPoses = Reference.defaultPoseMap.entrySet().stream().map(entry -> new PoseEntry((String)entry.getKey(), (String)entry.getValue(), false)).collect(Collectors.toList());
        this.unsortedPoses = Collections.unmodifiableList(rawPoses);
        Collections.sort(rawPoses);
        this.poses = Collections.unmodifiableList(rawPoses);
        UserPoseHandler.loadUserPoses();
        List rawUserPoses = Reference.userPoses.stream().map(entry -> new PoseEntry((PoseData)entry, true)).collect(Collectors.toList());
        this.unsortedUserPoses = Collections.unmodifiableList(rawUserPoses);
        Collections.sort(rawUserPoses);
        this.userPoses = Collections.unmodifiableList(rawUserPoses);
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        int centerWidth = this.field_22789 / 2;
        int listWidth = this.field_22789 / 4 + 20;
        int structureWidth = this.field_22789 - listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 160);
        int y = this.field_22790 - 20 - 6;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.method_25419()).method_46434(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).method_46431());
        this.applyButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorposer.gui.poses.selection.apply"), b -> {
            if (this.selected != null) {
                if (!this.selected.userAdded() && this.selected.rawName().equals("random")) {
                    for (int i = 0; i < this.parentScreen.poseTextFields.length - 3; ++i) {
                        float randomRotation = (float)(Math.random() * 70.0 - 35.0);
                        this.parentScreen.poseTextFields[i].method_1852(String.valueOf((int)randomRotation));
                    }
                } else {
                    this.parentScreen.readFieldsFromNBT(this.selected.getTag());
                }
                this.parentScreen.textFieldUpdated();
                this.parentScreen.updateEntity(this.selected.getTag());
            }
            this.method_25419();
        }).method_46434(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.applyButton);
        this.search = new class_342(this.getScreenFont(), centerWidth - listWidth / 2 + 6 + 1, y -= 20, listWidth - 2, 14, (class_2561)class_2561.method_43471((String)"armorposer.gui.poses.search"));
        this.search.method_25365(false);
        this.search.method_1856(true);
        this.method_37063((class_364)this.search);
        int fullButtonHeight = 32;
        class_5250 class_52502 = class_2561.method_43471((String)"armorposer.gui.poses.default");
        int n = this.search.method_46427();
        Objects.requireNonNull(this.getScreenFont());
        this.poseListWidget[0] = new PoseListWidget(this, (class_2561)class_52502, false, listWidth, fullButtonHeight, n - 9 - 6);
        this.poseListWidget[0].method_46421(0);
        this.poseListWidget[0].method_46419(16);
        this.poseListWidget[0].method_53533(this.field_22790);
        this.method_37063((class_364)this.poseListWidget[0]);
        class_5250 class_52503 = class_2561.method_43471((String)"armorposer.gui.poses.user");
        int n2 = this.search.method_46427();
        Objects.requireNonNull(this.getScreenFont());
        this.poseListWidget[1] = new PoseListWidget(this, (class_2561)class_52503, true, listWidth, fullButtonHeight, n2 - 9 - 6);
        this.poseListWidget[1].method_46421(this.field_22789 - listWidth);
        this.poseListWidget[1].method_46419(16);
        this.poseListWidget[1].method_53533(this.field_22790);
        this.method_37063((class_364)this.poseListWidget[1]);
        int width = listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = class_4185.method_46430((class_2561)SortType.A_TO_Z.getButtonText(), b -> this.resortPoses(SortType.A_TO_Z)).method_46434(x, 6, width - 1, 20).method_46431();
        this.method_37063((class_364)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = class_4185.method_46430((class_2561)SortType.Z_TO_A.getButtonText(), b -> this.resortPoses(SortType.Z_TO_A)).method_46434(x += width + 1, 6, width - 1, 20).method_46431();
        this.method_37063((class_364)SortType.Z_TO_A.button);
        this.resortPoses(SortType.A_TO_Z);
        this.updateCache();
    }

    public void method_25393() {
        if (this.poseListWidget[0].method_25396().contains((Object)this.selected)) {
            this.poseListWidget[0].setSelected(this.selected);
            this.poseListWidget[1].setSelected(null);
        } else if (this.poseListWidget[1].method_25396().contains((Object)this.selected)) {
            this.poseListWidget[0].setSelected(null);
            this.poseListWidget[1].setSelected(this.selected);
        }
        if (!this.search.method_1882().equals(this.lastFilterText)) {
            this.reloadPoses();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadPoses();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.poses);
                Collections.sort(this.userPoses);
            } else if (this.sortType == SortType.Z_TO_A) {
                this.poses.sort(Collections.reverseOrder());
                this.userPoses.sort(Collections.reverseOrder());
            }
            this.poseListWidget[0].refreshList(false);
            this.poseListWidget[1].refreshList(true);
            if (this.selected != null) {
                this.selected = this.poseListWidget[0].method_25396().stream().filter(e -> e == this.selected).findFirst().orElse(this.poseListWidget[1].method_25396().stream().filter(e -> e == this.selected).findFirst().orElse(null));
            }
            this.sorted = true;
        }
    }

    private void reloadPoses() {
        this.poses = this.unsortedPoses.stream().filter(entry -> entry.getName().getString().toLowerCase(Locale.ROOT).contains(this.search.method_1882().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        this.userPoses = this.unsortedUserPoses.stream().filter(entry -> entry.getName().getString().toLowerCase(Locale.ROOT).contains(this.search.method_1882().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        this.lastFilterText = this.search.method_1882();
    }

    public <T extends class_4280.class_4281<T>> void buildPoseList(Consumer<T> ListViewConsumer, Function<PoseEntry, T> newEntry) {
        this.poses.forEach(mod -> ListViewConsumer.accept((class_4280.class_4281)newEntry.apply((PoseEntry)mod)));
    }

    public <T extends class_4280.class_4281<T>> void buildUserPoseList(Consumer<T> ListViewConsumer, Function<PoseEntry, T> newEntry) {
        this.userPoses.forEach(mod -> ListViewConsumer.accept((class_4280.class_4281)newEntry.apply((PoseEntry)mod)));
    }

    private void resortPoses(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.field_22763 = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        class_5250 text = class_2561.method_43471((String)"armorposer.gui.poses.search");
        class_327 class_3272 = this.getScreenFont();
        int n = this.field_22789 / 2 + 6;
        int n2 = this.search.method_46427();
        Objects.requireNonNull(this.getScreenFont());
        guiGraphics.method_27534(class_3272, (class_2561)text, n, n2 - 9 - 2, -1);
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 261 && this.selected != null && this.selected.userAdded()) {
            this.field_22787.method_1507((class_437)this.deletePoseScreen);
        }
        if (this.poseListWidget[0].method_25404(event)) {
            return true;
        }
        if (this.poseListWidget[1].method_25404(event)) {
            return true;
        }
        return super.method_25404(event);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void setSelected(PoseListWidget.ListEntry previousEntry, PoseListWidget.ListEntry entry, boolean visible) {
        if (this.selected == previousEntry) {
            this.selected = entry;
        } else if (this.selected == null || entry != null) {
            this.selected = entry;
        }
        this.updateCache();
    }

    private void updateCache() {
        this.applyButton.field_22763 = this.selected != null;
    }

    public boolean method_25402(class_11909 buttonEvent, boolean flag) {
        boolean clicked = super.method_25402(buttonEvent, flag);
        if (buttonEvent.method_74245() == 1 && this.search.method_25405(buttonEvent.comp_4798(), buttonEvent.comp_4799())) {
            this.search.method_1852("");
        }
        return clicked;
    }

    public void method_25410(int width, int height) {
        String s = this.search.method_1882();
        SortType sort = this.sortType;
        PoseListWidget.ListEntry selected = this.selected;
        this.method_25423(width, height);
        this.search.method_1852(s);
        this.selected = selected;
        if (!this.search.method_1882().isEmpty()) {
            this.reloadPoses();
        }
        if (sort != SortType.NORMAL) {
            this.resortPoses(sort);
        }
        this.updateCache();
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parentScreen);
    }

    public class_310 getScreenMinecraft() {
        return this.field_22787;
    }

    public class_327 getScreenFont() {
        return this.field_22793;
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        class_4185 button;

        class_2561 getButtonText() {
            return class_2561.method_43471((String)("armorposer.gui.poses.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

